/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.embedded;

import java.io.InputStream;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.ff4j.FF4j;
import org.ff4j.core.Feature;
import org.ff4j.core.FlippingStrategy;
import org.ff4j.web.embedded.ConsoleConstants;

public final class ConsoleRenderer
implements ConsoleConstants {
    private static String htmlTemplate = null;
    private static String cssContent = null;
    private static String jsContent = null;
    static final String TABLE_FEATURES_FOOTER = "</tbody></table></form></fieldset>";
    static final String END_OF_LINE = "\r\n";
    static final String FF4J_VERSION = ConsoleRenderer.class.getPackage().getImplementationVersion();

    static final String renderTemplate(HttpServletRequest req) {
        if (htmlTemplate == null || htmlTemplate.isEmpty()) {
            String ctx = req.getContextPath() + req.getServletPath() + "";
            htmlTemplate = ConsoleRenderer.loadFileAsString("ff4j-template.html");
            htmlTemplate = htmlTemplate.replaceAll("\\{SERVLET_CONTEXT\\}", ctx);
            htmlTemplate = htmlTemplate.replaceAll("\\{VERSION\\}", FF4J_VERSION);
        }
        return htmlTemplate;
    }

    static final String renderFeatureRows(FF4j ff4j, HttpServletRequest req) {
        StringBuilder sb = new StringBuilder();
        Map mapOfFeatures = ff4j.getFeatures();
        for (String uid : mapOfFeatures.keySet()) {
            Feature currentFeature = (Feature)mapOfFeatures.get(uid);
            sb.append("<tr>\r\n");
            sb.append("<td><a class=\"ff4j-tooltip\" ");
            if (null != currentFeature.getDescription()) {
                sb.append(" tooltip=\"");
                sb.append(currentFeature.getDescription());
                sb.append("\"");
            }
            sb.append(">");
            sb.append(currentFeature.getUid());
            sb.append("</a>");
            sb.append("</td><td>");
            if (null != currentFeature.getGroup()) {
                sb.append(currentFeature.getGroup());
            } else {
                sb.append("--");
            }
            sb.append("</td><td>");
            Set permissions = currentFeature.getPermissions();
            if (null != permissions && !permissions.isEmpty()) {
                boolean first = true;
                for (String perm : permissions) {
                    if (!first) {
                        sb.append(",");
                    }
                    sb.append(perm);
                    first = false;
                }
            } else {
                sb.append("--");
            }
            sb.append("</td><td>");
            FlippingStrategy fs = currentFeature.getFlippingStrategy();
            if (null != fs) {
                sb.append(fs.getClass().getCanonicalName());
                sb.append("<br/>&nbsp;" + fs.getInitParams());
            } else {
                sb.append("--");
            }
            sb.append("</td><td style=\"width:8%;text-align:center\">");
            sb.append("<label class=\"switch switch-green\">");
            sb.append("<input id=\"" + currentFeature.getUid() + "\" type=\"checkbox\" class=\"switch-input\"");
            sb.append(" onclick=\"javascript:toggle(this)\" ");
            if (currentFeature.isEnable()) {
                sb.append(" checked");
            }
            sb.append(">");
            sb.append("<span class=\"switch-label\" data-on=\"On\" data-off=\"Off\"></span>");
            sb.append("<span class=\"switch-handle\"></span>");
            sb.append("</label>");
            sb.append("</td><td style=\"width:5%;text-align:center\">");
            sb.append("<a data-toggle=\"modal\" href=\"#modalEdit\" data-id=\"" + currentFeature.getUid() + "\" ");
            sb.append(" data-desc=\"" + currentFeature.getDescription() + "\"");
            sb.append(" data-group=\"" + currentFeature.getGroup() + "\"");
            sb.append(" data-strategy=\"");
            if (null != currentFeature.getFlippingStrategy()) {
                sb.append(currentFeature.getFlippingStrategy().getClass().getCanonicalName());
            }
            sb.append("\" data-stratparams=\"");
            if (null != currentFeature.getFlippingStrategy()) {
                sb.append(currentFeature.getFlippingStrategy().getInitParams());
            }
            sb.append("\" data-permissions=\"");
            if (null != currentFeature.getPermissions() && !currentFeature.getPermissions().isEmpty()) {
                sb.append(currentFeature.getPermissions());
            }
            sb.append("\" style=\"width:6px;\" class=\"open-EditFlipDialog btn\">");
            sb.append("<i class=\"icon-pencil\" style=\"margin-left:-5px;\"></i></a>");
            sb.append("</td><td style=\"width:5%;text-align:center\">");
            sb.append("<a href=\"");
            sb.append(req.getContextPath());
            sb.append(req.getServletPath());
            sb.append("?op=delete&uid=" + uid);
            sb.append("\" style=\"width:6px;\" class=\"btn\">");
            sb.append("<i class=\"icon-trash\" style=\"margin-left:-5px;\"></i>");
            sb.append("</a>");
            sb.append("</td></tr>");
        }
        return sb.toString();
    }

    static String renderMessageBox(String message, String type) {
        StringBuilder sb = new StringBuilder();
        if (message != null && !message.isEmpty()) {
            sb.append("<div class=\"alert alert-" + type + "\" >");
            sb.append("<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>");
            sb.append("<span style=\"font-style:normal;color:#696969;\">");
            sb.append(message);
            sb.append("</span>");
            sb.append("</div>");
        }
        return sb.toString();
    }

    static String renderGroupList(FF4j ff4j, String modalId) {
        StringBuilder sb = new StringBuilder();
        if (null != ff4j.getStore().readAllGroups()) {
            for (String group : ff4j.getStore().readAllGroups()) {
                sb.append("<li><a href=\"javascript:\\$('\\#" + modalId + " \\#groupName').val('");
                sb.append(group);
                sb.append("');\">");
                sb.append(group);
                sb.append("</a></li>");
            }
        }
        return sb.toString();
    }

    static String renderPermissionList(FF4j ff4j) {
        StringBuilder sb = new StringBuilder("<br/>");
        if (null != ff4j.getAuthorizationsManager()) {
            for (String permission : ff4j.getAuthorizationsManager().listAllPermissions()) {
                sb.append("\r\n<br/>&nbsp;&nbsp;&nbsp;<input type=\"checkbox\" ");
                sb.append(" name=\"perm-check-" + permission + "\"");
                sb.append(" id=\"perm-check-" + permission + "\" >&nbsp;");
                sb.append(permission);
            }
        }
        return sb.toString();
    }

    static final String getCSS() {
        if (null == cssContent) {
            cssContent = ConsoleRenderer.loadFileAsString("ff4j-embedded.css");
        }
        return cssContent;
    }

    static final String getJS() {
        if (null == jsContent) {
            jsContent = ConsoleRenderer.loadFileAsString("ff4j-embedded.js");
        }
        return jsContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadFileAsString(String fileName) {
        InputStream in = ConsoleRenderer.class.getClassLoader().getResourceAsStream(fileName);
        if (in == null) {
            throw new IllegalArgumentException("Cannot load file " + fileName + " from classpath");
        }
        Scanner currentScan = null;
        StringBuilder strBuilder = new StringBuilder();
        try {
            currentScan = new Scanner(in, "UTF-8");
            while (currentScan.hasNextLine()) {
                strBuilder.append(currentScan.nextLine());
                strBuilder.append(NEW_LINE);
            }
        }
        finally {
            if (currentScan != null) {
                currentScan.close();
            }
        }
        return strBuilder.toString();
    }
}

