/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.store;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.ff4j.core.Feature;
import org.ff4j.core.FeatureStore;
import org.ff4j.exception.FeatureAccessException;
import org.ff4j.exception.FeatureAlreadyExistException;
import org.ff4j.exception.FeatureNotFoundException;
import org.ff4j.exception.GroupNotFoundException;
import org.ff4j.utils.FeatureJsonMarshaller;
import org.ff4j.web.api.FF4jWebConstants;

public class FeatureStoreHttp
implements FeatureStore,
FF4jWebConstants {
    protected Client client = null;
    private String url = null;
    private WebResource storeWebRsc = null;
    private WebResource groupsWebRsc = null;

    public FeatureStoreHttp() {
    }

    public FeatureStoreHttp(String rootApiUrl) {
        this.url = rootApiUrl;
    }

    private void initJerseyClient() {
        if (this.client == null) {
            DefaultClientConfig config = new DefaultClientConfig();
            this.client = Client.create((ClientConfig)config);
        }
        if (this.url == null) {
            throw new IllegalArgumentException("Cannot initialialize Jersey Client : please provide store URL in 'url' attribute");
        }
    }

    private WebResource getStore() {
        if (this.storeWebRsc == null) {
            this.initJerseyClient();
            this.storeWebRsc = this.client.resource(this.url).path("store").path("features");
        }
        return this.storeWebRsc;
    }

    private WebResource getGroups() {
        if (this.groupsWebRsc == null) {
            this.initJerseyClient();
            this.groupsWebRsc = this.client.resource(this.url).path("store").path("groups");
        }
        return this.groupsWebRsc;
    }

    public Feature read(String uid) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier cannot be null nor empty");
        }
        ClientResponse cRes = (ClientResponse)this.getStore().path(uid).get(ClientResponse.class);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new FeatureNotFoundException(uid);
        }
        return FeatureJsonMarshaller.unMarshallFeature((String)((String)cRes.getEntity(String.class)));
    }

    public void enable(String uid) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier cannot be null nor empty");
        }
        ClientResponse cRes = (ClientResponse)this.getStore().path(uid).path("enable").post(ClientResponse.class);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new FeatureNotFoundException(uid);
        }
    }

    public void disable(String uid) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier cannot be null nor empty");
        }
        ClientResponse cRes = (ClientResponse)this.storeWebRsc.path(uid).path("disable").post(ClientResponse.class);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new FeatureNotFoundException(uid);
        }
    }

    public boolean exist(String uid) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier cannot be null nor empty");
        }
        ClientResponse cRes = (ClientResponse)this.getStore().path(uid).get(ClientResponse.class);
        if (Response.Status.OK.getStatusCode() == cRes.getStatus()) {
            return true;
        }
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            return false;
        }
        throw new FeatureAccessException("Cannot check existence of feature, an HTTP error " + cRes.getStatus() + " occured.");
    }

    public void create(Feature fp) {
        if (fp == null) {
            throw new IllegalArgumentException("Feature cannot be null nor empty");
        }
        if (this.exist(fp.getUid())) {
            throw new FeatureAlreadyExistException(fp.getUid());
        }
        ClientResponse cRes = (ClientResponse)this.getStore().path(fp.getUid()).put(ClientResponse.class, (Object)fp.toString().getBytes());
        if (Response.Status.CREATED.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot create feature, an HTTP error " + cRes.getStatus() + " occured.");
        }
    }

    public Map<String, Feature> readAll() {
        ClientResponse cRes = (ClientResponse)this.getStore().get(ClientResponse.class);
        if (Response.Status.OK.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot read features, an HTTP error " + cRes.getStatus() + " occured.");
        }
        String resEntity = (String)cRes.getEntity(String.class);
        Feature[] fArray = FeatureJsonMarshaller.unMarshallFeatureArray((String)resEntity);
        HashMap<String, Feature> features = new HashMap<String, Feature>();
        for (Feature feature : fArray) {
            features.put(feature.getUid(), feature);
        }
        return features;
    }

    public void delete(String uid) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier cannot be null nor empty");
        }
        ClientResponse cRes = (ClientResponse)this.getStore().path(uid).delete(ClientResponse.class);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new FeatureNotFoundException(uid);
        }
        if (Response.Status.NO_CONTENT.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot delete feature, an HTTP error " + cRes.getStatus() + " occured.");
        }
    }

    public void update(Feature fp) {
        if (fp == null) {
            throw new IllegalArgumentException("Feature cannot be null nor empty");
        }
        if (!this.exist(fp.getUid())) {
            throw new FeatureNotFoundException(fp.getUid());
        }
        ClientResponse cRes = (ClientResponse)this.getStore().path(fp.getUid()).put(ClientResponse.class, (Object)fp.toString().getBytes());
        if (Response.Status.NO_CONTENT.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot update feature, an HTTP error " + cRes.getStatus() + " occured.");
        }
    }

    public void grantRoleOnFeature(String uid, String roleName) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier cannot be null nor empty");
        }
        if (roleName == null || roleName.isEmpty()) {
            throw new IllegalArgumentException("roleName cannot be null nor empty");
        }
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        formData.add((Object)"rolename", (Object)roleName);
        ClientResponse cRes = (ClientResponse)this.getStore().path(uid).path("grantrole").post(ClientResponse.class, (Object)formData);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new FeatureNotFoundException(uid);
        }
        if (Response.Status.NO_CONTENT.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot grant role on feature, an HTTP error " + cRes.getStatus() + " occured.");
        }
    }

    public void removeRoleFromFeature(String uid, String roleName) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier cannot be null nor empty");
        }
        if (roleName == null || roleName.isEmpty()) {
            throw new IllegalArgumentException("roleName cannot be null nor empty");
        }
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier cannot be null nor empty");
        }
        if (roleName == null || roleName.isEmpty()) {
            throw new IllegalArgumentException("roleName cannot be null nor empty");
        }
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        formData.add((Object)"rolename", (Object)roleName);
        ClientResponse cRes = (ClientResponse)this.getStore().path(uid).path("removerole").post(ClientResponse.class, (Object)formData);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new FeatureNotFoundException(uid);
        }
        if (Response.Status.NO_CONTENT.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot remove role on feature, an HTTP error " + cRes.getStatus() + " occured.");
        }
    }

    public void addToGroup(String uid, String groupName) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier cannot be null nor empty");
        }
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException("Groupname cannot be null nor empty");
        }
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        formData.add((Object)"groupName", (Object)groupName);
        ClientResponse cRes = (ClientResponse)this.getStore().path(uid).path("addGroup").post(ClientResponse.class, (Object)formData);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new FeatureNotFoundException(uid);
        }
        if (Response.Status.NO_CONTENT.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot add feature to group, an HTTP error " + cRes.getStatus() + " occured.");
        }
    }

    public void removeFromGroup(String uid, String groupName) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier cannot be null nor empty");
        }
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException("Groupname cannot be null nor empty");
        }
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier cannot be null nor empty");
        }
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException("Groupname cannot be null nor empty");
        }
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        formData.add((Object)"groupName", (Object)groupName);
        ClientResponse cRes = (ClientResponse)this.getStore().path(uid).path("removeGroup").post(ClientResponse.class, (Object)formData);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            String errorMsg = (String)cRes.getEntity(String.class);
            if (errorMsg.contains("group")) {
                throw new GroupNotFoundException(groupName);
            }
            throw new FeatureNotFoundException(uid);
        }
        if (Response.Status.NO_CONTENT.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot remove feature from group, an HTTP error " + cRes.getStatus() + " occured.");
        }
    }

    public void enableGroup(String groupName) {
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException("Groupname cannot be null nor empty");
        }
        ClientResponse cRes = (ClientResponse)this.getGroups().path(groupName).path("enable").post(ClientResponse.class);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new GroupNotFoundException(groupName);
        }
        if (Response.Status.NO_CONTENT.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot grant role on feature, an HTTP error " + cRes.getStatus() + " occured.");
        }
    }

    public void disableGroup(String groupName) {
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException("Groupname cannot be null nor empty");
        }
        ClientResponse cRes = (ClientResponse)this.getGroups().path(groupName).path("disable").post(ClientResponse.class);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new GroupNotFoundException(groupName);
        }
        if (Response.Status.NO_CONTENT.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot grant role on feature, an HTTP error " + cRes.getStatus() + " occured.");
        }
    }

    public Map<String, Feature> readGroup(String groupName) {
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException("Groupname cannot be null nor empty");
        }
        ClientResponse cRes = (ClientResponse)this.getGroups().path(groupName).get(ClientResponse.class);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new GroupNotFoundException(groupName);
        }
        if (Response.Status.OK.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot grant role on feature, an HTTP error " + cRes.getStatus() + " occured.");
        }
        String resEntity = (String)cRes.getEntity(String.class);
        Feature[] fArray = FeatureJsonMarshaller.unMarshallFeatureArray((String)resEntity);
        HashMap<String, Feature> features = new HashMap<String, Feature>();
        for (Feature feature : fArray) {
            features.put(feature.getUid(), feature);
        }
        return features;
    }

    public boolean existGroup(String groupName) {
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException("Groupname cannot be null nor empty");
        }
        ClientResponse cRes = (ClientResponse)this.getGroups().path(groupName).get(ClientResponse.class);
        if (Response.Status.OK.getStatusCode() == cRes.getStatus()) {
            return true;
        }
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            return false;
        }
        throw new FeatureAccessException("Cannot check existence of group , an HTTP error " + cRes.getStatus() + " occured.");
    }

    public Set<String> readAllGroups() {
        ClientResponse cRes = (ClientResponse)this.getGroups().get(ClientResponse.class);
        if (Response.Status.OK.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot read groups, an HTTP error " + cRes.getStatus() + " occured.");
        }
        return this.readGroupList((String)cRes.getEntity(String.class));
    }

    private Set<String> readGroupList(String jsonOutput) {
        String resEntity = jsonOutput.substring(2, jsonOutput.length() - 1);
        String[] features = resEntity.split("\\,");
        HashSet<String> groups = new HashSet<String>();
        for (String string : features) {
            groups.add(string.substring(1, string.indexOf(":") - 1));
        }
        return groups;
    }
}

