/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.ff4j.web.api.FF4JProvider;
import org.ff4j.web.embedded.ConsoleConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FF4jInitServlet
extends HttpServlet
implements ConsoleConstants {
    private static final long serialVersionUID = 8447941463286918975L;
    public Logger logger = LoggerFactory.getLogger(this.getClass());

    public void init(ServletConfig servletConfig) throws ServletException {
        this.logger.debug("Insert FF4J into web session");
        String className = servletConfig.getInitParameter("ff4jProvider");
        if (className == null) {
            throw new IllegalStateException("Cannot initialize Servlet " + this.getClass() + " : expecting parameter'" + "ff4jProvider" + "'");
        }
        FF4JProvider ff4jProvider = null;
        try {
            Class<?> c = Class.forName(className);
            Object o = c.newInstance();
            ff4jProvider = (FF4JProvider)o;
            this.logger.info("  __  __ _  _   _ ");
            this.logger.info(" / _|/ _| || | (_)");
            this.logger.info("| |_| |_| || |_| |");
            this.logger.info("|  _|  _|__   _| |");
            this.logger.info("|_| |_|    |_|_/ |");
            this.logger.info("             |__/  .v" + this.getClass().getPackage().getImplementationVersion());
            this.logger.info(" ");
            servletConfig.getServletContext().setAttribute("FF4J", (Object)ff4jProvider.getFF4j());
            this.logger.info("ff4j class is now available in Session under 'FF4J' attribute name (required for taglib)");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Cannot load ff4jProvider as " + ff4jProvider, e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Cannot instanciate  " + ff4jProvider + " as ff4jProvider", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("No public constructor for  " + ff4jProvider + " as ff4jProvider", e);
        }
        catch (ClassCastException ce) {
            throw new IllegalArgumentException("ff4jProvider expected instance of " + FF4JProvider.class, ce);
        }
    }
}

