/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.api.conf;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.ff4j.FF4j;
import org.ff4j.web.api.FF4JProvider;
import org.ff4j.web.api.FF4jWebConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FF4jApiConfig
implements FF4JProvider,
FF4jWebConstants {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private FF4j fF4j;
    private boolean enableAuthentication = false;
    private boolean enableAuthorization = false;
    private boolean enableLogging = false;
    private boolean enableDocumentation = true;
    private String versionNumber = this.getClass().getPackage().getImplementationVersion();
    private Map<String, String> users = new HashMap<String, String>();
    private Set<String> apiKeys = new HashSet<String>();
    private Map<String, Set<String>> permissions = new HashMap<String, Set<String>>();
    private String contextPath = "http://localhost:8081/ff4j-demo/api";

    public FF4jApiConfig() {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("/META-INF/MANIFEST.MF");
        if (inputStream != null) {
            try {
                Manifest mFile = new Manifest(inputStream);
                this.versionNumber = (String)mFile.getMainAttributes().get(new Attributes.Name("Specification-Version"));
            }
            catch (IOException ieo) {
                this.log.error("Cannot read version number from manifest", (Throwable)ieo);
            }
        }
    }

    public FF4jApiConfig(FF4j ff) {
        this();
        this.fF4j = ff;
    }

    public FF4jApiConfig enableDocumentation() {
        this.enableDocumentation = true;
        return this;
    }

    public FF4jApiConfig disableDocumentation() {
        this.enableDocumentation = false;
        return this;
    }

    public FF4jApiConfig enableAuthentication() {
        this.enableAuthentication = true;
        return this;
    }

    public FF4jApiConfig disableAuthentication() {
        this.enableAuthentication = false;
        return this;
    }

    public FF4jApiConfig disableAuthorization() {
        this.enableAuthorization = false;
        return this;
    }

    public FF4jApiConfig enableAuthorization() {
        this.enableAuthorization = true;
        return this;
    }

    public FF4jApiConfig createUser(String userName, String password, boolean read, boolean write, Set<String> usrPerm) {
        this.users.put(userName, password);
        HashSet<String> tmpPerm = new HashSet<String>();
        if (read) {
            tmpPerm.add("READ");
        }
        if (write) {
            tmpPerm.add("WRITE");
        }
        if (usrPerm != null) {
            tmpPerm.addAll(usrPerm);
        }
        this.permissions.put(userName, tmpPerm);
        return this;
    }

    public FF4jApiConfig createApiKey(String apiKey, boolean read, boolean write, Set<String> usrPerm) {
        this.apiKeys.add(apiKey);
        HashSet<String> tmpPerm = new HashSet<String>();
        if (read) {
            tmpPerm.add("READ");
        }
        if (write) {
            tmpPerm.add("WRITE");
        }
        if (usrPerm != null) {
            tmpPerm.addAll(usrPerm);
        }
        this.permissions.put(apiKey, tmpPerm);
        return this;
    }

    @Override
    public FF4j getFF4j() {
        return this.fF4j;
    }

    public void setFF4j(FF4j fF4j) {
        this.fF4j = fF4j;
    }

    public boolean isEnableAuthentication() {
        return this.enableAuthentication;
    }

    public void setEnableAuthentication(boolean enableAuthentication) {
        this.enableAuthentication = enableAuthentication;
    }

    public boolean isEnableAuthorization() {
        return this.enableAuthorization;
    }

    public void setEnableAuthorization(boolean enableAuthorization) {
        this.enableAuthorization = enableAuthorization;
    }

    public boolean isEnableLogging() {
        return this.enableLogging;
    }

    public void setEnableLogging(boolean enableLogging) {
        this.enableLogging = enableLogging;
    }

    public Map<String, String> getUsers() {
        return this.users;
    }

    public void setUsers(Map<String, String> users) {
        this.users = users;
    }

    public Set<String> getApiKeys() {
        return this.apiKeys;
    }

    public void setApiKeys(Set<String> apiKeys) {
        this.apiKeys = apiKeys;
    }

    public Map<String, Set<String>> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Map<String, Set<String>> permissions) {
        this.permissions = permissions;
    }

    public boolean isEnableDocumentation() {
        return this.enableDocumentation;
    }

    public void setEnableDocumentation(boolean enableDocumentation) {
        this.enableDocumentation = enableDocumentation;
    }

    public String getVersionNumber() {
        return this.versionNumber;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }
}

