/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.api.jersey;

import com.sun.jersey.api.container.filter.LoggingFilter;
import com.sun.jersey.api.core.PackagesResourceConfig;
import com.sun.jersey.spi.inject.SingletonTypeInjectableProvider;
import com.wordnik.swagger.config.ConfigFactory;
import com.wordnik.swagger.config.Scanner;
import com.wordnik.swagger.config.ScannerFactory;
import com.wordnik.swagger.config.SwaggerConfig;
import com.wordnik.swagger.jaxrs.config.DefaultJaxrsScanner;
import com.wordnik.swagger.jaxrs.listing.ApiDeclarationProvider;
import com.wordnik.swagger.jaxrs.listing.ApiListingResourceJSON;
import com.wordnik.swagger.jaxrs.listing.ResourceListingProvider;
import com.wordnik.swagger.jaxrs.reader.DefaultJaxrsApiReader;
import com.wordnik.swagger.reader.ClassReader;
import com.wordnik.swagger.reader.ClassReaders;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Context;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;
import org.ff4j.FF4j;
import org.ff4j.web.api.FF4jWebConstants;
import org.ff4j.web.api.conf.FF4jApiConfig;
import org.ff4j.web.api.jersey.FF4jJacksonMapper;
import org.ff4j.web.api.resources.FF4jResource;
import org.ff4j.web.api.security.FF4jRolesResourceFilterFactory;
import org.ff4j.web.api.security.FF4jSecurityContextFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationPath(value="api")
public abstract class FF4JApiApplication
extends PackagesResourceConfig
implements FF4jWebConstants {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    protected abstract FF4jApiConfig getApiConfig();

    public FF4JApiApplication() {
        super(new String[]{FF4jResource.class.getPackage().getName()});
        FF4jApiConfig conf;
        this.log.info("  __  __ _  _   _ ");
        this.log.info(" / _|/ _| || | (_)");
        this.log.info("| |_| |_| || |_| |");
        this.log.info("|  _|  _|__   _| |");
        this.log.info("|_| |_|    |_|_/ |");
        this.log.info("             |__/   WEB API Initialization...");
        this.log.info(" ");
        FF4jSecurityContextFilter.securityConfig = conf = this.getApiConfig();
        FF4jRolesResourceFilterFactory.apiConfig = conf;
        this.getSingletons().add(new FF4jInjectableProvider(conf.getFF4j()));
        this.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
        this.getSingletons().add(new JacksonJsonProvider());
        this.getSingletons().add(new FF4jJacksonMapper());
        if (conf.isEnableAuthorization()) {
            this.getProperties().put("com.sun.jersey.spi.container.ResourceFilters", FF4jRolesResourceFilterFactory.class.getCanonicalName());
            this.log.info("ff4j webApi security has been set up with both authentication and authorization");
        } else if (conf.isEnableAuthentication()) {
            StringBuilder filters = new StringBuilder();
            filters.append(FF4jSecurityContextFilter.class.getCanonicalName());
            if (conf.isEnableLogging()) {
                filters.append(";" + LoggingFilter.class.getCanonicalName());
            }
            this.getProperties().put("com.sun.jersey.spi.container.ContainerRequestFilters", filters.toString());
            this.log.info("ff4j webApi security has been set up with authentication only");
        } else {
            this.log.info("ff4j webApi security has been set up with no security");
        }
        if (conf.isEnableDocumentation()) {
            this.getSingletons().add(new ApiListingResourceJSON());
            this.getSingletons().add(new ApiDeclarationProvider());
            this.getSingletons().add(new ResourceListingProvider());
            ScannerFactory.setScanner((Scanner)new DefaultJaxrsScanner());
            ClassReaders.setReader((ClassReader)new DefaultJaxrsApiReader());
            SwaggerConfig config = ConfigFactory.config();
            config.setApiVersion(this.getClass().getPackage().getImplementationVersion());
            config.setBasePath(conf.getContextPath());
            config.setApiPath("/api");
        }
    }

    public static class FF4jInjectableProvider
    extends SingletonTypeInjectableProvider<Context, FF4j> {
        public FF4jInjectableProvider(FF4j ff4j) {
            super(FF4j.class, (Object)ff4j);
        }
    }
}

