/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.api.resources;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.ff4j.core.Feature;
import org.ff4j.core.FlippingStrategy;
import org.ff4j.exception.FeatureNotFoundException;
import org.ff4j.web.api.resources.AbstractResource;
import org.ff4j.web.api.resources.domain.FeatureApiBean;
import org.ff4j.web.api.resources.domain.FlippingStrategyApiBean;

@Path(value="/ff4j/store/features/{uid}")
@Produces(value={"application/json"})
@RolesAllowed(value={"WRITE"})
@Api(value="/ff4j/store/features/{uid}", description="Resource to work with <b>single feature</b>")
public class FeatureResource
extends AbstractResource {
    @GET
    @RolesAllowed(value={"READ"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Read information about a feature", response=FeatureApiBean.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Information about features"), @ApiResponse(code=404, message="Feature not found")})
    public Response read(@PathParam(value="uid") String id) {
        if (!this.ff4j.getFeatureStore().exist(id)) {
            String errMsg = new FeatureNotFoundException(id).getMessage();
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        return Response.ok((Object)new FeatureApiBean(this.ff4j.getFeatureStore().read(id))).build();
    }

    @PUT
    @RolesAllowed(value={"WRITE"})
    @ApiOperation(value="Create of update a feature", response=Response.class)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=201, message="Feature has been created"), @ApiResponse(code=204, message="No content, feature is updated")})
    public Response upsertFeature(@Context HttpHeaders headers, @PathParam(value="uid") String id, FeatureApiBean fApiBean) {
        if ("".equals(id) || !id.equals(fApiBean.getUid())) {
            String errMsg = "Invalid identifier expected " + id;
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
        Feature feat = new Feature(id);
        feat.setDescription(fApiBean.getDescription());
        feat.setEnable(fApiBean.isEnable());
        feat.setGroup(fApiBean.getGroup());
        feat.setPermissions(new HashSet<String>(fApiBean.getPermissions()));
        FlippingStrategyApiBean flipApiBean = fApiBean.getFlippingStrategy();
        if (flipApiBean != null) {
            FlippingStrategy strategy = null;
            try {
                strategy = (FlippingStrategy)Class.forName(flipApiBean.getType()).newInstance();
                Map<String, String> initparams = flipApiBean.getInitParams();
                strategy.init(id, initparams);
            }
            catch (InstantiationException e) {
                String errMsg = "Cannot read Flipping Strategy, does not seems to have a DEFAULT constructor, " + e.getMessage();
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
            }
            catch (IllegalAccessException e) {
                String errMsg = "Cannot read Flipping Strategy,does not seems to have a PUBLIC constructor, " + e.getMessage();
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
            }
            catch (ClassNotFoundException e) {
                String errMsg = "Cannot read Flipping Strategy, className has not been found within classpath, check syntax, " + e.getMessage();
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
            }
            feat.setFlippingStrategy(strategy);
        }
        if (!this.getFeatureStore().exist(feat.getUid())) {
            this.getFeatureStore().create(feat);
            String location = String.format("%s", this.uriInfo.getAbsolutePath().toString());
            try {
                return Response.created((URI)new URI(location)).build();
            }
            catch (URISyntaxException e) {
                return Response.status((Response.Status)Response.Status.CREATED).header("Location", (Object)location).entity((Object)id).build();
            }
        }
        this.getFeatureStore().update(feat);
        return Response.noContent().build();
    }

    @DELETE
    @RolesAllowed(value={"WRITE"})
    @Produces(value={"text/plain"})
    @ApiOperation(value="Delete a feature", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Feature has not been found"), @ApiResponse(code=204, message="No content, feature is deleted"), @ApiResponse(code=400, message="Bad identifier")})
    public Response deleteFeature(@PathParam(value="uid") String id) {
        if (id == null || "".equals(id)) {
            String errMsg = "Invalid URL : Must be '/features/{uid}' with {uid} not null nor empty";
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
        if (!this.ff4j.getFeatureStore().exist(id)) {
            String errMsg = new FeatureNotFoundException(id).getMessage();
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        this.getFeatureStore().delete(id);
        return Response.noContent().build();
    }

    @POST
    @Path(value="/enable")
    @RolesAllowed(value={"WRITE"})
    @ApiOperation(value="Enable a feature", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=204, message="Features has been enabled"), @ApiResponse(code=404, message="Feature not found")})
    public Response operationEnable(@PathParam(value="uid") String id) {
        if (!this.ff4j.getFeatureStore().exist(id)) {
            String errMsg = new FeatureNotFoundException(id).getMessage();
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        this.getFeatureStore().enable(id);
        return Response.noContent().build();
    }

    @POST
    @Path(value="/disable")
    @RolesAllowed(value={"WRITE"})
    @ApiOperation(value="Disable a feature", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=204, message="Features has been disabled"), @ApiResponse(code=404, message="Feature not found")})
    public Response operationDisable(@PathParam(value="uid") String id) {
        if (!this.ff4j.getFeatureStore().exist(id)) {
            String errMsg = new FeatureNotFoundException(id).getMessage();
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        this.getFeatureStore().disable(id);
        return Response.noContent().build();
    }

    @POST
    @RolesAllowed(value={"WRITE"})
    @Path(value="/grantrole/{role}")
    @ApiOperation(value="Grant a permission on a feature", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=204, message="Permission has been granted"), @ApiResponse(code=404, message="Feature not found"), @ApiResponse(code=400, message="Invalid RoleName")})
    public Response operationGrantRole(@PathParam(value="uid") String id, @PathParam(value="role") String role) {
        if (!this.ff4j.getFeatureStore().exist(id)) {
            String errMsg = new FeatureNotFoundException(id).getMessage();
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        if ("".equals(role)) {
            String errMsg = "Invalid role should not be null nor empty";
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
        this.getFeatureStore().grantRoleOnFeature(id, role);
        return Response.noContent().build();
    }

    @POST
    @RolesAllowed(value={"WRITE"})
    @Path(value="/removerole/{role}")
    @ApiOperation(value="Remove a permission on a feature", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=204, message="Permission has been granted"), @ApiResponse(code=404, message="Feature not found"), @ApiResponse(code=400, message="Invalid RoleName")})
    public Response operationRemoveRole(@PathParam(value="uid") String id, @PathParam(value="role") String role) {
        if (!this.ff4j.getFeatureStore().exist(id)) {
            String errMsg = new FeatureNotFoundException(id).getMessage();
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        Set permissions = this.ff4j.getFeatureStore().read(id).getPermissions();
        if (!permissions.contains(role)) {
            String errMsg = "Invalid role should be within " + permissions;
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
        this.getFeatureStore().removeRoleFromFeature(id, role);
        return Response.noContent().build();
    }

    @POST
    @RolesAllowed(value={"WRITE"})
    @Path(value="/addGroup/{groupName}")
    @ApiOperation(value="Define the group of the feature", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=204, message="Group has been defined"), @ApiResponse(code=404, message="Feature not found"), @ApiResponse(code=400, message="Invalid GroupName")})
    public Response operationAddGroup(@PathParam(value="uid") String id, @PathParam(value="groupName") String groupName) {
        if (!this.ff4j.getFeatureStore().exist(id)) {
            String errMsg = new FeatureNotFoundException(id).getMessage();
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        if ("".equals(groupName)) {
            String errMsg = "Invalid groupName should not be null nor empty";
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
        this.getFeatureStore().addToGroup(id, groupName);
        return Response.noContent().build();
    }

    @POST
    @RolesAllowed(value={"WRITE"})
    @Path(value="/removeGroup/{groupName}")
    @ApiOperation(value="Remove the group of the feature", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=204, message="Group has been removed"), @ApiResponse(code=404, message="Feature not found"), @ApiResponse(code=400, message="Invalid GroupName")})
    public Response operationRemoveGroup(@PathParam(value="uid") String id, @PathParam(value="groupName") String groupName) {
        if (!this.ff4j.getFeatureStore().exist(id)) {
            String errMsg = new FeatureNotFoundException(id).getMessage();
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        if (!this.ff4j.getFeatureStore().existGroup(groupName)) {
            String errMsg = "Invalid groupName should be " + groupName;
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errMsg).build();
        }
        this.getFeatureStore().removeFromGroup(id, groupName);
        return Response.noContent().build();
    }
}

