/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.api.resources;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.ff4j.cache.FeatureStoreCacheProxy;
import org.ff4j.core.Feature;
import org.ff4j.web.api.resources.AbstractResource;
import org.ff4j.web.api.resources.domain.CacheApiBean;
import org.ff4j.web.api.resources.domain.EventRepositoryApiBean;
import org.ff4j.web.api.resources.domain.FeatureApiBean;
import org.ff4j.web.api.resources.domain.FeatureStoreApiBean;
import org.ff4j.web.api.resources.domain.GroupDescApiBean;

@Path(value="/ff4j/store")
@Produces(value={"application/json"})
@RolesAllowed(value={"READ"})
@Api(value="/ff4j/store", description="Administrate Features, Groups and Cache")
public class FeatureStoreResource
extends AbstractResource {
    @GET
    @ApiOperation(value="Display information regarding to <b>Features</b>", notes="other sub resources to be displayed", response=FeatureStoreApiBean.class)
    @ApiResponses(value={@ApiResponse(code=200, message="status of current ff4j bean")})
    @Produces(value={"application/json"})
    public FeatureStoreApiBean get() {
        return new FeatureStoreApiBean(this.ff4j.getFeatureStore());
    }

    @GET
    @Path(value="/features")
    @Produces(value={"application/json"})
    @ApiOperation(value="Display information regarding <b>Features</b>", response=EventRepositoryApiBean.class)
    @ApiResponses(value={@ApiResponse(code=200, message="get all features")})
    public List<FeatureApiBean> readFeatures() {
        Feature[] storeContent = this.getFeatureStore().readAll().values().toArray(new Feature[0]);
        ArrayList<FeatureApiBean> apiBean = new ArrayList<FeatureApiBean>();
        for (Feature feature : storeContent) {
            apiBean.add(new FeatureApiBean(feature));
        }
        return apiBean;
    }

    @GET
    @Path(value="/groups")
    @Produces(value={"application/json"})
    @ApiOperation(value="Display information regarding <b>Groups</b>", response=GroupDescApiBean.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Groups resource", response=GroupDescApiBean.class)})
    public List<GroupDescApiBean> readGroups() {
        Map features = this.getFeatureStore().readAll();
        HashMap<String, GroupDescApiBean> groups = new HashMap<String, GroupDescApiBean>();
        if (features != null && !features.isEmpty()) {
            for (String featureName : features.keySet()) {
                String groupName = ((Feature)features.get(featureName)).getGroup();
                if (groupName == null || groupName.isEmpty()) continue;
                if (!groups.containsKey(groupName)) {
                    groups.put(groupName, new GroupDescApiBean(groupName, new ArrayList<String>()));
                }
                ((GroupDescApiBean)groups.get(groupName)).getFeatures().add(featureName);
            }
        }
        return new ArrayList<GroupDescApiBean>(groups.values());
    }

    @GET
    @Path(value="/cache")
    @Produces(value={"application/json"})
    @ApiOperation(value="Display information related to <b>Cache</b>")
    @ApiResponses(value={@ApiResponse(code=200, message="status of current ff4j monitoring bean", response=CacheApiBean.class), @ApiResponse(code=404, message="no cache content provided")})
    public Response getStatus() {
        if (!this.getFeatureStore().isCached()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Current Store is not cached").build();
        }
        return Response.ok((Object)new CacheApiBean(this.getFeatureStore())).build();
    }

    @POST
    @Path(value="/cache")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Clear Cache", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=200, message="cache is cleard"), @ApiResponse(code=404, message="no cache content provided")})
    public Response clear() {
        if (!this.getFeatureStore().isCached()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Current Store is not cached").build();
        }
        ((FeatureStoreCacheProxy)this.getFeatureStore()).getCacheManager().clear();
        return Response.ok((Object)"Cache has been cleared").build();
    }
}

