/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.api.resources.domain;

import com.wordnik.swagger.annotations.ApiModel;
import com.wordnik.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.annotate.JsonProperty;
import org.ff4j.audit.graph.BarChart;
import org.ff4j.audit.graph.BarSeries;
import org.ff4j.web.api.resources.domain.BarSeriesApiBean;

@ApiModel(value="barChart", description="resource representation of a bar chart")
public class BarChartApiBean {
    @ApiModelProperty(value="title of the graph", required=false)
    @JsonProperty(value="title")
    private String title = null;
    @ApiModelProperty(value="labels of the graph", required=false)
    @JsonProperty(value="labels")
    private List<String> labels = new ArrayList<String>();
    @ApiModelProperty(value="series of the graph", required=false)
    @JsonProperty(value="series")
    private List<BarSeriesApiBean> series = new ArrayList<BarSeriesApiBean>();

    public BarChartApiBean(BarChart barChart) {
        this.title = barChart.getTitle();
        this.labels = barChart.getLabels();
        for (BarSeries bs : barChart.getSeries().values()) {
            this.series.add(new BarSeriesApiBean(bs));
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public List<BarSeriesApiBean> getSeries() {
        return this.series;
    }

    public void setSeries(List<BarSeriesApiBean> series) {
        this.series = series;
    }
}

