/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.api.resources.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.wordnik.swagger.annotations.ApiModel;
import com.wordnik.swagger.annotations.ApiModelProperty;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.jackson.annotate.JsonProperty;
import org.ff4j.cache.FeatureStoreCacheProxy;
import org.ff4j.core.FeatureStore;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@ApiModel(value="cacheApiBean", description="cache resource representation")
public class CacheApiBean {
    @JsonProperty(value="cacheProvider")
    @ApiModelProperty(value="if a cachestore is defined", required=false)
    private String cacheProvider = null;
    @JsonProperty(value="cacheStore")
    @ApiModelProperty(value="if a cachestore is defined", required=false)
    private String cacheStore = null;
    @JsonProperty(value="featureNames")
    @ApiModelProperty(value="list of features within cache", required=false)
    private Set<String> featureNames = new HashSet<String>();

    public CacheApiBean(FeatureStore featureStore) {
        if (featureStore.isCached()) {
            this.cacheStore = featureStore.getCachedTargetStore();
            this.cacheProvider = featureStore.getCacheProvider();
            this.featureNames = ((FeatureStoreCacheProxy)featureStore).getCacheManager().listCachedFeatureNames();
        }
    }

    public String getCacheProvider() {
        return this.cacheProvider;
    }

    public void setCacheProvider(String cacheProvider) {
        this.cacheProvider = cacheProvider;
    }

    public String getCacheStore() {
        return this.cacheStore;
    }

    public void setCacheStore(String cacheStore) {
        this.cacheStore = cacheStore;
    }

    public Set<String> getFeatureNames() {
        return this.featureNames;
    }

    public void setFeatureNames(Set<String> featureNames) {
        this.featureNames = featureNames;
    }
}

