/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.api.resources.domain;

import com.wordnik.swagger.annotations.ApiModel;
import com.wordnik.swagger.annotations.ApiModelProperty;
import java.util.Calendar;
import java.util.Date;
import org.codehaus.jackson.annotate.JsonProperty;
import org.ff4j.audit.graph.BarChart;
import org.ff4j.audit.graph.PieChart;
import org.ff4j.audit.graph.PieSector;
import org.ff4j.audit.repository.EventRepository;
import org.ff4j.web.api.resources.domain.BarChartApiBean;
import org.ff4j.web.api.resources.domain.PieChartApiBean;

@ApiModel(value="eventRepositoryApiBean", description="resource representation of monitoring resources")
public class EventRepositoryApiBean {
    @ApiModelProperty(value="type of the repository", required=true)
    @JsonProperty(value="type")
    private String type;
    @ApiModelProperty(value="total hit of the monitoring", required=true)
    @JsonProperty(value="hitCount")
    private int hitCount = 0;
    @ApiModelProperty(value="pie of features", required=true)
    @JsonProperty(value="eventsPie")
    private PieChartApiBean eventsPie;
    @ApiModelProperty(value="barChart for activity", required=true)
    @JsonProperty(value="barChart")
    private BarChartApiBean barChart;

    public EventRepositoryApiBean() {
    }

    public EventRepositoryApiBean(EventRepository evtRepository, Long start, Long end) {
        this.type = evtRepository.getClass().getCanonicalName();
        if (start == null) {
            Calendar c = Calendar.getInstance();
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            start = c.getTimeInMillis();
        }
        if (end == null) {
            Calendar c2 = Calendar.getInstance();
            c2.setTime(new Date(System.currentTimeMillis() + 86400000L));
            c2.set(11, 0);
            c2.set(12, 0);
            c2.set(13, 0);
            end = c2.getTimeInMillis();
        }
        PieChart pie = evtRepository.getHitsPieChart(start.longValue(), end.longValue());
        this.eventsPie = new PieChartApiBean(pie);
        BarChart bc = evtRepository.getHitsBarChart(start.longValue(), end.longValue(), 24);
        this.barChart = new BarChartApiBean(bc);
        for (PieSector sector : pie.getSectors()) {
            this.hitCount = (int)((double)this.hitCount + sector.getValue());
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getHitCount() {
        return this.hitCount;
    }

    public void setHitCount(int hitCount) {
        this.hitCount = hitCount;
    }

    public PieChartApiBean getEventsPie() {
        return this.eventsPie;
    }

    public void setEventsPie(PieChartApiBean eventsPie) {
        this.eventsPie = eventsPie;
    }

    public BarChartApiBean getBarChart() {
        return this.barChart;
    }

    public void setBarChart(BarChartApiBean barChart) {
        this.barChart = barChart;
    }
}

