/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.api.resources.domain;

import com.wordnik.swagger.annotations.ApiModel;
import com.wordnik.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.annotate.JsonProperty;
import org.ff4j.core.Feature;
import org.ff4j.web.api.resources.domain.FlippingStrategyApiBean;

@ApiModel(value="featureApiBean", description="Representation of a feature")
public class FeatureApiBean {
    @JsonProperty(value="uid")
    @ApiModelProperty(value="unique feature identifier", required=true)
    private String uid = null;
    @JsonProperty(value="enable")
    @ApiModelProperty(value="status of feature", required=true)
    private boolean enable = false;
    @JsonProperty(value="description")
    @ApiModelProperty(value="description of feature", required=false)
    private String description = null;
    @JsonProperty(value="group")
    @ApiModelProperty(value="Group of the feature if exists, it's single", required=false)
    private String group = null;
    @JsonProperty(value="permissions")
    @ApiModelProperty(value="Role and profiles authorized on feature", required=false)
    private List<String> permissions = new ArrayList<String>();
    @JsonProperty(value="flippingStrategy")
    @ApiModelProperty(value="Flipping strategy if exist", required=false)
    private FlippingStrategyApiBean flippingStrategy = null;

    public FeatureApiBean() {
    }

    public FeatureApiBean(Feature f) {
        this.uid = f.getUid();
        this.enable = f.isEnable();
        this.description = f.getDescription();
        this.group = f.getGroup();
        this.permissions = new ArrayList<String>(f.getPermissions());
        if (f.getFlippingStrategy() != null) {
            this.flippingStrategy = new FlippingStrategyApiBean(f.getFlippingStrategy());
        }
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public List<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<String> permissions) {
        this.permissions = permissions;
    }

    public FlippingStrategyApiBean getFlippingStrategy() {
        return this.flippingStrategy;
    }

    public void setFlippingStrategy(FlippingStrategyApiBean flippingStrategy) {
        this.flippingStrategy = flippingStrategy;
    }
}

