/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.api.resources.domain;

import com.wordnik.swagger.annotations.ApiModel;
import com.wordnik.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.annotate.JsonProperty;
import org.ff4j.core.FeatureStore;
import org.ff4j.web.api.resources.domain.CacheApiBean;

@ApiModel(value="featureStoreApiBean", description="store resource representation")
public class FeatureStoreApiBean {
    @JsonProperty(value="type")
    @ApiModelProperty(value="classname of implementation", required=true)
    private String type;
    @JsonProperty(value="numberOfFeatures")
    @ApiModelProperty(value="number of features", required=true)
    private int numberOfFeatures = 0;
    @JsonProperty(value="numberOfGroups")
    @ApiModelProperty(value="number of group", required=true)
    private int numberOfGroups = 0;
    @JsonProperty(value="features")
    @ApiModelProperty(value="list of features", required=true)
    private List<String> features = new ArrayList<String>();
    @JsonProperty(value="groups")
    @ApiModelProperty(value="list of group", required=true)
    private List<String> groups = new ArrayList<String>();
    @JsonProperty(value="cache")
    @ApiModelProperty(value="if a cachestore is defined", required=true)
    private CacheApiBean cache = null;

    public FeatureStoreApiBean() {
    }

    public FeatureStoreApiBean(FeatureStore featureStore) {
        this.type = featureStore.getClass().getCanonicalName();
        if (featureStore.isCached()) {
            this.cache = new CacheApiBean(featureStore);
        }
        this.features = new ArrayList(featureStore.readAll().keySet());
        this.groups = new ArrayList<String>(featureStore.readAllGroups());
        this.numberOfFeatures = this.features.size();
        this.numberOfGroups = this.groups.size();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getNumberOfFeatures() {
        return this.numberOfFeatures;
    }

    public void setNumberOfFeatures(int numberOfFeatures) {
        this.numberOfFeatures = numberOfFeatures;
    }

    public int getNumberOfGroups() {
        return this.numberOfGroups;
    }

    public void setNumberOfGroups(int numberOfGroups) {
        this.numberOfGroups = numberOfGroups;
    }

    public List<String> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<String> features) {
        this.features = features;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    public CacheApiBean getCache() {
        return this.cache;
    }

    public void setCache(CacheApiBean cache) {
        this.cache = cache;
    }
}

