/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.embedded;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FilenameUtils;
import org.ff4j.FF4j;
import org.ff4j.conf.XmlParser;
import org.ff4j.core.Feature;
import org.ff4j.core.FlippingStrategy;
import org.ff4j.web.api.FF4JProvider;
import org.ff4j.web.embedded.ConsoleConstants;
import org.ff4j.web.embedded.ConsoleRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleServlet
extends HttpServlet
implements ConsoleConstants {
    private static final long serialVersionUID = -3982043895954284269L;
    public static Logger LOGGER = LoggerFactory.getLogger((String)"FF4J");
    private FF4j ff4j = null;
    private FF4JProvider ff4jProvider = null;

    public void init(ServletConfig servletConfig) throws ServletException {
        LOGGER.debug("Initializing Embedded Servlet");
        String className = servletConfig.getInitParameter("ff4jProvider");
        try {
            Class<?> c = Class.forName(className);
            Object o = c.newInstance();
            this.ff4jProvider = (FF4JProvider)o;
            LOGGER.info("  __  __ _  _   _ ");
            LOGGER.info(" / _|/ _| || | (_)");
            LOGGER.info("| |_| |_| || |_| |");
            LOGGER.info("|  _|  _|__   _| |");
            LOGGER.info("|_| |_|    |_|_/ |");
            LOGGER.info("             |__/   Embedded Console - v" + this.getClass().getPackage().getImplementationVersion());
            LOGGER.info(" ");
            LOGGER.info("ff4j context has been successfully initialized - {} feature(s)", (Object)this.ff4jProvider.getFF4j().getFeatures().size());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Cannot load ff4jProvider as " + this.ff4jProvider, e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Cannot instanciate  " + this.ff4jProvider + " as ff4jProvider", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("No public constructor for  " + this.ff4jProvider + " as ff4jProvider", e);
        }
        catch (ClassCastException ce) {
            throw new IllegalArgumentException("ff4jProvider expected instance of " + FF4JProvider.class, ce);
        }
        this.ff4j = this.ff4jProvider.getFF4j();
        servletConfig.getServletContext().setAttribute("FF4J", (Object)this.ff4j);
        LOGGER.debug("Servlet has been initialized and ff4j store in session with {} ", (Object)this.ff4j.getFeatures().size());
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String message = null;
        String messagetype = "info";
        try {
            String operation;
            String resources = req.getParameter("rsc");
            if (resources != null && !resources.isEmpty()) {
                LOGGER.debug("GET Access to console to retrieve resource {}", (Object)resources);
                if ("css".equalsIgnoreCase(resources)) {
                    res.setContentType("text/css");
                    res.getWriter().println(ConsoleRenderer.getCSS());
                    LOGGER.debug("Retrieving CSS");
                    return;
                }
                if ("js".equalsIgnoreCase(resources)) {
                    res.setContentType("application/javascript");
                    res.getWriter().println(ConsoleRenderer.getJS());
                    LOGGER.debug("Retrieving JS");
                    return;
                }
            }
            if ((operation = req.getParameter("op")) != null && !operation.isEmpty()) {
                if ("disable".equalsIgnoreCase(operation)) {
                    this.opDisableFeature(req);
                    res.setContentType("text/html");
                    PrintWriter out = res.getWriter();
                    String targetMessage = this.buildMessage(req.getParameter("uid"), "DISABLED");
                    out.println(ConsoleRenderer.renderMessageBox(targetMessage, "info"));
                    return;
                }
                if ("enable".equalsIgnoreCase(operation)) {
                    this.opEnableFeature(req);
                    res.setContentType("text/html");
                    PrintWriter out = res.getWriter();
                    out.println(ConsoleRenderer.renderMessageBox(this.buildMessage(req.getParameter("uid"), "ENABLED"), "info"));
                    return;
                }
                if ("delete".equalsIgnoreCase(operation)) {
                    this.opDeleteFeature(req);
                    message = this.buildMessage(req.getParameter("uid"), "DELETED");
                } else if ("export".equalsIgnoreCase(operation)) {
                    this.opExportFile(res);
                    message = "Feature have been success fully exported";
                    return;
                }
            }
        }
        catch (Exception e) {
            messagetype = "error";
            message = e.getMessage();
        }
        this.renderPage(req, res, message, messagetype);
    }

    private String buildMessage(String featureName, String operationId) {
        return String.format("Feature <b>%s</b> has been successfully %s", featureName, operationId);
    }

    private String buildMessageGroup(String groupName, String operationId) {
        return String.format("Group <b>%s</b> has been successfully %s", groupName, operationId);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String message = null;
        String messagetype = "info";
        try {
            if (ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
                List items = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory()).parseRequest(req);
                for (FileItem item : items) {
                    if (item.isFormField()) {
                        if (!"op".equalsIgnoreCase(item.getFieldName())) continue;
                        LOGGER.info("Processing action : " + item.getString());
                        continue;
                    }
                    if (!"flipFile".equalsIgnoreCase(item.getFieldName())) continue;
                    String filename = FilenameUtils.getName((String)item.getName());
                    if (filename.toLowerCase().endsWith("xml")) {
                        this.opImportFile(item.getInputStream());
                        message = "The file <b>" + filename + "</b> has been successfully imported";
                        continue;
                    }
                    messagetype = "error";
                    message = "Invalid FILE, must be CSV, XML or PROPERTIES files";
                }
            } else {
                String operation = req.getParameter("op");
                if (operation != null && !operation.isEmpty()) {
                    if ("update".equalsIgnoreCase(operation)) {
                        this.opUpdateFeatureDescription(req);
                        message = this.buildMessage(req.getParameter("uid"), "UPDATED");
                    } else if ("create".equalsIgnoreCase(operation)) {
                        this.opCreateFeature(req);
                        message = this.buildMessage(req.getParameter("uid"), "ADDED");
                    } else if ("toggleGroup".equalsIgnoreCase(operation)) {
                        String groupName = req.getParameter("groupName");
                        if (groupName != null && !groupName.isEmpty()) {
                            String operationGroup = req.getParameter("ope");
                            if ("enable".equalsIgnoreCase(operationGroup)) {
                                this.getFf4j().getFeatureStore().enableGroup(groupName);
                                message = this.buildMessageGroup(groupName, "ENABLED");
                                LOGGER.info("Group '" + groupName + "' has been ENABLED.");
                            } else if ("disable".equalsIgnoreCase(operationGroup)) {
                                this.getFf4j().getFeatureStore().disableGroup(groupName);
                                message = this.buildMessageGroup(groupName, "DISABLED");
                                LOGGER.info("Group '" + groupName + "' has been DISABLED.");
                            }
                        }
                    } else {
                        LOGGER.error("Invalid POST OPERATION" + operation);
                        messagetype = "error";
                        message = "Invalid REQUEST";
                    }
                }
            }
        }
        catch (Exception e) {
            messagetype = "error";
            message = e.getMessage();
        }
        this.renderPage(req, res, message, messagetype);
    }

    private void renderPage(HttpServletRequest req, HttpServletResponse res, String msg, String msgType) throws IOException {
        res.setContentType("text/html");
        PrintWriter out = res.getWriter();
        String htmlContent = ConsoleRenderer.renderTemplate(req);
        String msgBox = ConsoleRenderer.renderMessageBox(msg, msgType);
        htmlContent = htmlContent.replaceAll("\\{ALERT\\}", msgBox);
        String rows = ConsoleRenderer.renderFeatureRows(this.ff4j, req);
        htmlContent = htmlContent.replaceAll("\\{FEATURE_ROWS\\}", rows);
        String groups = ConsoleRenderer.renderGroupList(this.ff4j, "modalEdit");
        htmlContent = htmlContent.replaceAll("\\{FEATURE_GRPS_EDIT\\}", groups);
        groups = groups.replaceAll("modalEdit", "modalCreate");
        htmlContent = htmlContent.replaceAll("\\{FEATURE_GRPS_CREATE\\}", groups);
        groups = groups.replaceAll("modalCreate", "modalToggle");
        htmlContent = htmlContent.replaceAll("\\{FEATURE_GRPS_TOGGLE\\}", groups);
        String permissions = ConsoleRenderer.renderPermissionList(this.ff4j);
        htmlContent = htmlContent.replaceAll("\\{PERMISSIONS\\}", permissions);
        out.println(htmlContent);
    }

    private void opEnableFeature(HttpServletRequest req) {
        String featureId = req.getParameter("uid");
        if (featureId != null && !featureId.isEmpty()) {
            this.getFf4j().enable(featureId);
            LOGGER.info(featureId + " has been successfully enabled");
        }
    }

    private void opDisableFeature(HttpServletRequest req) {
        String featureId = req.getParameter("uid");
        if (featureId != null && !featureId.isEmpty()) {
            this.getFf4j().disable(featureId);
            LOGGER.info(featureId + " has been disabled");
        }
    }

    private void opCreateFeature(HttpServletRequest req) {
        String featureId = req.getParameter("uid");
        if (featureId != null && !featureId.isEmpty()) {
            String permission;
            String strategy;
            String groupName;
            Feature fp = new Feature(featureId, false);
            String featureDesc = req.getParameter("desc");
            if (null != featureDesc && !featureDesc.isEmpty()) {
                fp.setDescription(featureDesc);
            }
            if (null != (groupName = req.getParameter("groupName")) && !groupName.isEmpty()) {
                fp.setGroup(groupName);
            }
            if (null != (strategy = req.getParameter("strategy")) && !strategy.isEmpty()) {
                try {
                    Class<?> strategyClass = Class.forName(strategy);
                    FlippingStrategy fstrategy = (FlippingStrategy)strategyClass.newInstance();
                    String strategyParams = req.getParameter("initParams");
                    if (null != strategyParams && !strategyParams.isEmpty()) {
                        String[] params;
                        HashMap<String, String> initParams = new HashMap<String, String>();
                        for (String currentP : params = strategyParams.split(";")) {
                            String[] cur = currentP.split("=");
                            if (cur.length < 2) {
                                throw new IllegalArgumentException("Invalid Syntax : param1=val1,val2;param2=val3,val4");
                            }
                            initParams.put(cur[0], cur[1]);
                        }
                        fstrategy.init(featureId, initParams);
                    }
                    fp.setFlippingStrategy(fstrategy);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Cannot find strategy class", e);
                }
                catch (InstantiationException e) {
                    throw new IllegalArgumentException("Cannot instanciate strategy", e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("Cannot instanciate : no public constructor", e);
                }
            }
            if (null != (permission = req.getParameter("permission")) && "Restricted".equals(permission)) {
                Map parameters = req.getParameterMap();
                HashSet<String> permissions = new HashSet<String>();
                for (String key : parameters.keySet()) {
                    if (!key.startsWith("perm-check-")) continue;
                    permissions.add(key.replace("perm-check-", ""));
                }
                fp.setPermissions(permissions);
            }
            this.getFf4j().getFeatureStore().create(fp);
            LOGGER.info(featureId + " has been created");
        }
    }

    private void opUpdateFeatureDescription(HttpServletRequest req) {
        String featureId = req.getParameter("uid");
        if (featureId != null && !featureId.isEmpty()) {
            String permission;
            String strategy;
            String groupName;
            Feature fp = new Feature(featureId, false);
            String featureDesc = req.getParameter("desc");
            if (null != featureDesc && !featureDesc.isEmpty()) {
                fp.setDescription(featureDesc);
            }
            if (null != (groupName = req.getParameter("groupName")) && !groupName.isEmpty()) {
                fp.setGroup(groupName);
            }
            if (null != (strategy = req.getParameter("strategy")) && !strategy.isEmpty()) {
                try {
                    Class<?> strategyClass = Class.forName(strategy);
                    FlippingStrategy fstrategy = (FlippingStrategy)strategyClass.newInstance();
                    String strategyParams = req.getParameter("initParams");
                    if (null != strategyParams && !strategyParams.isEmpty()) {
                        String[] params;
                        HashMap<String, String> initParams = new HashMap<String, String>();
                        for (String currentP : params = strategyParams.split(";")) {
                            String[] cur = currentP.split("=");
                            if (cur.length < 2) {
                                throw new IllegalArgumentException("Invalid Syntax : param1=val1,val2;param2=val3,val4");
                            }
                            initParams.put(cur[0], cur[1]);
                        }
                        fstrategy.init(featureId, initParams);
                    }
                    fp.setFlippingStrategy(fstrategy);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Cannot find strategy class", e);
                }
                catch (InstantiationException e) {
                    throw new IllegalArgumentException("Cannot instanciate strategy", e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("Cannot instanciate : no public constructor", e);
                }
            }
            if (null != (permission = req.getParameter("permission")) && "Restricted".equals(permission)) {
                Map parameters = req.getParameterMap();
                HashSet<String> permissions = new HashSet<String>();
                for (String key : parameters.keySet()) {
                    if (!key.startsWith("perm-check-")) continue;
                    permissions.add(key.replace("perm-check-", ""));
                }
                fp.setPermissions(permissions);
            }
            this.getFf4j().getFeatureStore().update(fp);
            LOGGER.info(featureId + " has been updated");
        }
    }

    private void opDeleteFeature(HttpServletRequest req) {
        String featureId = req.getParameter("uid");
        if (featureId != null && !featureId.isEmpty()) {
            this.getFf4j().getFeatureStore().delete(featureId);
            LOGGER.info(featureId + " has been deleted");
        }
    }

    private void opImportFile(InputStream in) throws IOException {
        Map mapsOfFeat = new XmlParser().parseConfigurationFile(in).getFeatures();
        for (Map.Entry feature : mapsOfFeat.entrySet()) {
            if (this.getFf4j().getFeatureStore().exist((String)feature.getKey())) {
                this.getFf4j().getFeatureStore().update((Feature)feature.getValue());
                continue;
            }
            this.getFf4j().getFeatureStore().create((Feature)feature.getValue());
        }
        LOGGER.info(mapsOfFeat.size() + " features have been imported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void opExportFile(HttpServletResponse res) throws IOException {
        Map features = this.getFf4j().getFeatureStore().readAll();
        InputStream in = new XmlParser().exportFeatures(features);
        ServletOutputStream sos = null;
        try {
            sos = res.getOutputStream();
            res.setContentType("text/xml");
            res.setHeader("Content-Disposition", "attachment; filename=\"ff4j.xml\"");
            byte[] bbuf = new byte[4096];
            int length = 0;
            while (in != null && length != -1) {
                length = in.read(bbuf);
                sos.write(bbuf, 0, length);
            }
            LOGGER.info(features.size() + " features have been exported.");
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (sos != null) {
                sos.flush();
                sos.close();
            }
        }
    }

    public FF4j getFf4j() {
        if (this.ff4j == null) {
            throw new IllegalStateException("Console Servlet has not been initialized, please set 'load-at-startup' to 1");
        }
        return this.ff4j;
    }
}

