/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.store;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.core.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;
import org.ff4j.core.Feature;
import org.ff4j.exception.FeatureAccessException;
import org.ff4j.exception.FeatureAlreadyExistException;
import org.ff4j.exception.FeatureNotFoundException;
import org.ff4j.exception.GroupNotFoundException;
import org.ff4j.store.AbstractFeatureStore;
import org.ff4j.utils.json.FeatureJsonParser;
import org.ff4j.web.api.FF4jWebConstants;
import org.ff4j.web.api.jersey.FF4jJacksonMapper;
import org.ff4j.web.api.resources.domain.FeatureApiBean;
import org.ff4j.web.api.resources.domain.GroupDescApiBean;

public class FeatureStoreHttp
extends AbstractFeatureStore
implements FF4jWebConstants {
    protected Client client = null;
    private String url = null;
    private String authorization = null;
    private WebResource storeWebRsc = null;
    private WebResource groupsWebRsc = null;

    public FeatureStoreHttp() {
    }

    public FeatureStoreHttp(String rootApiUrl) {
        this.url = rootApiUrl;
    }

    public FeatureStoreHttp(String rootApiUrl, String apiKey) {
        this(rootApiUrl);
        this.authorization = FeatureStoreHttp.buildAuthorization4ApiKey(apiKey);
    }

    public FeatureStoreHttp(String rootApiUrl, String username, String password) {
        this(rootApiUrl);
        this.authorization = FeatureStoreHttp.buildAuthorization4UserName(username, password);
    }

    private void initJerseyClient() {
        if (this.client == null) {
            DefaultClientConfig config = new DefaultClientConfig();
            config.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
            config.getSingletons().add(new JacksonJsonProvider());
            config.getSingletons().add(new FF4jJacksonMapper());
            this.client = Client.create((ClientConfig)config);
        }
        if (this.url == null) {
            throw new IllegalArgumentException("Cannot initialialize Jersey Client : please provide store URL in 'url' attribute");
        }
    }

    private WebResource getStore() {
        if (this.storeWebRsc == null) {
            this.initJerseyClient();
            this.storeWebRsc = this.client.resource(this.url).path("store").path("features");
            if (null != this.authorization) {
                this.storeWebRsc.header("Authorization", (Object)this.authorization);
            }
        }
        return this.storeWebRsc;
    }

    private WebResource getGroups() {
        if (this.groupsWebRsc == null) {
            this.initJerseyClient();
            this.groupsWebRsc = this.client.resource(this.url).path("store").path("groups");
            if (null != this.authorization) {
                this.groupsWebRsc.header("Authorization", (Object)this.authorization);
            }
        }
        return this.groupsWebRsc;
    }

    public Feature read(String uid) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier cannot be null nor empty");
        }
        ClientResponse cRes = (ClientResponse)this.getStore().path(uid).get(ClientResponse.class);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new FeatureNotFoundException(uid);
        }
        return FeatureJsonParser.parseFeature((String)((String)cRes.getEntity(String.class)));
    }

    public void enable(String uid) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier cannot be null nor empty");
        }
        ClientResponse cRes = (ClientResponse)this.getStore().path(uid).path("enable").post(ClientResponse.class);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new FeatureNotFoundException(uid);
        }
    }

    public void disable(String uid) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier cannot be null nor empty");
        }
        System.out.println(uid);
        ClientResponse cRes = (ClientResponse)this.getStore().path(uid).path("disable").post(ClientResponse.class);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new FeatureNotFoundException(uid);
        }
    }

    public boolean exist(String uid) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier cannot be null nor empty");
        }
        ClientResponse cRes = (ClientResponse)this.getStore().path(uid).get(ClientResponse.class);
        if (Response.Status.OK.getStatusCode() == cRes.getStatus()) {
            return true;
        }
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            return false;
        }
        throw new FeatureAccessException("Cannot check existence of feature, an HTTP error " + cRes.getStatus() + " occured : " + cRes.getEntityInputStream());
    }

    public void create(Feature fp) {
        if (fp == null) {
            throw new IllegalArgumentException("Feature cannot be null nor empty");
        }
        if (this.exist(fp.getUid())) {
            throw new FeatureAlreadyExistException(fp.getUid());
        }
        ClientResponse cRes = (ClientResponse)this.getStore().path(fp.getUid()).type("application/json").put(ClientResponse.class, (Object)new FeatureApiBean(fp));
        if (Response.Status.CREATED.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot create feature, an HTTP error " + cRes.getStatus() + " occured.");
        }
    }

    public Map<String, Feature> readAll() {
        ClientResponse cRes = (ClientResponse)this.getStore().get(ClientResponse.class);
        if (Response.Status.OK.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot read features, an HTTP error " + cRes.getStatus() + " occured.");
        }
        String resEntity = (String)cRes.getEntity(String.class);
        Feature[] fArray = FeatureJsonParser.parseFeatureArray((String)resEntity);
        HashMap<String, Feature> features = new HashMap<String, Feature>();
        for (Feature feature : fArray) {
            features.put(feature.getUid(), feature);
        }
        return features;
    }

    public void delete(String uid) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier cannot be null nor empty");
        }
        ClientResponse cRes = (ClientResponse)this.getStore().path(uid).delete(ClientResponse.class);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new FeatureNotFoundException(uid);
        }
        if (Response.Status.NO_CONTENT.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot delete feature, an HTTP error " + cRes.getStatus() + " occured.");
        }
    }

    public void update(Feature fp) {
        if (fp == null) {
            throw new IllegalArgumentException("Feature cannot be null nor empty");
        }
        if (!this.exist(fp.getUid())) {
            throw new FeatureNotFoundException(fp.getUid());
        }
        ClientResponse cRes = (ClientResponse)this.getStore().path(fp.getUid()).type("application/json").put(ClientResponse.class, (Object)new FeatureApiBean(fp));
        if (Response.Status.NO_CONTENT.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot update feature, an HTTP error " + cRes.getStatus() + " occured.");
        }
    }

    public void grantRoleOnFeature(String uid, String roleName) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier cannot be null nor empty");
        }
        if (roleName == null || roleName.isEmpty()) {
            throw new IllegalArgumentException("roleName cannot be null nor empty");
        }
        ClientResponse cRes = (ClientResponse)this.getStore().path(uid).path("grantrole").path(roleName).post(ClientResponse.class);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new FeatureNotFoundException(uid);
        }
        if (Response.Status.NO_CONTENT.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot grant role on feature, an HTTP error " + cRes.getStatus() + " occured.");
        }
    }

    public void removeRoleFromFeature(String uid, String roleName) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier cannot be null nor empty");
        }
        if (roleName == null || roleName.isEmpty()) {
            throw new IllegalArgumentException("roleName cannot be null nor empty");
        }
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier cannot be null nor empty");
        }
        if (roleName == null || roleName.isEmpty()) {
            throw new IllegalArgumentException("roleName cannot be null nor empty");
        }
        ClientResponse cRes = (ClientResponse)this.getStore().path(uid).path("removerole").path(roleName).post(ClientResponse.class);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new FeatureNotFoundException(uid);
        }
        if (Response.Status.NO_CONTENT.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot remove role on feature, an HTTP error " + cRes.getStatus() + " occured.");
        }
    }

    public void addToGroup(String uid, String groupName) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier cannot be null nor empty");
        }
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException("Groupname cannot be null nor empty");
        }
        ClientResponse cRes = (ClientResponse)this.getStore().path(uid).path("addGroup").path(groupName).post(ClientResponse.class);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new FeatureNotFoundException(uid);
        }
        if (Response.Status.NO_CONTENT.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot add feature to group, an HTTP error " + cRes.getStatus() + " occured.");
        }
    }

    public void removeFromGroup(String uid, String groupName) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier cannot be null nor empty");
        }
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException("Groupname cannot be null nor empty");
        }
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier cannot be null nor empty");
        }
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException("Groupname cannot be null nor empty");
        }
        ClientResponse cRes = (ClientResponse)this.getStore().path(uid).path("removeGroup").path(groupName).post(ClientResponse.class);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new FeatureNotFoundException(uid);
        }
        if (Response.Status.BAD_REQUEST.getStatusCode() == cRes.getStatus()) {
            throw new GroupNotFoundException(groupName);
        }
        if (Response.Status.NO_CONTENT.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot remove feature from group, an HTTP error " + cRes.getStatus() + " occured.");
        }
    }

    public void enableGroup(String groupName) {
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException("Groupname cannot be null nor empty");
        }
        ClientResponse cRes = (ClientResponse)this.getGroups().path(groupName).path("enable").post(ClientResponse.class);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new GroupNotFoundException(groupName);
        }
        if (Response.Status.NO_CONTENT.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot grant role on feature, an HTTP error " + cRes.getStatus() + " occured.");
        }
    }

    public void disableGroup(String groupName) {
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException("Groupname cannot be null nor empty");
        }
        ClientResponse cRes = (ClientResponse)this.getGroups().path(groupName).path("disable").post(ClientResponse.class);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new GroupNotFoundException(groupName);
        }
        if (Response.Status.NO_CONTENT.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot grant role on feature, an HTTP error " + cRes.getStatus() + " occured.");
        }
    }

    public Map<String, Feature> readGroup(String groupName) {
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException("Groupname cannot be null nor empty");
        }
        ClientResponse cRes = (ClientResponse)this.getGroups().path(groupName).get(ClientResponse.class);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new GroupNotFoundException(groupName);
        }
        if (Response.Status.OK.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot grant role on feature, an HTTP error " + cRes.getStatus() + " occured.");
        }
        String resEntity = (String)cRes.getEntity(String.class);
        Feature[] fArray = FeatureJsonParser.parseFeatureArray((String)resEntity);
        HashMap<String, Feature> features = new HashMap<String, Feature>();
        for (Feature feature : fArray) {
            features.put(feature.getUid(), feature);
        }
        return features;
    }

    public boolean existGroup(String groupName) {
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException("Groupname cannot be null nor empty");
        }
        ClientResponse cRes = (ClientResponse)this.getGroups().path(groupName).get(ClientResponse.class);
        if (Response.Status.OK.getStatusCode() == cRes.getStatus()) {
            return true;
        }
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            return false;
        }
        throw new FeatureAccessException("Cannot check existence of group , an HTTP error " + cRes.getStatus() + " occured.");
    }

    public Set<String> readAllGroups() {
        ClientResponse cRes = (ClientResponse)this.getGroups().get(ClientResponse.class);
        List groupApiBeans = (List)cRes.getEntity((GenericType)new GenericType<List<GroupDescApiBean>>(){});
        if (Response.Status.OK.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot read groups, an HTTP error " + cRes.getStatus() + " occured.");
        }
        HashSet<String> groupNames = new HashSet<String>();
        for (GroupDescApiBean groupApiBean : groupApiBeans) {
            groupNames.add(groupApiBean.getGroupName());
        }
        return groupNames;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("\"type\":\"" + this.getClass().getCanonicalName() + "\"");
        sb.append("\"target\":\"" + this.url + "\"");
        sb.append(",\"cached\":" + this.isCached());
        if (this.isCached()) {
            sb.append(",\"cacheProvider\":\"" + this.getCacheProvider() + "\"");
            sb.append(",\"cacheStore\":\"" + this.getCachedTargetStore() + "\"");
        }
        Set<String> myFeatures = this.readAll().keySet();
        sb.append(",\"numberOfFeatures\":" + myFeatures.size());
        sb.append(",\"features\":[");
        boolean first = true;
        for (String myFeature : myFeatures) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append("\"" + myFeature + "\"");
        }
        Set<String> myGroups = this.readAllGroups();
        sb.append("],\"numberOfGroups\":" + myGroups.size());
        sb.append(",\"groups\":[");
        first = true;
        for (String myGroup : myGroups) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append("\"" + myGroup + "\"");
        }
        sb.append("]");
        sb.append("}");
        return sb.toString();
    }

    public boolean isCached() {
        return false;
    }

    public String getCacheProvider() {
        return null;
    }

    public String getCachedTargetStore() {
        return null;
    }

    public static String buildAuthorization4UserName(String username, String password) {
        return " Basic " + new String(Base64.encode((String)(username + ":" + password)));
    }

    public static String buildAuthorization4ApiKey(String apiKey) {
        return "apiKey=" + apiKey;
    }
}

