/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.ff4j.FF4j;
import org.ff4j.web.FF4JProvider;
import org.ff4j.web.console.CustomMessageResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.messageresolver.IMessageResolver;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

public class FF4jInitServlet
extends HttpServlet {
    private static final long serialVersionUID = 8447941463286918975L;
    public static final Logger LOGGER = LoggerFactory.getLogger(FF4jInitServlet.class);
    protected FF4j ff4j = null;
    protected FF4JProvider ff4jProvider = null;
    protected TemplateEngine templateEngine = null;

    public void init(ServletConfig servletConfig) throws ServletException {
        LOGGER.info("  __  __ _  _   _ ");
        LOGGER.info(" / _|/ _| || | (_)");
        LOGGER.info("| |_| |_| || |_| |");
        LOGGER.info("|  _|  _|__   _| |");
        LOGGER.info("|_| |_|    |_|_/ |");
        LOGGER.info("             |__/  v" + ((Object)((Object)this)).getClass().getPackage().getImplementationVersion());
        LOGGER.info(" ");
        if (this.ff4j == null) {
            this.initializeFF4J(servletConfig);
        }
        this.initializeTemplateEngine();
    }

    private void initializeFF4J(ServletConfig servletConfig) {
        String className = servletConfig.getInitParameter("ff4jProvider");
        try {
            Class<?> c = Class.forName(className);
            Object o = c.newInstance();
            this.ff4jProvider = (FF4JProvider)o;
            LOGGER.info("ff4j context has been successfully initialized - {} feature(s)", (Object)this.ff4jProvider.getFF4j().getFeatures().size());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Cannot load ff4jProvider as " + this.ff4jProvider, e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Cannot instantiate  " + this.ff4jProvider + " as ff4jProvider", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("No public constructor for  " + this.ff4jProvider + " as ff4jProvider", e);
        }
        catch (ClassCastException ce) {
            throw new IllegalArgumentException("ff4jProvider expected instance of " + FF4JProvider.class, ce);
        }
        this.ff4j = this.ff4jProvider.getFF4j();
        servletConfig.getServletContext().setAttribute("FF4J", (Object)this.ff4j);
        LOGGER.debug("Servlet has been initialized and ff4j store in session with {} ", (Object)this.ff4j.getFeatures().size());
        String cssFile = servletConfig.getInitParameter("customCSS");
        if (cssFile != null) {
            LOGGER.debug("A custom CSS has been defined [" + cssFile + "]");
            servletConfig.getServletContext().setAttribute("customCSS", (Object)cssFile);
        }
    }

    private void initializeTemplateEngine() {
        ClassLoaderTemplateResolver templateResolver = new ClassLoaderTemplateResolver();
        templateResolver.setTemplateMode("XHTML");
        templateResolver.setPrefix("views/view-");
        templateResolver.setSuffix(".dat");
        templateResolver.setCacheTTLMs(Long.valueOf(3600000L));
        this.templateEngine = new TemplateEngine();
        this.templateEngine.setTemplateResolver((ITemplateResolver)templateResolver);
        this.templateEngine.addMessageResolver((IMessageResolver)new CustomMessageResolver());
        LOGGER.info("Thymeleaf has been initialized");
    }
}

