/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.console;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.context.WebContext;

public class ImageProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageProvider.class);
    private Map<String, String> loadedImages = new HashMap<String, String>();
    private static ImageProvider _instance = null;

    private ImageProvider() {
    }

    public static synchronized ImageProvider getInstance() {
        if (_instance == null) {
            _instance = new ImageProvider();
        }
        return _instance;
    }

    private String fromFileToBase64(InputStream is, ImageType type) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            BufferedImage image = ImageIO.read(is);
            BufferedImage resizedImage = new BufferedImage(130, 180, image.getType());
            Graphics2D g = resizedImage.createGraphics();
            g.drawImage(image, 0, 0, 130, 180, null);
            g.dispose();
            ImageIO.write((RenderedImage)resizedImage, type.toString(), bos);
            String string = new String(Base64.getEncoder().encode(bos.toByteArray()));
            return string;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot convert image to base64", e);
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException iOException) {}
        }
    }

    private String getImage(String imageName, ImageType type) {
        if (!this.loadedImages.containsKey(imageName)) {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("static/img/" + imageName + "." + (Object)((Object)type));
            if (is != null) {
                this.loadedImages.put(imageName, this.fromFileToBase64(is, type));
            } else {
                LOGGER.warn("File [" + imageName + "." + (Object)((Object)type) + "] has not been found");
            }
        }
        return this.loadedImages.get(imageName);
    }

    public void addImageToContext(WebContext ctx, String imageName, ImageType type) {
        String base64 = this.getImage(imageName, type);
        if (base64 != null) {
            ctx.setVariable("flagFrance", (Object)("data:image/jpg;base64," + base64));
        }
    }

    public static enum ImageType {
        png,
        jpg,
        jpeg;

    }
}

