/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.embedded;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.ff4j.FF4j;
import org.ff4j.conf.FF4jConfiguration;
import org.ff4j.conf.XmlConfig;
import org.ff4j.conf.XmlParser;
import org.ff4j.core.Feature;
import org.ff4j.core.FeatureStore;
import org.ff4j.core.FlippingStrategy;
import org.ff4j.parser.yaml.YamlParser;
import org.ff4j.property.Property;
import org.ff4j.property.store.PropertyStore;
import org.ff4j.property.util.PropertyFactory;
import org.ff4j.utils.Util;
import org.ff4j.web.embedded.ConsoleConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConsoleOperations {
    private static Logger LOGGER = LoggerFactory.getLogger(ConsoleOperations.class);

    private ConsoleOperations() {
    }

    public static void createFeature(FF4j ff4j, HttpServletRequest req) {
        String featureId = req.getParameter("uid");
        if (featureId != null && !featureId.isEmpty()) {
            String permission;
            String strategy;
            String groupName;
            Feature fp = new Feature(featureId, false);
            String featureDesc = req.getParameter("desc");
            if (null != featureDesc && !featureDesc.isEmpty()) {
                fp.setDescription(featureDesc);
            }
            if (null != (groupName = req.getParameter("groupName")) && !groupName.isEmpty()) {
                fp.setGroup(groupName);
            }
            if (null != (strategy = req.getParameter("strategy")) && !strategy.isEmpty()) {
                try {
                    Class<?> strategyClass = Class.forName(strategy);
                    FlippingStrategy fstrategy = (FlippingStrategy)strategyClass.newInstance();
                    String strategyParams = req.getParameter("initParams");
                    if (null != strategyParams && !strategyParams.isEmpty()) {
                        String[] params;
                        HashMap<String, String> initParams = new HashMap<String, String>();
                        for (String currentP : params = strategyParams.split(";")) {
                            String[] cur = currentP.split("=");
                            if (cur.length < 2) {
                                throw new IllegalArgumentException("Invalid Syntax : param1=val1,val2;param2=val3,val4");
                            }
                            initParams.put(cur[0], cur[1]);
                        }
                        fstrategy.init(featureId, initParams);
                    }
                    fp.setFlippingStrategy(fstrategy);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Cannot find strategy class", e);
                }
                catch (InstantiationException e) {
                    throw new IllegalArgumentException("Cannot instantiate strategy", e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("Cannot instantiate : no public constructor", e);
                }
            }
            if (null != (permission = req.getParameter("permission")) && "Restricted".equals(permission)) {
                Map parameters = req.getParameterMap();
                HashSet<String> permissions = new HashSet<String>();
                for (String key : parameters.keySet()) {
                    if (!key.startsWith("perm-check-")) continue;
                    permissions.add(key.replace("perm-check-", ""));
                }
                fp.setPermissions(permissions);
            }
            ff4j.getFeatureStore().create(fp);
            LOGGER.info(featureId + " has been created");
        }
    }

    public static void updateProperty(FF4j ff4j, HttpServletRequest req) {
        String name = req.getParameter("name");
        String type = req.getParameter("pType");
        String description = req.getParameter("desc");
        String value = req.getParameter("pValue");
        String uid = req.getParameter("uid");
        String featureId = req.getParameter("featureid");
        if (uid == null) {
            uid = name;
        }
        if (Util.hasLength((String)featureId)) {
            Feature current = ff4j.getFeatureStore().read(featureId);
            Property ap = current.getProperty(uid);
            ap.setDescription(description);
            if (ap.getType().equalsIgnoreCase(type)) {
                ap.setValueFromString(value);
            } else {
                ap = PropertyFactory.createProperty((String)name, (String)type, (String)value);
                LOGGER.warn("By changing property type you loose the fixedValues, cannot evaluate ? at runtime");
            }
            ff4j.getFeatureStore().update(current);
        } else if (ff4j.getPropertiesStore().existProperty(uid)) {
            if (uid.equalsIgnoreCase(name)) {
                Property ap = ff4j.getPropertiesStore().readProperty(uid);
                if (ap.getType().equalsIgnoreCase(type)) {
                    ap.setDescription(description);
                    ap.setValueFromString(value);
                    ff4j.getPropertiesStore().updateProperty(ap);
                } else {
                    ap = PropertyFactory.createProperty((String)name, (String)type, (String)value);
                    ap.setDescription(description);
                    LOGGER.warn("By changing property type you loose the fixedValues, cannot evaluate ? at runtime");
                    ff4j.getPropertiesStore().deleteProperty(name);
                    ff4j.getPropertiesStore().createProperty(ap);
                }
            } else {
                Property ap = PropertyFactory.createProperty((String)name, (String)type, (String)value);
                ap.setDescription(description);
                LOGGER.warn("By changing property name you loose the fixedValues, cannot evaluate generics at runtime (type inference)");
                ff4j.getPropertiesStore().deleteProperty(uid);
                ff4j.getPropertiesStore().createProperty(ap);
            }
        }
    }

    public static void createProperty(FF4j ff4j, HttpServletRequest req) {
        String name = req.getParameter("name");
        String type = req.getParameter("pType");
        String description = req.getParameter("desc");
        String value = req.getParameter("pValue");
        String featureId = req.getParameter("featureid");
        Property ap = PropertyFactory.createProperty((String)name, (String)type, (String)value);
        ap.setDescription(description);
        if (Util.hasLength((String)featureId)) {
            Feature current = ff4j.getFeatureStore().read(featureId);
            current.addProperty(ap);
            ff4j.getFeatureStore().update(current);
        } else {
            ff4j.getPropertiesStore().createProperty(ap);
        }
    }

    private static void updateFlippingStrategy(Feature fp, String strategy, String strategyParams) {
        if (null != strategy && !strategy.isEmpty()) {
            try {
                Class<?> strategyClass = Class.forName(strategy);
                FlippingStrategy fstrategy = (FlippingStrategy)strategyClass.newInstance();
                if (null != strategyParams && !strategyParams.isEmpty()) {
                    String[] params;
                    HashMap<String, String> initParams = new HashMap<String, String>();
                    for (String currentP : params = strategyParams.split(";")) {
                        String[] cur = currentP.split("=");
                        if (cur.length < 2) {
                            throw new IllegalArgumentException("Invalid Syntax : param1=val1,val2;param2=val3,val4");
                        }
                        initParams.put(cur[0], cur[1]);
                    }
                    fstrategy.init(fp.getUid(), initParams);
                }
                fp.setFlippingStrategy(fstrategy);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Cannot find strategy class", e);
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("Cannot instantiate strategy", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Cannot instantiate : no public constructor", e);
            }
        }
    }

    public static void updateFeatureDescription(FF4j ff4j, HttpServletRequest req) {
        String featureId = req.getParameter("uid");
        if (featureId != null && !featureId.isEmpty()) {
            String groupName;
            Feature old = ff4j.getFeatureStore().read(featureId);
            Feature fp = new Feature(featureId, old.isEnable());
            String featureDesc = req.getParameter("desc");
            if (null != featureDesc && !featureDesc.isEmpty()) {
                fp.setDescription(featureDesc);
            }
            if (null != (groupName = req.getParameter("groupName")) && !groupName.isEmpty()) {
                fp.setGroup(groupName);
            }
            ConsoleOperations.updateFlippingStrategy(fp, req.getParameter("strategy"), req.getParameter("initParams"));
            String permission = req.getParameter("permission");
            if (null != permission && "Restricted".equals(permission)) {
                Map parameters = req.getParameterMap();
                HashSet<String> permissions = new HashSet<String>();
                for (String key : parameters.keySet()) {
                    if (!key.startsWith("perm-check-")) continue;
                    permissions.add(key.replace("perm-check-", ""));
                }
                fp.setPermissions(permissions);
            }
            ff4j.getFeatureStore().update(fp);
            LOGGER.info(featureId + " has been updated");
        }
    }

    @Deprecated
    public static void importFile(FF4j ff4j, InputStream in) throws IOException {
        ConsoleOperations.importFile(ff4j, (FF4jConfiguration)new XmlParser().parseConfigurationFile(in));
    }

    public static void importFile(FF4j ff4j, FF4jConfiguration config) throws IOException {
        if (config.isAutoCreate()) {
            ff4j.setAutocreate(true);
            LOGGER.info("Autocreate is now enabled.");
        }
        if (config.isAudit()) {
            ff4j.setEnableAudit(true);
            LOGGER.info("Audit is now enabled.");
        }
        FeatureStore store = ff4j.getFeatureStore();
        Map mapsOfFeat = config.getFeatures();
        for (Map.Entry feature : mapsOfFeat.entrySet()) {
            if (store.exist((String)feature.getKey())) {
                store.update((Feature)feature.getValue());
                continue;
            }
            store.create((Feature)feature.getValue());
        }
        LOGGER.info(mapsOfFeat.size() + " features have been imported.");
        PropertyStore pstore = ff4j.getPropertiesStore();
        Map mapsOfProperties = config.getProperties();
        for (Map.Entry p : mapsOfProperties.entrySet()) {
            if (pstore.existProperty((String)p.getKey())) {
                pstore.updateProperty((Property)p.getValue());
                continue;
            }
            pstore.createProperty((Property)p.getValue());
        }
        LOGGER.info(mapsOfProperties.size() + " features have been imported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportConfiguration(FF4j ff4j, HttpServletResponse res, String format) throws IOException {
        if (format != null) {
            InputStream in = null;
            ServletOutputStream sos = null;
            String fileName = "ff4j-" + ConsoleConstants.SDF.format(new Date()) + ".";
            try {
                sos = res.getOutputStream();
                if ("xml".equals(format.toLowerCase())) {
                    res.setContentType("text/xml");
                    res.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "xml" + "\"");
                    in = new XmlParser().exportAll(new XmlConfig(ff4j));
                } else if ("yml".equals(format.toLowerCase()) || "yaml".equals(format.toLowerCase())) {
                    res.setContentType("application/x-yaml");
                    res.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "yml" + "\"");
                    in = new YamlParser().export(new FF4jConfiguration(ff4j));
                } else if ("properties".equals(format.toLowerCase())) {
                    res.setContentType("text/x-java-properties");
                    res.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "properties" + "\"");
                    in = new YamlParser().export(new FF4jConfiguration(ff4j));
                }
                if (in != null) {
                    IOUtils.copy((InputStream)in, (OutputStream)sos);
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (sos != null) {
                    sos.flush();
                    sos.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportFile(FF4j ff4j, HttpServletResponse res) throws IOException {
        Map features = ff4j.getFeatureStore().readAll();
        InputStream in = new XmlParser().exportFeatures(features);
        ServletOutputStream sos = null;
        try {
            sos = res.getOutputStream();
            res.setContentType("text/xml");
            res.setHeader("Content-Disposition", "attachment; filename=\"ff4j.xml\"");
            IOUtils.copy((InputStream)in, (OutputStream)sos);
            LOGGER.info(features.size() + " features have been exported.");
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (sos != null) {
                sos.flush();
                sos.close();
            }
        }
    }
}

