/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.embedded;

import java.io.IOException;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FilenameUtils;
import org.ff4j.FF4j;
import org.ff4j.conf.FF4jConfiguration;
import org.ff4j.conf.XmlParser;
import org.ff4j.core.Feature;
import org.ff4j.property.Property;
import org.ff4j.web.FF4jProvider;
import org.ff4j.web.embedded.ConsoleOperations;
import org.ff4j.web.embedded.ConsoleRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ConsoleServlet
extends HttpServlet {
    private static final long serialVersionUID = -3982043895954284269L;
    public static final Logger LOGGER = LoggerFactory.getLogger(ConsoleServlet.class);
    public static final String ERROR = "error";
    private FF4j ff4j = null;
    private FF4jProvider ff4jProvider = null;

    public void init(ServletConfig servletConfig) throws ServletException {
        LOGGER.info("  __  __ _  _   _ ");
        LOGGER.info(" / _|/ _| || | (_)");
        LOGGER.info("| |_| |_| || |_| |");
        LOGGER.info("|  _|  _|__   _| |");
        LOGGER.info("|_| |_|    |_|_/ |");
        LOGGER.info("             |__/   Embedded Console - v" + ((Object)((Object)this)).getClass().getPackage().getImplementationVersion());
        LOGGER.info(" ");
        super.init(servletConfig);
        if (this.ff4j == null) {
            String className = servletConfig.getInitParameter("ff4jProvider");
            try {
                Class<?> c = Class.forName(className);
                Object o = c.newInstance();
                this.ff4jProvider = (FF4jProvider)o;
                LOGGER.info("ff4j context has been successfully initialized - {} feature(s)", (Object)this.ff4jProvider.getFF4j().getFeatures().size());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Cannot load ff4jProvider as " + this.ff4jProvider, e);
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("Cannot instantiate  " + this.ff4jProvider + " as ff4jProvider", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("No public constructor for  " + this.ff4jProvider + " as ff4jProvider", e);
            }
            catch (ClassCastException ce) {
                throw new IllegalArgumentException("ff4jProvider expected instance of " + FF4jProvider.class, ce);
            }
            this.ff4j = this.ff4jProvider.getFF4j();
            servletConfig.getServletContext().setAttribute("FF4J", (Object)this.ff4j);
            LOGGER.debug("Servlet has been initialized and ff4j store in session with {} ", (Object)this.ff4j.getFeatures().size());
        } else {
            LOGGER.debug("Servlet has been initialized, ff4j was injected");
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String targetView = req.getParameter("view");
        if (targetView == null || "".equals(targetView)) {
            this.pageCore(req, res);
        } else if ("monitoring".equals(targetView)) {
            this.pageMonitoring(req, res);
        }
    }

    public void pageMonitoring(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String message = null;
        String messagetype = "info";
        ConsoleRenderer.renderPageMonitoring(this.getFf4j(), req, res, message, messagetype);
    }

    public void pageCore(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String message = null;
        String messagetype = "info";
        try {
            if (ConsoleRenderer.renderResources(req, res)) {
                return;
            }
            String operation = req.getParameter("op");
            String featureId = req.getParameter("uid");
            LOGGER.info("GET - op=" + operation + " feat=" + featureId);
            if (operation != null && !operation.isEmpty()) {
                if ("export".equalsIgnoreCase(operation)) {
                    ConsoleOperations.exportFile(this.ff4j, res);
                    return;
                }
                if (featureId != null && !featureId.isEmpty()) {
                    if (this.getFf4j().getFeatureStore().exist(featureId)) {
                        message = this.workWithFeature(res, operation, featureId);
                    }
                    if (this.getFf4j().getPropertiesStore().existProperty(featureId)) {
                        message = this.workWithProperties(res, req, operation, featureId);
                    }
                }
            }
        }
        catch (Exception e) {
            messagetype = ERROR;
            message = e.getMessage();
            LOGGER.error("An error occured ", (Throwable)e);
        }
        ConsoleRenderer.renderPage(this.getFf4j(), req, res, message, messagetype);
    }

    private String workWithProperties(HttpServletResponse res, HttpServletRequest req, String operation, String uid) throws IOException {
        Property ap;
        String fixedValue;
        String message = null;
        if ("deleteProperty".equalsIgnoreCase(operation)) {
            this.getFf4j().getPropertiesStore().deleteProperty(uid);
            LOGGER.info("Property '" + uid + "' has been deleted");
            message = ConsoleRenderer.renderMsgProperty(uid, "DELETED");
        }
        if ("readProperty".equalsIgnoreCase(operation)) {
            Property ap2 = this.getFf4j().getPropertiesStore().readProperty(uid);
            res.setContentType("application/json");
            res.getWriter().println(ap2.toString());
        }
        if ("deleteFixedValue".equalsIgnoreCase(operation)) {
            fixedValue = req.getParameter("fixedValue");
            ap = this.getFf4j().getPropertiesStore().readProperty(uid);
            ap.getFixedValues().remove(fixedValue);
            this.getFf4j().getPropertiesStore().updateProperty(ap);
        }
        if ("addFixedValue".equalsIgnoreCase(operation)) {
            fixedValue = req.getParameter("fixedValue");
            ap = this.getFf4j().getPropertiesStore().readProperty(uid);
            ap.add2FixedValueFromString(fixedValue);
            this.getFf4j().getPropertiesStore().updateProperty(ap);
        }
        return message;
    }

    private String workWithFeature(HttpServletResponse res, String operation, String uid) throws IOException {
        String message = null;
        if ("disable".equalsIgnoreCase(operation)) {
            this.getFf4j().getFeatureStore().disable(uid);
            res.setContentType("text/html");
            res.getWriter().println(ConsoleRenderer.renderMessageBox(ConsoleRenderer.msg(uid, "DISABLED"), "info"));
            LOGGER.info(uid + " has been disabled");
        }
        if ("enable".equalsIgnoreCase(operation)) {
            this.getFf4j().getFeatureStore().enable(uid);
            res.setContentType("text/html");
            res.getWriter().println(ConsoleRenderer.renderMessageBox(ConsoleRenderer.msg(uid, "ENABLED"), "info"));
            LOGGER.info("Feature '" + uid + "' has been successfully enabled");
        }
        if ("readFeature".equalsIgnoreCase(operation)) {
            Feature f = this.getFf4j().getFeatureStore().read(uid);
            res.setContentType("application/json");
            res.getWriter().println(f.toJson());
        }
        if ("delete".equalsIgnoreCase(operation)) {
            this.getFf4j().getFeatureStore().delete(uid);
            LOGGER.info(uid + " has been deleted");
            message = ConsoleRenderer.msg(uid, "DELETED");
        }
        return message;
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String message = null;
        String messagetype = "info";
        try {
            if (ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
                List items = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory()).parseRequest(req);
                for (FileItem item : items) {
                    if (item.isFormField()) {
                        if (!"op".equalsIgnoreCase(item.getFieldName())) continue;
                        LOGGER.info("Processing action : " + item.getString());
                        continue;
                    }
                    if (!"flipFile".equalsIgnoreCase(item.getFieldName())) continue;
                    String filename = FilenameUtils.getName((String)item.getName());
                    if (filename.toLowerCase().endsWith("xml")) {
                        ConsoleOperations.importFile(this.getFf4j(), (FF4jConfiguration)new XmlParser().parseConfigurationFile(item.getInputStream()));
                        message = "The file <b>" + filename + "</b> has been successfully imported";
                        continue;
                    }
                    messagetype = ERROR;
                    message = "Invalid FILE, must be CSV, XML or PROPERTIES files";
                }
            } else {
                String operation = req.getParameter("op");
                String uid = req.getParameter("uid");
                LOGGER.info("POST - op=" + operation + " feat=" + uid);
                if (operation != null && !operation.isEmpty()) {
                    if ("update".equalsIgnoreCase(operation)) {
                        ConsoleOperations.updateFeatureDescription(this.getFf4j(), req);
                        message = ConsoleRenderer.msg(uid, "UPDATED");
                    } else if ("updateProperty".equalsIgnoreCase(operation)) {
                        ConsoleOperations.updateProperty(this.getFf4j(), req);
                        message = ConsoleRenderer.renderMsgProperty(uid, "UPDATED");
                    } else if ("createProperty".equalsIgnoreCase(operation)) {
                        ConsoleOperations.createProperty(this.getFf4j(), req);
                        message = ConsoleRenderer.renderMsgProperty(req.getParameter("name"), "ADDED");
                    } else if ("create".equalsIgnoreCase(operation)) {
                        ConsoleOperations.createFeature(this.getFf4j(), req);
                        message = ConsoleRenderer.msg(uid, "ADDED");
                    } else if ("toggleGroup".equalsIgnoreCase(operation)) {
                        String groupName = req.getParameter("groupName");
                        if (groupName != null && !groupName.isEmpty()) {
                            String operationGroup = req.getParameter("ope");
                            if ("enable".equalsIgnoreCase(operationGroup)) {
                                this.getFf4j().getFeatureStore().enableGroup(groupName);
                                message = ConsoleRenderer.renderMsgGroup(groupName, "ENABLED");
                                LOGGER.info("Group '" + groupName + "' has been ENABLED.");
                            } else if ("disable".equalsIgnoreCase(operationGroup)) {
                                this.getFf4j().getFeatureStore().disableGroup(groupName);
                                message = ConsoleRenderer.renderMsgGroup(groupName, "DISABLED");
                                LOGGER.info("Group '" + groupName + "' has been DISABLED.");
                            }
                        }
                    } else {
                        LOGGER.error("Invalid POST OPERATION" + operation);
                        messagetype = ERROR;
                        message = "Invalid REQUEST";
                    }
                } else {
                    LOGGER.error("No ID provided" + operation);
                    messagetype = ERROR;
                    message = "Invalid UID";
                }
            }
        }
        catch (Exception e) {
            messagetype = ERROR;
            message = e.getMessage();
            LOGGER.error("An error occured ", (Throwable)e);
        }
        this.getServletContext().setAttribute("FF4J", (Object)this.ff4j);
        ConsoleRenderer.renderPage(this.ff4j, req, res, message, messagetype);
    }

    public FF4j getFf4j() {
        if (this.ff4j == null) {
            throw new IllegalStateException("Console Servlet has not been initialized, please set 'load-at-startup' to 1");
        }
        return this.ff4j;
    }

    public void setFf4j(FF4j ff4j) {
        this.ff4j = ff4j;
    }
}

