/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.command;

import java.util.Objects;
import java.util.concurrent.Callable;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.callback.Event;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.api.resolver.ResolvedMigration;
import org.flywaydb.core.internal.callback.CallbackExecutor;
import org.flywaydb.core.internal.database.base.Connection;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.info.MigrationInfoImpl;
import org.flywaydb.core.internal.info.MigrationInfoServiceImpl;
import org.flywaydb.core.internal.jdbc.TransactionTemplate;
import org.flywaydb.core.internal.schemahistory.AppliedMigration;
import org.flywaydb.core.internal.schemahistory.SchemaHistory;
import org.flywaydb.core.internal.util.StopWatch;
import org.flywaydb.core.internal.util.TimeFormat;

public class DbRepair {
    private static final Log LOG = LogFactory.getLog(DbRepair.class);
    private final Connection connection;
    private final MigrationInfoServiceImpl migrationInfoService;
    private final SchemaHistory schemaHistory;
    private final CallbackExecutor callbackExecutor;
    private final Database database;

    public DbRepair(Database database, MigrationResolver migrationResolver, SchemaHistory schemaHistory, CallbackExecutor callbackExecutor, Configuration configuration) {
        this.database = database;
        this.connection = database.getMainConnection();
        this.migrationInfoService = new MigrationInfoServiceImpl(migrationResolver, schemaHistory, configuration, MigrationVersion.LATEST, true, true, true, true, true);
        this.schemaHistory = schemaHistory;
        this.callbackExecutor = callbackExecutor;
    }

    public void repair() {
        this.callbackExecutor.onEvent(Event.BEFORE_REPAIR);
        try {
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            boolean repaired = new TransactionTemplate(this.connection.getJdbcConnection()).execute(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    DbRepair.this.schemaHistory.removeFailedMigrations();
                    DbRepair.this.migrationInfoService.refresh();
                    return DbRepair.this.alignAppliedMigrationsWithResolvedMigrations();
                }
            });
            stopWatch.stop();
            LOG.info("Successfully repaired schema history table " + this.schemaHistory + " (execution time " + TimeFormat.format(stopWatch.getTotalTimeMillis()) + ").");
            if (repaired && !this.database.supportsDdlTransactions()) {
                LOG.info("Manual cleanup of the remaining effects the failed migration may still be required.");
            }
        }
        catch (FlywayException e) {
            this.callbackExecutor.onEvent(Event.AFTER_REPAIR_ERROR);
            throw e;
        }
        this.callbackExecutor.onEvent(Event.AFTER_REPAIR);
    }

    private boolean alignAppliedMigrationsWithResolvedMigrations() {
        boolean repaired = false;
        for (MigrationInfo migrationInfo : this.migrationInfoService.all()) {
            MigrationInfoImpl migrationInfoImpl = (MigrationInfoImpl)migrationInfo;
            ResolvedMigration resolved = migrationInfoImpl.getResolvedMigration();
            AppliedMigration applied = migrationInfoImpl.getAppliedMigration();
            if (resolved == null || resolved.getVersion() == null || applied == null || applied.getType().isSynthetic() || !this.updateNeeded(resolved, applied)) continue;
            this.schemaHistory.update(applied, resolved);
            repaired = true;
        }
        return repaired;
    }

    private boolean updateNeeded(ResolvedMigration resolved, AppliedMigration applied) {
        return this.checksumUpdateNeeded(resolved, applied) || this.descriptionUpdateNeeded(resolved, applied) || this.typeUpdateNeeded(resolved, applied);
    }

    private boolean checksumUpdateNeeded(ResolvedMigration resolved, AppliedMigration applied) {
        return !Objects.equals(resolved.getChecksum(), applied.getChecksum());
    }

    private boolean descriptionUpdateNeeded(ResolvedMigration resolved, AppliedMigration applied) {
        return !Objects.equals(resolved.getDescription(), applied.getDescription());
    }

    private boolean typeUpdateNeeded(ResolvedMigration resolved, AppliedMigration applied) {
        return !Objects.equals((Object)resolved.getType(), (Object)applied.getType());
    }
}

