/*
 * Decompiled with CFR 0.152.
 */
package org.funktionale.tries;

import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.funktionale.either.Disjunction;
import org.funktionale.either.Either;
import org.funktionale.option.Option;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002+,B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u001c\u0010\u0006\u001a\u0018\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\u0007j\b\u0012\u0004\u0012\u00028\u0000`\bJ\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0000J*\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u001c\u0010\u0006\u001a\u0018\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\u0007j\b\u0012\u0004\u0012\u00028\u0000`\bJ,\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\r0\u0000\"\u0004\b\u0001\u0010\r2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\r0\u00000\u0007J9\u0010\u000f\u001a\u0002H\r\"\u0004\b\u0001\u0010\r2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\r0\u00072\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u0002H\r0\u0007\u00a2\u0006\u0002\u0010\u0011J\u001a\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00130\u0007J\r\u0010\u0014\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0015J\u0019\u0010\u0016\u001a\u00028\u00002\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017\u00a2\u0006\u0002\u0010\u0018J \u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u00000\u0007J\u000e\u0010\u001a\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u001b\u001a\u00020\u0005H&J\b\u0010\u001c\u001a\u00020\u0005H&J&\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\r0\u0000\"\u0004\b\u0001\u0010\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\r0\u0007J \u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00130\u0007J \u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00130\u0007J \u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00130\u0007J \u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00000\u0017J&\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00000\u0007J\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u00000%J\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u00000'J\f\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000)JF\u0010*\u001a\b\u0012\u0004\u0012\u0002H\r0\u0000\"\u0004\b\u0001\u0010\r2\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\r0\u00000\u00072\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\r0\u00000\u0007\u0082\u0001\u0002-.\u00a8\u0006/"}, d2={"Lorg/funktionale/tries/Try;", "T", "", "()V", "exists", "", "predicate", "Lkotlin/Function1;", "Lorg/funktionale/utils/Predicate;", "failed", "", "filter", "flatMap", "X", "f", "fold", "s", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "foreach", "", "get", "()Ljava/lang/Object;", "getOrElse", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "handle", "invoke", "isFailure", "isSuccess", "map", "onEach", "onFailure", "body", "onSuccess", "orElse", "rescue", "toDisjunction", "Lorg/funktionale/either/Disjunction;", "toEither", "Lorg/funktionale/either/Either;", "toOption", "Lorg/funktionale/option/Option;", "transform", "Failure", "Success", "Lorg/funktionale/tries/Try$Success;", "Lorg/funktionale/tries/Try$Failure;", "funktionale-try"})
public abstract class Try<T> {
    public abstract boolean isFailure();

    public abstract boolean isSuccess();

    public abstract T get();

    public final T invoke() {
        return this.get();
    }

    public final T getOrElse(@NotNull Function0<? extends T> f) {
        Object object;
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        Try try_ = this;
        if (try_ instanceof Success) {
            object = this.get();
        } else if (try_ instanceof Failure) {
            object = f.invoke();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    @NotNull
    public final Try<T> orElse(@NotNull Function0<? extends Try<T>> f) {
        Try try_;
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        Try try_2 = this;
        if (try_2 instanceof Success) {
            try_ = this;
        } else if (try_2 instanceof Failure) {
            try_ = (Try)f.invoke();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return try_;
    }

    public final void foreach(@NotNull Function1<? super T, Unit> f) {
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        if (this.isSuccess()) {
            f.invoke(this.get());
        }
    }

    @NotNull
    public final Try<T> onEach(@NotNull Function1<? super T, Unit> f) {
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        return this.map((Function1)new Function1<T, T>(f){
            final /* synthetic */ Function1 $f;

            public final T invoke(T it) {
                this.$f.invoke(it);
                return it;
            }
            {
                this.$f = function1;
                super(1);
            }
        });
    }

    @NotNull
    public final <X> Try<X> flatMap(@NotNull Function1<? super T, ? extends Try<X>> f) {
        Try try_;
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        Try try_2 = this;
        if (try_2 instanceof Success) {
            Try try_3;
            try {
                try_3 = (Try)f.invoke(this.get());
            }
            catch (Throwable t) {
                try_3 = new Failure(t);
            }
            try_ = try_3;
        } else if (try_2 instanceof Failure) {
            try_ = new Failure(((Failure)this).getThrowable());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return try_;
    }

    @NotNull
    public final <X> Try<X> map(@NotNull Function1<? super T, ? extends X> f) {
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        return this.flatMap((Function1)new Function1<T, Success<X>>(f){
            final /* synthetic */ Function1 $f;

            @NotNull
            public final Success<X> invoke(T it) {
                return new Success<Object>(this.$f.invoke(it));
            }
            {
                this.$f = function1;
                super(1);
            }
        });
    }

    public final boolean exists(@NotNull Function1<? super T, Boolean> predicate) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
        Try try_ = this;
        if (try_ instanceof Success) {
            bl = (Boolean)predicate.invoke(this.get());
        } else if (try_ instanceof Failure) {
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @NotNull
    public final Try<T> filter(@NotNull Function1<? super T, Boolean> predicate) {
        Try try_;
        Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
        Try try_2 = this;
        if (try_2 instanceof Success) {
            Try try_3;
            try {
                T value = this.get();
                try_3 = (Boolean)predicate.invoke(value) != false ? this : (Try)new Failure(new NoSuchElementException("Predicate does not hold for " + value));
            }
            catch (Throwable t) {
                try_3 = new Failure(t);
            }
            try_ = try_3;
        } else if (try_2 instanceof Failure) {
            try_ = this;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return try_;
    }

    @NotNull
    public final Try<T> rescue(@NotNull Function1<? super Throwable, ? extends Try<T>> f) {
        Try try_;
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        Try try_2 = this;
        if (try_2 instanceof Success) {
            try_ = this;
        } else if (try_2 instanceof Failure) {
            Try try_3;
            try {
                try_3 = (Try)f.invoke((Object)((Failure)this).getThrowable());
            }
            catch (Throwable t) {
                try_3 = new Failure(t);
            }
            try_ = try_3;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return try_;
    }

    @NotNull
    public final Try<T> handle(@NotNull Function1<? super Throwable, ? extends T> f) {
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        return this.rescue((Function1)new Function1<Throwable, Success<T>>(f){
            final /* synthetic */ Function1 $f;

            @NotNull
            public final Success<T> invoke(@NotNull Throwable it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return new Success<Object>(this.$f.invoke((Object)it));
            }
            {
                this.$f = function1;
                super(1);
            }
        });
    }

    @NotNull
    public final Try<T> onSuccess(@NotNull Function1<? super T, Unit> body) {
        Intrinsics.checkParameterIsNotNull(body, (String)"body");
        this.foreach(body);
        return this;
    }

    @NotNull
    public final Try<T> onFailure(@NotNull Function1<? super Throwable, Unit> body) {
        Try try_;
        Intrinsics.checkParameterIsNotNull(body, (String)"body");
        Try try_2 = this;
        if (try_2 instanceof Success) {
            try_ = this;
        } else if (try_2 instanceof Failure) {
            body.invoke((Object)((Failure)this).getThrowable());
            try_ = this;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return try_;
    }

    @NotNull
    public final Option<T> toOption() {
        Option option;
        Try try_ = this;
        if (try_ instanceof Success) {
            option = (Option)new Option.Some(this.get());
        } else if (try_ instanceof Failure) {
            option = (Option)Option.None.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return option;
    }

    @NotNull
    public final Either<Throwable, T> toEither() {
        Either either;
        Try try_ = this;
        if (try_ instanceof Success) {
            either = (Either)Either.Companion.right(this.get());
        } else if (try_ instanceof Failure) {
            either = (Either)Either.Companion.left((Object)((Failure)this).getThrowable());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return either;
    }

    @NotNull
    public final Disjunction<Throwable, T> toDisjunction() {
        return this.toEither().toDisjunction();
    }

    @NotNull
    public final Try<Throwable> failed() {
        Try try_;
        Try try_2 = this;
        if (try_2 instanceof Success) {
            try_ = new Failure(new UnsupportedOperationException("Success"));
        } else if (try_2 instanceof Failure) {
            try_ = new Success<Throwable>(((Failure)this).getThrowable());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return try_;
    }

    @NotNull
    public final <X> Try<X> transform(@NotNull Function1<? super T, ? extends Try<X>> s, @NotNull Function1<? super Throwable, ? extends Try<X>> f) {
        Try try_;
        Intrinsics.checkParameterIsNotNull(s, (String)"s");
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        Try try_2 = this;
        if (try_2 instanceof Success) {
            try_ = this.flatMap(s);
        } else if (try_2 instanceof Failure) {
            Try try_3;
            try {
                try_3 = (Try)f.invoke((Object)((Failure)this).getThrowable());
            }
            catch (Throwable t) {
                try_3 = new Failure(t);
            }
            try_ = try_3;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return try_;
    }

    public final <X> X fold(@NotNull Function1<? super T, ? extends X> s, @NotNull Function1<? super Throwable, ? extends X> f) {
        Object object;
        Intrinsics.checkParameterIsNotNull(s, (String)"s");
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        Try try_ = this;
        if (try_ instanceof Success) {
            Object object2;
            try {
                object2 = s.invoke(this.get());
            }
            catch (Throwable t) {
                object2 = f.invoke((Object)t);
            }
            object = object2;
        } else if (try_ instanceof Failure) {
            object = f.invoke((Object)((Failure)this).getThrowable());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return (X)object;
    }

    private Try() {
    }

    public /* synthetic */ Try(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0096\u0002J\r\u0010\n\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0007H\u0016J\b\u0010\u000f\u001a\u00020\u0007H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0010\u0010\u0003\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005\u00a8\u0006\u0012"}, d2={"Lorg/funktionale/tries/Try$Success;", "T", "Lorg/funktionale/tries/Try;", "t", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "equals", "", "other", "", "get", "()Ljava/lang/Object;", "hashCode", "", "isFailure", "isSuccess", "toString", "", "funktionale-try"})
    public static final class Success<T>
    extends Try<T> {
        private final T t;

        @Override
        public T get() {
            return this.t;
        }

        @Override
        public boolean isFailure() {
            return false;
        }

        @Override
        public boolean isSuccess() {
            return true;
        }

        @NotNull
        public String toString() {
            return "Success(" + this.t + ')';
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Success)) {
                return false;
            }
            return !(Intrinsics.areEqual(this.t, ((Success)other).t) ^ true);
        }

        public int hashCode() {
            T t = this.t;
            return t != null ? t.hashCode() : 0;
        }

        public Success(T t) {
            super(null);
            this.t = t;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0096\u0002J\r\u0010\f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\tH\u0016J\b\u0010\u0011\u001a\u00020\tH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/funktionale/tries/Try$Failure;", "T", "Lorg/funktionale/tries/Try;", "throwable", "", "(Ljava/lang/Throwable;)V", "getThrowable", "()Ljava/lang/Throwable;", "equals", "", "other", "", "get", "()Ljava/lang/Object;", "hashCode", "", "isFailure", "isSuccess", "toString", "", "funktionale-try"})
    public static final class Failure<T>
    extends Try<T> {
        @NotNull
        private final Throwable throwable;

        @Override
        public T get() {
            throw this.throwable;
        }

        @Override
        public boolean isFailure() {
            return true;
        }

        @Override
        public boolean isSuccess() {
            return false;
        }

        @NotNull
        public String toString() {
            return "Failure(" + this.throwable + ')';
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Failure)) {
                return false;
            }
            return !(Intrinsics.areEqual((Object)this.throwable, (Object)((Failure)other).throwable) ^ true);
        }

        public int hashCode() {
            return this.throwable.hashCode();
        }

        @NotNull
        public final Throwable getThrowable() {
            return this.throwable;
        }

        public Failure(@NotNull Throwable throwable) {
            Intrinsics.checkParameterIsNotNull((Object)throwable, (String)"throwable");
            super(null);
            this.throwable = throwable;
        }
    }
}

