/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ant.embedded.tasks;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.glassfish.ant.embedded.tasks.TaskBase;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.embedded.EmbeddedDeployer;
import org.glassfish.api.embedded.Server;

public class DeployTask
extends TaskBase {
    String serverID = "EmbeddedServer";
    String app = null;
    DeployCommandParameters cmdParams = new DeployCommandParameters();

    public void setServerID(String serverID) {
        this.serverID = serverID;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public void setName(String name) {
        this.cmdParams.name = name;
    }

    public void setContextroot(String contextroot) {
        this.cmdParams.contextroot = contextroot;
    }

    public void setForce(boolean force) {
        this.cmdParams.force = force;
    }

    public void setPrecompilejsp(boolean precompilejsp) {
        this.cmdParams.precompilejsp = precompilejsp;
    }

    public void setVerify(boolean verify) {
        this.cmdParams.verify = verify;
    }

    public void setCreatetables(boolean createtables) {
        this.cmdParams.createtables = createtables;
    }

    public void setDropandcreatetables(boolean dropandcreatetables) {
        this.cmdParams.dropandcreatetables = dropandcreatetables;
    }

    public void setUniquetablenames(boolean uniquetablenames) {
        this.cmdParams.uniquetablenames = uniquetablenames;
    }

    public void setEnabled(boolean enabled) {
        this.cmdParams.enabled = enabled;
    }

    public void setAvailabilityenabled(boolean availabilityenabled) {
        this.cmdParams.availabilityenabled = availabilityenabled;
    }

    public void setDescription(String description) {
        this.cmdParams.description = description;
    }

    public void setVirtualservers(String virtualservers) {
        this.cmdParams.virtualservers = virtualservers;
    }

    public void setRetrievestubs(String retrieve) {
        this.cmdParams.retrieve = retrieve;
    }

    public void setdbvendorname(String dbvendorname) {
        this.cmdParams.dbvendorname = dbvendorname;
    }

    public void setLibraries(String libraries) {
        this.cmdParams.libraries = libraries;
    }

    public void setDeploymentPlan(String deploymentplan) {
        if (deploymentplan != null) {
            this.cmdParams.deploymentplan = new File(deploymentplan);
        }
    }

    public void execute() throws BuildException {
        if (this.app == null) {
            this.error("app not specified");
            return;
        }
        this.log("deploying " + this.app);
        File f = new File(this.app);
        if (!f.exists()) {
            this.error(this.app + " not found");
            return;
        }
        Server server = Server.getServer((String)this.serverID);
        if (server == null) {
            this.error("Embedded Server [" + this.serverID + "] not running");
            return;
        }
        EmbeddedDeployer deployer = server.getDeployer();
        deployer.deploy(new File(this.app), this.cmdParams);
    }
}

