/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ant.embedded.tasks;

import org.apache.tools.ant.BuildException;
import org.glassfish.ant.embedded.tasks.TaskBase;
import org.glassfish.ant.embedded.tasks.Util;
import org.glassfish.api.embedded.ContainerBuilder;
import org.glassfish.api.embedded.Server;

public class StartServerTask
extends TaskBase {
    String serverID = "EmbeddedServer";
    int port = -1;
    String installRoot = null;
    String instanceRoot = null;
    String configFile = null;
    Boolean autoDelete;
    ContainerBuilder.Type containerType = ContainerBuilder.Type.all;

    public void setServerID(String serverID) {
        this.serverID = serverID;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setInstallRoot(String installRoot) {
        this.installRoot = installRoot;
    }

    public void setInstanceRoot(String instanceRoot) {
        this.instanceRoot = instanceRoot;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public void setAutoDelete(Boolean autoDelete) {
        this.autoDelete = autoDelete;
    }

    public void execute() throws BuildException {
        try {
            Server server = Server.getServer((String)this.serverID);
            if (server != null) {
                return;
            }
            this.log("Starting server");
            server = Util.getServer(this.serverID, this.installRoot, this.instanceRoot, this.configFile, this.autoDelete);
            Util.createPort(server, this.configFile, this.port);
            server.addContainer(this.getContainerType());
            server.start();
        }
        catch (Exception ex) {
            this.error(ex);
        }
    }

    ContainerBuilder.Type getContainerType() {
        return this.containerType;
    }

    void setContainerType(ContainerBuilder.Type type) {
        this.containerType = type;
    }
}

