/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.api;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class MultiException
extends RuntimeException {
    private static final long serialVersionUID = 2112432697858621044L;
    private final List<Throwable> throwables = new LinkedList<Throwable>();

    public MultiException() {
    }

    public MultiException(List<Throwable> th) {
        super(th.get(0).getMessage(), th.get(0));
        this.throwables.addAll(th);
    }

    public MultiException(Throwable th) {
        super(th.getMessage(), th);
        this.throwables.add(th);
    }

    public List<Throwable> getErrors() {
        return Collections.unmodifiableList(this.throwables);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MultiException(");
        int lcv = 1;
        for (Throwable th : this.throwables) {
            sb.append("\n" + lcv++ + ". " + th.getMessage());
        }
        if (this.throwables.isEmpty()) {
            sb.append(System.identityHashCode(this) + ")");
        } else {
            sb.append("\n" + System.identityHashCode(this) + ")");
        }
        return sb.toString();
    }
}

