/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.enterprise.builtins.modules;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.enterprise.builtins.modules.PickleModuleBuiltinsClinicProviders;
import com.oracle.graal.python.enterprise.builtins.modules.PickleModuleBuiltinsFactory;
import com.oracle.graal.python.enterprise.builtins.objects.pickle.PPickleBuffer;
import com.oracle.graal.python.enterprise.builtins.objects.pickle.PPickler;
import com.oracle.graal.python.enterprise.builtins.objects.pickle.PPicklerMemoProxy;
import com.oracle.graal.python.enterprise.builtins.objects.pickle.PUnpickler;
import com.oracle.graal.python.enterprise.builtins.objects.pickle.PUnpicklerMemoProxy;
import com.oracle.graal.python.enterprise.builtins.objects.pickle.PickleState;
import com.oracle.graal.python.enterprise.builtins.objects.pickle.PickleStateFactory;
import com.oracle.graal.python.enterprise.builtins.objects.pickle.PickleUtils;
import com.oracle.graal.python.enterprise.builtins.runtime.object.EnterprisePythonObjectFactory;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.nodes.PNodeWithRaise;
import com.oracle.graal.python.nodes.PNodeWithRaiseAndIndirectCall;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(defineModule="_pickle")
public final class PickleModuleBuiltins
extends PythonBuiltins {
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return PickleModuleBuiltinsFactory.getFactories();
    }

    public void postInitialize(Python3Core core) {
        super.postInitialize(core);
        PickleState state = new PickleState();
        PickleState.PickleStateInitNode initNode = PickleStateFactory.PickleStateInitNodeGen.getUncached();
        initNode.execute(state);
        core.lookupType(PythonBuiltinClassType.Pickler).setAttribute((Object)PickleUtils.PICKLE_STATE_KEY, (Object)state);
    }

    @Builtin(name="loads", minNumOfPositionalArgs=2, declaresExplicitSelf=true, varArgsMarker=true, parameterNames={"$self", "data"}, keywordOnlyNames={"fix_imports", "encoding", "errors", "buffers"})
    @ArgumentsClinic(value={@ArgumentClinic(name="data", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer), @ArgumentClinic(name="fix_imports", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="true"), @ArgumentClinic(name="encoding", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="T_ASCII_UPPERCASE"), @ArgumentClinic(name="errors", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="T_STRICT")})
    @GenerateNodeFactory
    static abstract class PickleLoadsNode
    extends PythonClinicBuiltinNode {
        PickleLoadsNode() {
        }

        protected ArgumentClinicProvider getArgumentClinic() {
            return PickleModuleBuiltinsClinicProviders.PickleLoadsNodeClinicProviderGen.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        Object loads(VirtualFrame frame, PythonModule self, Object buffer, boolean fixImports, TruffleString encoding, TruffleString errors, Object buffers, @CachedLibrary(value="buffer") PythonBufferAccessLibrary bufferLib, @Bind(value="this") Node inliningTarget, @Cached PUnpickler.LoadNode loadNode, @Cached PyObjectGetIter getIter) {
            try {
                PUnpickler unpickler = EnterprisePythonObjectFactory.createUnpickler(this.factory());
                byte[] data = bufferLib.getCopiedByteArray(buffer);
                unpickler.setStringInput(data, data.length);
                unpickler.setInputEncoding(encoding, errors);
                unpickler.setBuffers(frame, inliningTarget, getIter, buffers);
                unpickler.setFixImports(fixImports);
                Object object = loadNode.execute(frame, unpickler);
                return object;
            }
            finally {
                bufferLib.release(buffer, frame, (Node)this);
            }
        }
    }

    @Builtin(name="load", minNumOfPositionalArgs=2, declaresExplicitSelf=true, parameterNames={"$self", "file"}, varArgsMarker=true, keywordOnlyNames={"fix_imports", "encoding", "errors", "buffers"})
    @ArgumentsClinic(value={@ArgumentClinic(name="fix_imports", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="true"), @ArgumentClinic(name="encoding", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="T_ASCII_UPPERCASE"), @ArgumentClinic(name="errors", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="T_STRICT")})
    @GenerateNodeFactory
    static abstract class PickleLoadNode
    extends PythonClinicBuiltinNode {
        PickleLoadNode() {
        }

        protected ArgumentClinicProvider getArgumentClinic() {
            return PickleModuleBuiltinsClinicProviders.PickleLoadNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        Object load(VirtualFrame frame, PythonModule self, Object file, boolean fixImports, TruffleString encoding, TruffleString errors, Object buffers, @Bind(value="this") Node inliningTarget, @Cached PUnpickler.LoadNode loadNode, @Cached PyObjectLookupAttr lookup, @Cached PyObjectGetIter getIter) {
            PUnpickler unpickler = EnterprisePythonObjectFactory.createUnpickler(this.factory());
            unpickler.setInputStream(frame, inliningTarget, (PNodeWithRaise)this, lookup, file);
            unpickler.setInputEncoding(encoding, errors);
            unpickler.setBuffers(frame, inliningTarget, getIter, buffers);
            return loadNode.execute(frame, unpickler);
        }
    }

    @Builtin(name="dumps", minNumOfPositionalArgs=2, declaresExplicitSelf=true, varArgsMarker=true, parameterNames={"$self", "obj", "protocol"}, keywordOnlyNames={"fix_imports", "buffer_callback"})
    @ArgumentsClinic(value={@ArgumentClinic(name="protocol", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="4", useDefaultForNone=true), @ArgumentClinic(name="fix_imports", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="true")})
    @GenerateNodeFactory
    static abstract class PickleDumpsNode
    extends PythonClinicBuiltinNode {
        PickleDumpsNode() {
        }

        protected ArgumentClinicProvider getArgumentClinic() {
            return PickleModuleBuiltinsClinicProviders.PickleDumpsNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        Object dump(VirtualFrame frame, PythonModule self, Object obj, int protocol, boolean fixImports, Object bufferCallback, @Cached PPickler.DumpNode dumpNode) {
            PPickler pickler = EnterprisePythonObjectFactory.createPickler(this.factory());
            pickler.setProtocol((PNodeWithRaise)this, protocol, fixImports);
            pickler.setBufferCallback((PNodeWithRaise)this, bufferCallback);
            dumpNode.execute(frame, pickler, obj);
            return pickler.getString(this.factory());
        }
    }

    @Builtin(name="dump", minNumOfPositionalArgs=3, declaresExplicitSelf=true, varArgsMarker=true, parameterNames={"$self", "obj", "file", "protocol"}, keywordOnlyNames={"fix_imports", "buffer_callback"})
    @ArgumentsClinic(value={@ArgumentClinic(name="protocol", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="4", useDefaultForNone=true), @ArgumentClinic(name="fix_imports", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="true")})
    @GenerateNodeFactory
    static abstract class PickleDumpNode
    extends PythonClinicBuiltinNode {
        PickleDumpNode() {
        }

        protected ArgumentClinicProvider getArgumentClinic() {
            return PickleModuleBuiltinsClinicProviders.PickleDumpNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        Object dump(VirtualFrame frame, PythonModule self, Object obj, Object file, int protocol, boolean fixImports, Object bufferCallback, @Bind(value="this") Node inliningTarget, @Cached PPickler.DumpNode dumpNode, @Cached PPickler.FlushToFileNode flushToFileNode, @Cached PyObjectLookupAttr lookup) {
            PPickler pickler = EnterprisePythonObjectFactory.createPickler(this.factory());
            pickler.setProtocol((PNodeWithRaise)this, protocol, fixImports);
            pickler.setOutputStream(frame, inliningTarget, (PNodeWithRaise)this, lookup, file);
            pickler.setBufferCallback((PNodeWithRaise)this, bufferCallback);
            dumpNode.execute(frame, pickler, obj);
            flushToFileNode.execute(frame, pickler);
            return PNone.NONE;
        }
    }

    @Builtin(name="Unpickler", minNumOfPositionalArgs=1, constructsClass=PythonBuiltinClassType.Unpickler, takesVarArgs=true, takesVarKeywordArgs=true, declaresExplicitSelf=true)
    @GenerateNodeFactory
    static abstract class ConstructUnpicklerNode
    extends PythonVarargsBuiltinNode {
        ConstructUnpicklerNode() {
        }

        @Specialization
        PUnpickler construct(Object cls, Object[] arguments, PKeyword[] keywords) {
            return EnterprisePythonObjectFactory.createUnpickler(this.factory(), cls);
        }
    }

    @Builtin(name="UnpicklerMemoProxy", minNumOfPositionalArgs=2, parameterNames={"$cls", "unpickler"}, constructsClass=PythonBuiltinClassType.UnpicklerMemoProxy)
    @GenerateNodeFactory
    static abstract class ConstructUnpicklerMemoProxyNode
    extends PythonBinaryBuiltinNode {
        ConstructUnpicklerMemoProxyNode() {
        }

        @Specialization
        PUnpicklerMemoProxy construct(Object cls, PUnpickler unpickler) {
            return EnterprisePythonObjectFactory.createUnpicklerMemoProxy(this.factory(), unpickler, cls);
        }
    }

    @Builtin(name="PicklerMemoProxy", minNumOfPositionalArgs=2, parameterNames={"$cls", "pickler"}, constructsClass=PythonBuiltinClassType.PicklerMemoProxy)
    @GenerateNodeFactory
    static abstract class ConstructPicklerMemoProxyNode
    extends PythonBinaryBuiltinNode {
        ConstructPicklerMemoProxyNode() {
        }

        @Specialization
        PPicklerMemoProxy construct(Object cls, PPickler pickler) {
            return EnterprisePythonObjectFactory.createPicklerMemoProxy(this.factory(), pickler, cls);
        }
    }

    @Builtin(name="Pickler", minNumOfPositionalArgs=1, constructsClass=PythonBuiltinClassType.Pickler, takesVarArgs=true, takesVarKeywordArgs=true, declaresExplicitSelf=true)
    @GenerateNodeFactory
    static abstract class ConstructPicklerNode
    extends PythonVarargsBuiltinNode {
        ConstructPicklerNode() {
        }

        @Specialization
        PPickler construct(Object cls, Object[] arguments, PKeyword[] keywords) {
            return EnterprisePythonObjectFactory.createPickler(this.factory(), cls);
        }
    }

    @Builtin(name="PickleBuffer", minNumOfPositionalArgs=2, parameterNames={"$cls", "object"}, constructsClass=PythonBuiltinClassType.PickleBuffer)
    @GenerateNodeFactory
    static abstract class ConstructPickleBufferNode
    extends PythonBinaryBuiltinNode {
        ConstructPickleBufferNode() {
        }

        @Specialization(limit="3")
        PPickleBuffer construct(VirtualFrame frame, Object cls, Object object, @CachedLibrary(value="object") PythonBufferAcquireLibrary acquireLib) {
            Object buffer = acquireLib.acquireReadonly(object, frame, (PNodeWithRaiseAndIndirectCall)this);
            return EnterprisePythonObjectFactory.createPickleBuffer(this.factory(), buffer);
        }
    }
}

