/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.enterprise.builtins.objects.struct;

import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.enterprise.builtins.objects.struct.FormatAlignment;
import com.oracle.graal.python.enterprise.builtins.objects.struct.FormatCode;
import com.oracle.graal.python.util.NumericSupport;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.Shape;

public final class PStruct
extends PythonBuiltinObject {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final byte[] format;
    private final int size;
    private final int len;
    public final FormatAlignment formatAlignment;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final FormatCode[] codes;

    public PStruct(Object clazz, Shape instanceShape, StructInfo structInfo) {
        this(clazz, instanceShape, structInfo.format, structInfo.size, structInfo.len, structInfo.formatAlignment, structInfo.codes);
    }

    public PStruct(Object clazz, Shape instanceShape, byte[] format, int size, int len, FormatAlignment formatAlignment, FormatCode[] codes) {
        super(clazz, instanceShape);
        this.format = format;
        this.size = size;
        this.len = len;
        this.formatAlignment = formatAlignment;
        this.codes = codes;
    }

    public int getSize() {
        return this.size;
    }

    public long getUnsignedSize() {
        return NumericSupport.asUnsigned((int)this.size);
    }

    public FormatCode[] getCodes() {
        return this.codes;
    }

    public byte[] getFormat() {
        return this.format;
    }

    public int getLen() {
        return this.len;
    }

    public boolean isBigEndian() {
        return this.formatAlignment.bigEndian;
    }

    public boolean isNative() {
        return this.formatAlignment.nativeSizing;
    }

    @CompilerDirectives.ValueType
    public static final class StructInfo {
        public final byte[] format;
        public final int size;
        public final int len;
        public final FormatAlignment formatAlignment;
        public final FormatCode[] codes;

        public StructInfo(byte[] format, int size, int len, FormatAlignment formatAlignment, FormatCode[] codes) {
            this.format = format;
            this.size = size;
            this.len = len;
            this.formatAlignment = formatAlignment;
            this.codes = codes;
        }
    }
}

