/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.QueueModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.queue.PSimpleQueue;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import java.util.List;

@CoreFunctions(defineModule="_queue")
public final class QueueModuleBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return QueueModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        super.initialize(core);
        this.addBuiltinConstant(BuiltinNames.T_EMPTY_CLASS_NAME, (Object)core.lookupType(PythonBuiltinClassType.Empty));
    }

    @Builtin(name="SimpleQueue", constructsClass=PythonBuiltinClassType.PSimpleQueue, minNumOfPositionalArgs=1, doc="SimpleQueue()\n--\n\nSimple, unbounded, reentrant FIFO queue.")
    @GenerateNodeFactory
    static abstract class SimpleQueueNode
    extends PythonUnaryBuiltinNode {
        SimpleQueueNode() {
        }

        @Specialization
        static PSimpleQueue doGeneric(Object cls, @Cached PythonObjectFactory factory) {
            return factory.createSimpleQueue(cls);
        }
    }
}

