/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.ast;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.ast.AstState;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.pegparser.sst.AliasTy;
import com.oracle.graal.python.pegparser.sst.ArgTy;
import com.oracle.graal.python.pegparser.sst.ArgumentsTy;
import com.oracle.graal.python.pegparser.sst.ComprehensionTy;
import com.oracle.graal.python.pegparser.sst.ConstantValue;
import com.oracle.graal.python.pegparser.sst.ExceptHandlerTy;
import com.oracle.graal.python.pegparser.sst.ExprContextTy;
import com.oracle.graal.python.pegparser.sst.ExprTy;
import com.oracle.graal.python.pegparser.sst.KeywordTy;
import com.oracle.graal.python.pegparser.sst.MatchCaseTy;
import com.oracle.graal.python.pegparser.sst.ModTy;
import com.oracle.graal.python.pegparser.sst.OperatorTy;
import com.oracle.graal.python.pegparser.sst.PatternTy;
import com.oracle.graal.python.pegparser.sst.SSTreeVisitor;
import com.oracle.graal.python.pegparser.sst.StmtTy;
import com.oracle.graal.python.pegparser.sst.TypeIgnoreTy;
import com.oracle.graal.python.pegparser.sst.UnaryOpTy;
import com.oracle.graal.python.pegparser.sst.WithItemTy;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.truffle.api.strings.TruffleString;

final class Validator
implements SSTreeVisitor<Void> {
    private static final String[] FORBIDDEN_NAMES = new String[]{"None", "True", "False"};
    private ExprContextTy expectedContext;
    boolean isStarPatternOk;

    private Validator() {
    }

    static void validateMod(ModTy mod) {
        mod.accept(new Validator());
    }

    @Override
    public Void visit(ModTy.Module node) {
        this.validateStmts(node.body);
        return null;
    }

    @Override
    public Void visit(ModTy.Interactive node) {
        this.validateStmts(node.body);
        return null;
    }

    @Override
    public Void visit(ModTy.Expression node) {
        this.validateExpr(node.body, ExprContextTy.Load);
        return null;
    }

    @Override
    public Void visit(ModTy.FunctionType node) {
        this.validateExprs(node.argTypes, ExprContextTy.Load, false);
        this.validateExpr(node.returns, ExprContextTy.Load);
        return null;
    }

    private void validateStmt(StmtTy stmt) {
        stmt.accept(this);
    }

    @Override
    public Void visit(StmtTy.FunctionDef node) {
        this.validateBody(node.body, AstState.T_C_FUNCTIONDEF);
        this.visit(node.args);
        this.validateExprs(node.decoratorList, ExprContextTy.Load, false);
        if (node.returns != null) {
            this.validateExpr(node.returns, ExprContextTy.Load);
        }
        return null;
    }

    @Override
    public Void visit(StmtTy.ClassDef node) {
        this.validateBody(node.body, AstState.T_C_CLASSDEF);
        this.validateExprs(node.bases, ExprContextTy.Load, false);
        this.validateKeywords(node.keywords);
        this.validateExprs(node.decoratorList, ExprContextTy.Load, false);
        return null;
    }

    @Override
    public Void visit(StmtTy.Return node) {
        if (node.value != null) {
            this.validateExpr(node.value, ExprContextTy.Load);
        }
        return null;
    }

    @Override
    public Void visit(StmtTy.Delete node) {
        this.validateAssignList(node.targets, ExprContextTy.Del);
        return null;
    }

    @Override
    public Void visit(StmtTy.Assign node) {
        this.validateAssignList(node.targets, ExprContextTy.Store);
        this.validateExpr(node.value, ExprContextTy.Load);
        return null;
    }

    @Override
    public Void visit(StmtTy.AugAssign node) {
        this.validateExpr(node.target, ExprContextTy.Store);
        this.validateExpr(node.value, ExprContextTy.Load);
        return null;
    }

    @Override
    public Void visit(StmtTy.AnnAssign node) {
        if (!(node.target instanceof ExprTy.Name) && node.isSimple) {
            throw Validator.raiseTypeError(ErrorMessages.ANN_ASSIGN_WITH_SIMPLE_NON_NAME_TARGET, new Object[0]);
        }
        this.validateExpr(node.target, ExprContextTy.Store);
        if (node.value != null) {
            this.validateExpr(node.value, ExprContextTy.Load);
        }
        this.validateExpr(node.annotation, ExprContextTy.Load);
        return null;
    }

    @Override
    public Void visit(StmtTy.For node) {
        this.validateExpr(node.target, ExprContextTy.Store);
        this.validateExpr(node.iter, ExprContextTy.Load);
        this.validateBody(node.body, AstState.T_C_FOR);
        this.validateStmts(node.orElse);
        return null;
    }

    @Override
    public Void visit(StmtTy.AsyncFor node) {
        this.validateExpr(node.target, ExprContextTy.Store);
        this.validateExpr(node.iter, ExprContextTy.Load);
        this.validateBody(node.body, AstState.T_C_ASYNCFOR);
        this.validateStmts(node.orElse);
        return null;
    }

    @Override
    public Void visit(StmtTy.While node) {
        this.validateExpr(node.test, ExprContextTy.Load);
        this.validateBody(node.body, AstState.T_C_WHILE);
        this.validateStmts(node.orElse);
        return null;
    }

    @Override
    public Void visit(StmtTy.If node) {
        this.validateExpr(node.test, ExprContextTy.Load);
        this.validateBody(node.body, AstState.T_C_IF);
        this.validateStmts(node.orElse);
        return null;
    }

    @Override
    public Void visit(StmtTy.With node) {
        Validator.validateNonEmptySeq(node.items, AstState.T_F_ITEMS, AstState.T_C_WITH);
        for (WithItemTy item : node.items) {
            this.visit(item);
        }
        this.validateBody(node.body, AstState.T_C_WITH);
        return null;
    }

    @Override
    public Void visit(StmtTy.AsyncWith node) {
        Validator.validateNonEmptySeq(node.items, AstState.T_F_ITEMS, AstState.T_C_ASYNCWITH);
        for (WithItemTy item : node.items) {
            this.visit(item);
        }
        this.validateBody(node.body, AstState.T_C_ASYNCWITH);
        return null;
    }

    @Override
    public Void visit(StmtTy.Match node) {
        this.validateExpr(node.subject, ExprContextTy.Load);
        Validator.validateNonEmptySeq(node.cases, AstState.T_F_CASES, AstState.T_C_MATCH);
        for (MatchCaseTy matchCase : node.cases) {
            this.visit(matchCase);
        }
        return null;
    }

    @Override
    public Void visit(StmtTy.Raise node) {
        if (node.exc != null) {
            this.validateExpr(node.exc, ExprContextTy.Load);
            if (node.cause != null) {
                this.validateExpr(node.cause, ExprContextTy.Load);
            }
        } else if (node.cause != null) {
            throw Validator.raiseValueError(ErrorMessages.RAISE_WITH_CAUSE_BUT_NO_EXCEPTION, new Object[0]);
        }
        return null;
    }

    @Override
    public Void visit(StmtTy.Try node) {
        this.validateBody(node.body, AstState.T_C_TRY);
        if (Validator.seqLen(node.handlers) == 0 && Validator.seqLen(node.finalBody) == 0) {
            throw Validator.raiseValueError(ErrorMessages.TRY_HAS_NEITHER_EXCEPT_HANDLERS_NOR_FINALBODY, new Object[0]);
        }
        if (Validator.seqLen(node.handlers) == 0 && Validator.seqLen(node.orElse) != 0) {
            throw Validator.raiseValueError(ErrorMessages.TRY_HAS_ORELSE_BUT_NO_EXCEPT_HANDLERS, new Object[0]);
        }
        if (node.handlers != null) {
            for (ExceptHandlerTy handler : node.handlers) {
                handler.accept(this);
            }
        }
        if (Validator.seqLen(node.finalBody) != 0) {
            this.validateStmts(node.finalBody);
        }
        if (Validator.seqLen(node.orElse) != 0) {
            this.validateStmts(node.orElse);
        }
        return null;
    }

    @Override
    public Void visit(StmtTy.TryStar node) {
        this.validateBody(node.body, AstState.T_C_TRYSTAR);
        if (Validator.seqLen(node.handlers) == 0 && Validator.seqLen(node.finalBody) == 0) {
            throw Validator.raiseValueError(ErrorMessages.TRYSTAR_HAS_NEITHER_EXCEPT_HANDLERS_NOR_FINALBODY, new Object[0]);
        }
        if (Validator.seqLen(node.handlers) == 0 && Validator.seqLen(node.orElse) != 0) {
            throw Validator.raiseValueError(ErrorMessages.TRYSTAR_HAS_ORELSE_BUT_NO_EXCEPT_HANDLERS, new Object[0]);
        }
        if (node.handlers != null) {
            for (ExceptHandlerTy handler : node.handlers) {
                handler.accept(this);
            }
        }
        if (Validator.seqLen(node.finalBody) != 0) {
            this.validateStmts(node.finalBody);
        }
        if (Validator.seqLen(node.orElse) != 0) {
            this.validateStmts(node.orElse);
        }
        return null;
    }

    @Override
    public Void visit(StmtTy.Assert node) {
        this.validateExpr(node.test, ExprContextTy.Load);
        if (node.msg != null) {
            this.validateExpr(node.msg, ExprContextTy.Load);
        }
        return null;
    }

    @Override
    public Void visit(StmtTy.Import node) {
        Validator.validateNonEmptySeq(node.names, AstState.T_F_NAMES, AstState.T_C_IMPORT);
        return null;
    }

    @Override
    public Void visit(StmtTy.ImportFrom node) {
        if (node.level < 0) {
            throw Validator.raiseValueError(ErrorMessages.NEGATIVE_IMPORT_FROM_LEVEL, new Object[0]);
        }
        Validator.validateNonEmptySeq(node.names, AstState.T_F_NAMES, AstState.T_C_IMPORTFROM);
        return null;
    }

    @Override
    public Void visit(StmtTy.Global node) {
        Validator.validateNonEmptySeq(node.names, AstState.T_F_NAMES, AstState.T_C_GLOBAL);
        return null;
    }

    @Override
    public Void visit(StmtTy.Nonlocal node) {
        Validator.validateNonEmptySeq(node.names, AstState.T_F_NAMES, AstState.T_C_NONLOCAL);
        return null;
    }

    @Override
    public Void visit(StmtTy.Expr node) {
        this.validateExpr(node.value, ExprContextTy.Load);
        return null;
    }

    @Override
    public Void visit(StmtTy.AsyncFunctionDef node) {
        this.validateBody(node.body, AstState.T_C_ASYNCFUNCTIONDEF);
        this.visit(node.args);
        this.validateExprs(node.decoratorList, ExprContextTy.Load, false);
        if (node.returns != null) {
            this.validateExpr(node.returns, ExprContextTy.Load);
        }
        return null;
    }

    @Override
    public Void visit(StmtTy.Pass node) {
        return null;
    }

    @Override
    public Void visit(StmtTy.Break node) {
        return null;
    }

    @Override
    public Void visit(StmtTy.Continue node) {
        return null;
    }

    private void validateExpr(ExprTy expr, ExprContextTy context) {
        assert (context != null);
        assert (this.expectedContext == null) : "recursive validateExpr() before a call to checkContext()";
        this.expectedContext = context;
        expr.accept(this);
        assert (this.expectedContext == null) : "checkContext() not called by " + expr.getClass().getSimpleName() + " visitor";
    }

    private void checkContext(ExprContextTy actualContext) {
        assert (this.expectedContext != null) : "checkContext() called more than once";
        if (actualContext != this.expectedContext) {
            throw Validator.raiseValueError(ErrorMessages.EXPRESSION_MUST_HAVE_S_CONTEXT_BUT_HAS_S_INSTEAD, new Object[]{this.expectedContext, actualContext});
        }
        this.expectedContext = null;
    }

    private void checkContext() {
        assert (this.expectedContext != null) : "checkContext() called more than once";
        if (this.expectedContext != ExprContextTy.Load) {
            throw Validator.raiseValueError(ErrorMessages.EXPRESSION_WHICH_CANT_BE_ASSIGNED_TO_IN_S_CONTEXT, new Object[]{this.expectedContext});
        }
        this.expectedContext = null;
    }

    @Override
    public Void visit(ExprTy.BoolOp node) {
        this.checkContext();
        if (Validator.seqLen(node.values) < 2) {
            throw Validator.raiseValueError(ErrorMessages.BOOL_OP_WITH_LESS_THAN_2_VALUES, new Object[0]);
        }
        this.validateExprs(node.values, ExprContextTy.Load, false);
        return null;
    }

    @Override
    public Void visit(ExprTy.BinOp node) {
        this.checkContext();
        this.validateExpr(node.left, ExprContextTy.Load);
        this.validateExpr(node.right, ExprContextTy.Load);
        return null;
    }

    @Override
    public Void visit(ExprTy.UnaryOp node) {
        this.checkContext();
        this.validateExpr(node.operand, ExprContextTy.Load);
        return null;
    }

    @Override
    public Void visit(ExprTy.Lambda node) {
        this.checkContext();
        this.visit(node.args);
        this.validateExpr(node.body, ExprContextTy.Load);
        return null;
    }

    @Override
    public Void visit(ExprTy.IfExp node) {
        this.checkContext();
        this.validateExpr(node.test, ExprContextTy.Load);
        this.validateExpr(node.body, ExprContextTy.Load);
        this.validateExpr(node.orElse, ExprContextTy.Load);
        return null;
    }

    @Override
    public Void visit(ExprTy.Dict node) {
        this.checkContext();
        if (Validator.seqLen(node.keys) != Validator.seqLen(node.values)) {
            throw Validator.raiseValueError(ErrorMessages.DICT_DOESNT_HAVE_THE_SAME_NUMBER_OF_KEYS_AS_VALUES, new Object[0]);
        }
        this.validateExprs(node.keys, ExprContextTy.Load, true);
        this.validateExprs(node.values, ExprContextTy.Load, false);
        return null;
    }

    @Override
    public Void visit(ExprTy.Set node) {
        this.checkContext();
        this.validateExprs(node.elements, ExprContextTy.Load, false);
        return null;
    }

    @Override
    public Void visit(ExprTy.ListComp node) {
        this.checkContext();
        this.validateComprehension(node.generators);
        this.validateExpr(node.element, ExprContextTy.Load);
        return null;
    }

    @Override
    public Void visit(ExprTy.SetComp node) {
        this.checkContext();
        this.validateComprehension(node.generators);
        this.validateExpr(node.element, ExprContextTy.Load);
        return null;
    }

    @Override
    public Void visit(ExprTy.GeneratorExp node) {
        this.checkContext();
        this.validateComprehension(node.generators);
        this.validateExpr(node.element, ExprContextTy.Load);
        return null;
    }

    @Override
    public Void visit(ExprTy.DictComp node) {
        this.checkContext();
        this.validateComprehension(node.generators);
        this.validateExpr(node.key, ExprContextTy.Load);
        this.validateExpr(node.value, ExprContextTy.Load);
        return null;
    }

    @Override
    public Void visit(ExprTy.Yield node) {
        this.checkContext();
        if (node.value != null) {
            this.validateExpr(node.value, ExprContextTy.Load);
        }
        return null;
    }

    @Override
    public Void visit(ExprTy.YieldFrom node) {
        this.checkContext();
        this.validateExpr(node.value, ExprContextTy.Load);
        return null;
    }

    @Override
    public Void visit(ExprTy.Await node) {
        this.checkContext();
        this.validateExpr(node.value, ExprContextTy.Load);
        return null;
    }

    @Override
    public Void visit(ExprTy.Compare node) {
        this.checkContext();
        if (Validator.seqLen(node.comparators) == 0) {
            throw Validator.raiseValueError(ErrorMessages.COMPARE_WITH_NO_COMPARATORS, new Object[0]);
        }
        if (Validator.seqLen(node.comparators) != Validator.seqLen((Object[])node.ops)) {
            throw Validator.raiseValueError(ErrorMessages.COMPARE_HAS_A_DIFFERENT_NUMBER_OF_COMPARATORS_AND_OPERANDS, new Object[0]);
        }
        this.validateExprs(node.comparators, ExprContextTy.Load, false);
        this.validateExpr(node.left, ExprContextTy.Load);
        return null;
    }

    @Override
    public Void visit(ExprTy.Call node) {
        this.checkContext();
        this.validateExpr(node.func, ExprContextTy.Load);
        this.validateExprs(node.args, ExprContextTy.Load, false);
        this.validateKeywords(node.keywords);
        return null;
    }

    @Override
    public Void visit(ExprTy.Constant node) {
        this.checkContext();
        this.validateConstant(node.value);
        return null;
    }

    @Override
    public Void visit(ExprTy.JoinedStr node) {
        this.checkContext();
        this.validateExprs(node.values, ExprContextTy.Load, false);
        return null;
    }

    @Override
    public Void visit(ExprTy.FormattedValue node) {
        this.checkContext();
        this.validateExpr(node.value, ExprContextTy.Load);
        if (node.formatSpec != null) {
            this.validateExpr(node.formatSpec, ExprContextTy.Load);
        }
        return null;
    }

    @Override
    public Void visit(ExprTy.Attribute node) {
        this.checkContext(node.context);
        this.validateExpr(node.value, ExprContextTy.Load);
        return null;
    }

    @Override
    public Void visit(ExprTy.Subscript node) {
        this.checkContext(node.context);
        this.validateExpr(node.slice, ExprContextTy.Load);
        this.validateExpr(node.value, ExprContextTy.Load);
        return null;
    }

    @Override
    public Void visit(ExprTy.Starred node) {
        this.checkContext(node.context);
        this.validateExpr(node.value, node.context);
        return null;
    }

    @Override
    public Void visit(ExprTy.Slice node) {
        this.checkContext();
        if (node.lower != null) {
            this.validateExpr(node.lower, ExprContextTy.Load);
        }
        if (node.upper != null) {
            this.validateExpr(node.upper, ExprContextTy.Load);
        }
        if (node.step != null) {
            this.validateExpr(node.step, ExprContextTy.Load);
        }
        return null;
    }

    @Override
    public Void visit(ExprTy.List node) {
        this.checkContext(node.context);
        this.validateExprs(node.elements, node.context, false);
        return null;
    }

    @Override
    public Void visit(ExprTy.Tuple node) {
        this.checkContext(node.context);
        this.validateExprs(node.elements, node.context, false);
        return null;
    }

    @Override
    public Void visit(ExprTy.NamedExpr node) {
        this.checkContext();
        this.validateExpr(node.value, ExprContextTy.Load);
        return null;
    }

    @Override
    public Void visit(ExprTy.Name node) {
        Validator.validateName(node.id);
        this.checkContext(node.context);
        return null;
    }

    private void validatePattern(PatternTy pattern, boolean starOk) {
        boolean prevStarOk = this.isStarPatternOk;
        this.isStarPatternOk = starOk;
        pattern.accept(this);
        this.isStarPatternOk = prevStarOk;
    }

    private static boolean ensureLiteralNumber(ExprTy.Constant expr, boolean allowReal, boolean allowImaginary) {
        return allowReal && expr.value.kind == ConstantValue.Kind.DOUBLE || allowReal && expr.value.kind == ConstantValue.Kind.LONG || allowImaginary && expr.value.kind == ConstantValue.Kind.COMPLEX;
    }

    private static boolean ensureLiteralNegative(ExprTy.UnaryOp expr, boolean allowImaginary) {
        if (expr.op != UnaryOpTy.USub) {
            return false;
        }
        if (!(expr.operand instanceof ExprTy.Constant)) {
            return false;
        }
        return Validator.ensureLiteralNumber((ExprTy.Constant)expr.operand, true, allowImaginary);
    }

    private static boolean ensureLiteralComplex(ExprTy.BinOp expr) {
        if (expr.op != OperatorTy.Add && expr.op != OperatorTy.Sub) {
            return false;
        }
        if (expr.left instanceof ExprTy.Constant) {
            if (!Validator.ensureLiteralNumber((ExprTy.Constant)expr.left, true, false)) {
                return false;
            }
        } else if (expr.left instanceof ExprTy.UnaryOp) {
            if (!Validator.ensureLiteralNegative((ExprTy.UnaryOp)expr.left, false)) {
                return false;
            }
        } else {
            return false;
        }
        if (expr.right instanceof ExprTy.Constant) {
            return Validator.ensureLiteralNumber((ExprTy.Constant)expr.right, false, true);
        }
        return false;
    }

    private void validatePatternMatchValue(ExprTy expr) {
        this.validateExpr(expr, ExprContextTy.Load);
        if (expr instanceof ExprTy.Constant) {
            ExprTy.Constant constantExpr = (ExprTy.Constant)expr;
            switch (constantExpr.value.kind) {
                case LONG: 
                case DOUBLE: 
                case BYTES: 
                case COMPLEX: 
                case RAW: {
                    return;
                }
            }
            throw Validator.raiseValueError(ErrorMessages.UNEXPECTED_CONSTANT_INSIDE_OF_A_LITERAL_PATTERN, new Object[0]);
        }
        if (expr instanceof ExprTy.Attribute) {
            return;
        }
        if (expr instanceof ExprTy.UnaryOp && Validator.ensureLiteralNegative((ExprTy.UnaryOp)expr, true)) {
            return;
        }
        if (expr instanceof ExprTy.BinOp && Validator.ensureLiteralComplex((ExprTy.BinOp)expr)) {
            return;
        }
        if (expr instanceof ExprTy.JoinedStr) {
            return;
        }
        throw Validator.raiseValueError(ErrorMessages.PATTERNS_MAY_ONLY_MATCH_LITERALS_AND_ATTRIBUTE_LOOKUPS, new Object[0]);
    }

    private static void validateCapture(String name) {
        if (name.equals("_")) {
            throw Validator.raiseValueError(ErrorMessages.CANT_CAPTURE_NAME_UNDERSCORE_IN_PATTERNS, new Object[0]);
        }
        Validator.validateName(name);
    }

    @Override
    public Void visit(PatternTy.MatchValue node) {
        this.validatePatternMatchValue(node.value);
        return null;
    }

    @Override
    public Void visit(PatternTy.MatchSingleton node) {
        if (node.value.kind != ConstantValue.Kind.NONE && node.value.kind != ConstantValue.Kind.BOOLEAN) {
            throw Validator.raiseValueError(ErrorMessages.MATCH_SINGLETON_CAN_ONLY_CONTAIN_TRUE_FALSE_AND_NONE, new Object[0]);
        }
        return null;
    }

    @Override
    public Void visit(PatternTy.MatchSequence node) {
        this.validatePatterns(node.patterns, true);
        return null;
    }

    @Override
    public Void visit(PatternTy.MatchMapping node) {
        if (Validator.seqLen(node.keys) != Validator.seqLen(node.patterns)) {
            throw Validator.raiseValueError(ErrorMessages.MATCH_MAPPING_DOESNT_HAVE_THE_SAME_NUMBER_OF_KEYS_AS_PATTERNS, new Object[0]);
        }
        if (node.rest != null) {
            Validator.validateCapture(node.rest);
        }
        if (node.keys != null) {
            for (ExprTy key : node.keys) {
                if (key instanceof ExprTy.Constant) {
                    ConstantValue literal = ((ExprTy.Constant)key).value;
                    if (literal.kind == ConstantValue.Kind.NONE || literal.kind == ConstantValue.Kind.BOOLEAN) continue;
                }
                this.validatePatternMatchValue(key);
            }
        }
        this.validatePatterns(node.patterns, false);
        return null;
    }

    @Override
    public Void visit(PatternTy.MatchClass node) {
        if (Validator.seqLen(node.kwdAttrs) != Validator.seqLen(node.kwdPatterns)) {
            throw Validator.raiseValueError(ErrorMessages.MATCH_CLASS_DOESNT_HAVE_THE_SAME_NUMBER_OF_KEYWORD_ATTRIBUTES_AS_PATTERNS, new Object[0]);
        }
        this.validateExpr(node.cls, ExprContextTy.Load);
        ExprTy cls = node.cls;
        while (cls instanceof ExprTy.Attribute) {
            cls = ((ExprTy.Attribute)cls).value;
        }
        if (!(cls instanceof ExprTy.Name)) {
            throw Validator.raiseValueError(ErrorMessages.MATCH_CLASS_CLS_FIELD_CAN_ONLY_CONTAIN_NAME_OR_ATTRIBUTE_NODES, new Object[0]);
        }
        if (node.kwdAttrs != null) {
            for (String identifier : node.kwdAttrs) {
                Validator.validateName(identifier);
            }
        }
        this.validatePatterns(node.patterns, false);
        this.validatePatterns(node.kwdPatterns, false);
        return null;
    }

    @Override
    public Void visit(PatternTy.MatchStar node) {
        if (!this.isStarPatternOk) {
            throw Validator.raiseValueError(ErrorMessages.CANT_USE_MATCH_STAR_HERE, new Object[0]);
        }
        if (node.name != null) {
            Validator.validateCapture(node.name);
        }
        return null;
    }

    @Override
    public Void visit(PatternTy.MatchAs node) {
        if (node.name != null) {
            Validator.validateCapture(node.name);
        }
        if (node.pattern != null) {
            if (node.name == null) {
                throw Validator.raiseValueError(ErrorMessages.MATCH_AS_MUST_SPECIFY_A_TARGET_NAME_IF_A_PATTERN_IS_GIVEN, new Object[0]);
            }
            this.validatePattern(node.pattern, false);
        }
        return null;
    }

    @Override
    public Void visit(PatternTy.MatchOr node) {
        if (Validator.seqLen(node.patterns) < 2) {
            throw Validator.raiseValueError(ErrorMessages.MATCH_OR_REQUIRES_AT_LEAST_2_PATTERNS, new Object[0]);
        }
        this.validatePatterns(node.patterns, false);
        return null;
    }

    @Override
    public Void visit(MatchCaseTy node) {
        this.validatePattern(node.pattern, false);
        if (node.guard != null) {
            this.validateExpr(node.guard, ExprContextTy.Load);
        }
        this.validateBody(node.body, AstState.T_T_MATCH_CASE);
        return null;
    }

    @Override
    public Void visit(ComprehensionTy node) {
        this.validateExpr(node.target, ExprContextTy.Store);
        this.validateExpr(node.iter, ExprContextTy.Load);
        this.validateExprs(node.ifs, ExprContextTy.Load, false);
        return null;
    }

    @Override
    public Void visit(ExceptHandlerTy.ExceptHandler node) {
        if (node.type != null) {
            this.validateExpr(node.type, ExprContextTy.Load);
        }
        this.validateBody(node.body, AstState.T_C_EXCEPTHANDLER);
        return null;
    }

    @Override
    public Void visit(ArgumentsTy node) {
        this.validateArgs(node.posOnlyArgs);
        this.validateArgs(node.args);
        if (node.varArg != null && node.varArg.annotation != null) {
            this.validateExpr(node.varArg.annotation, ExprContextTy.Load);
        }
        this.validateArgs(node.kwOnlyArgs);
        if (node.kwArg != null && node.kwArg.annotation != null) {
            this.validateExpr(node.kwArg.annotation, ExprContextTy.Load);
        }
        if (Validator.seqLen(node.defaults) > Validator.seqLen(node.posOnlyArgs) + Validator.seqLen(node.args)) {
            throw Validator.raiseValueError(ErrorMessages.MORE_POSITIONAL_DEFAULTS_THAN_ARGS_ON_ARGUMENTS, new Object[0]);
        }
        if (Validator.seqLen(node.kwDefaults) != Validator.seqLen(node.kwOnlyArgs)) {
            throw Validator.raiseValueError(ErrorMessages.LENGTH_OF_KWONLYARGS_IS_NOT_THE_SAME_AS_KW_DEFAULTS_ON_ARGUMENTS, new Object[0]);
        }
        this.validateExprs(node.defaults, ExprContextTy.Load, false);
        this.validateExprs(node.kwDefaults, ExprContextTy.Load, true);
        return null;
    }

    @Override
    public Void visit(ArgTy node) {
        if (node.annotation != null) {
            this.validateExpr(node.annotation, ExprContextTy.Load);
        }
        return null;
    }

    @Override
    public Void visit(KeywordTy node) {
        this.validateExpr(node.value, ExprContextTy.Load);
        return null;
    }

    @Override
    public Void visit(AliasTy node) {
        return null;
    }

    @Override
    public Void visit(WithItemTy node) {
        this.validateExpr(node.contextExpr, ExprContextTy.Load);
        if (node.optionalVars != null) {
            this.validateExpr(node.optionalVars, ExprContextTy.Store);
        }
        return null;
    }

    @Override
    public Void visit(TypeIgnoreTy.TypeIgnore node) {
        return null;
    }

    private void validateStmts(StmtTy[] stmts) {
        if (stmts == null) {
            return;
        }
        for (StmtTy stmt : stmts) {
            if (stmt == null) {
                throw Validator.raiseValueError(ErrorMessages.NONE_DISALLOWED_IN_STATEMENT_LIST, new Object[0]);
            }
            this.validateStmt(stmt);
        }
    }

    private void validateExprs(ExprTy[] exprs, ExprContextTy exprContext, boolean allowNull) {
        if (exprs == null) {
            return;
        }
        for (ExprTy expr : exprs) {
            if (expr != null) {
                this.validateExpr(expr, exprContext);
                continue;
            }
            if (allowNull) continue;
            throw Validator.raiseValueError(ErrorMessages.NONE_DISALLOWED_IN_EXPRESSION_LIST, new Object[0]);
        }
    }

    private void validateArgs(ArgTy[] args) {
        if (args == null) {
            return;
        }
        for (ArgTy arg : args) {
            this.visit(arg);
        }
    }

    private void validateKeywords(KeywordTy[] keywords) {
        if (keywords == null) {
            return;
        }
        for (KeywordTy kw : keywords) {
            this.visit(kw);
        }
    }

    private void validatePatterns(PatternTy[] patterns, boolean starOk) {
        if (patterns == null) {
            return;
        }
        for (PatternTy pattern : patterns) {
            this.validatePattern(pattern, starOk);
        }
    }

    private void validateBody(StmtTy[] body, TruffleString owner) {
        Validator.validateNonEmptySeq(body, AstState.T_F_BODY, owner);
        this.validateStmts(body);
    }

    private void validateAssignList(ExprTy[] targets, ExprContextTy ctx) {
        Validator.validateNonEmptySeq(targets, AstState.T_F_TARGETS, ctx == ExprContextTy.Del ? AstState.T_C_DELETE : AstState.T_C_ASSIGN);
        this.validateExprs(targets, ctx, false);
    }

    private static void validateNonEmptySeq(Object[] seq, TruffleString what, TruffleString owner) {
        if (Validator.seqLen(seq) == 0) {
            throw Validator.raiseValueError(ErrorMessages.EMPTY_S_ON_S, what, owner);
        }
    }

    private void validateComprehension(ComprehensionTy[] generators) {
        if (Validator.seqLen(generators) == 0) {
            throw Validator.raiseValueError(ErrorMessages.COMPREHENSION_WITH_NO_GENERATORS, new Object[0]);
        }
        for (ComprehensionTy comp : generators) {
            this.visit(comp);
        }
    }

    private static int seqLen(Object[] seq) {
        return seq == null ? 0 : seq.length;
    }

    private static void validateName(String id) {
        for (String f : FORBIDDEN_NAMES) {
            if (!f.equals(id)) continue;
            throw Validator.raiseValueError(ErrorMessages.IDENTIFIER_FIELD_CANT_REPRESENT_S_CONSTANT, f);
        }
    }

    private void validateConstant(ConstantValue value) {
    }

    private static PException raiseValueError(TruffleString format, Object ... args) {
        throw PRaiseNode.getUncached().raise(PythonBuiltinClassType.ValueError, format, args);
    }

    private static PException raiseTypeError(TruffleString format, Object ... args) {
        throw PRaiseNode.getUncached().raise(PythonBuiltinClassType.TypeError, format, args);
    }
}

