/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.array.ArrayNodes;
import com.oracle.graal.python.builtins.objects.array.PArray;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.common.NativePointer;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

public final class PythonCextArrayBuiltins {

    static abstract class PyTruffle_Array_releasebuffer
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyTruffle_Array_releasebuffer() {
        }

        @Specialization
        static Object releasebuffer(PArray array, Object pyBufferPtr, @CachedLibrary(limit="1") InteropLibrary lib, @Cached CStructAccess.ReadPointerNode readPointerNode, @Cached CStructAccess.FreeNode freeNode) {
            array.getExports().decrementAndGet();
            PyTruffle_Array_releasebuffer.freeArrayField(pyBufferPtr, CFields.Py_buffer__shape, readPointerNode, lib, freeNode);
            PyTruffle_Array_releasebuffer.freeArrayField(pyBufferPtr, CFields.Py_buffer__strides, readPointerNode, lib, freeNode);
            PyTruffle_Array_releasebuffer.freeArrayField(pyBufferPtr, CFields.Py_buffer__format, readPointerNode, lib, freeNode);
            return PNone.NO_VALUE;
        }

        private static void freeArrayField(Object pyBufferPtr, CFields cfield, CStructAccess.ReadPointerNode readPointerNode, InteropLibrary lib, CStructAccess.FreeNode freeNode) {
            Object field = readPointerNode.read(pyBufferPtr, cfield);
            if (!lib.isNull(field)) {
                freeNode.free(field);
            }
        }
    }

    static abstract class PyTruffle_Array_getbuffer
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyTruffle_Array_getbuffer() {
        }

        @Specialization
        static int getbuffer(PArray array, Object pyBufferPtr, int flags, @Bind(value="this") Node inliningTarget, @Cached ArrayNodes.EnsureNativeStorageNode ensureNativeStorageNode, @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached TruffleString.CopyToByteArrayNode copyToByteArrayNode, @Cached CApiTransitions.PythonToNativeNewRefNode toNativeNewRefNode, @Cached CStructAccess.WritePointerNode writePointerNode, @Cached CStructAccess.WriteLongNode writeLongNode, @Cached CStructAccess.WriteIntNode writeIntNode, @Cached CStructAccess.WriteByteNode writeByteNode, @Cached CStructAccess.AllocateNode allocateNode) {
            Object bufPtr = ensureNativeStorageNode.execute(inliningTarget, array).getPtr();
            NativePointer nativeNull = PythonContext.get(inliningTarget).getNativeNull();
            writePointerNode.write(pyBufferPtr, CFields.Py_buffer__buf, bufPtr);
            writePointerNode.write(pyBufferPtr, CFields.Py_buffer__obj, toNativeNewRefNode.execute(array));
            writeLongNode.write(pyBufferPtr, CFields.Py_buffer__len, array.getBytesLength());
            writeIntNode.write(pyBufferPtr, CFields.Py_buffer__readonly, 0);
            writeIntNode.write(pyBufferPtr, CFields.Py_buffer__ndim, 1);
            writeLongNode.write(pyBufferPtr, CFields.Py_buffer__itemsize, array.getFormat().bytesize);
            writePointerNode.write(pyBufferPtr, CFields.Py_buffer__suboffsets, nativeNull);
            Object shapePtr = nativeNull;
            if ((flags & 8) == 8) {
                shapePtr = allocateNode.alloc(8L);
                writeLongNode.write(shapePtr, array.getLength());
            }
            writePointerNode.write(pyBufferPtr, CFields.Py_buffer__shape, shapePtr);
            Object stridesPtr = nativeNull;
            if ((flags & 0x18) == 24) {
                stridesPtr = allocateNode.alloc(8L);
                writeLongNode.write(stridesPtr, array.getFormat().bytesize);
            }
            writePointerNode.write(pyBufferPtr, CFields.Py_buffer__strides, stridesPtr);
            Object formatPtr = nativeNull;
            if ((flags & 4) == 4) {
                TruffleString format = array.getFormatString();
                TruffleString.Encoding formatEncoding = TruffleString.Encoding.US_ASCII;
                format = switchEncodingNode.execute((AbstractTruffleString)format, formatEncoding);
                int formatLen = format.byteLength(formatEncoding);
                byte[] bytes = new byte[formatLen + 1];
                copyToByteArrayNode.execute((AbstractTruffleString)format, 0, bytes, 0, formatLen, formatEncoding);
                formatPtr = allocateNode.alloc(bytes.length);
                writeByteNode.writeByteArray(formatPtr, bytes);
            }
            writePointerNode.write(pyBufferPtr, CFields.Py_buffer__format, formatPtr);
            writePointerNode.write(pyBufferPtr, CFields.Py_buffer__internal, nativeNull);
            array.getExports().incrementAndGet();
            return 0;
        }
    }

    static abstract class _PyArray_Data
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        _PyArray_Data() {
        }

        @Specialization
        static Object get(PArray array, @Bind(value="this") Node inliningTarget, @Cached ArrayNodes.EnsureNativeStorageNode ensureNativeStorageNode) {
            return ensureNativeStorageNode.execute(inliningTarget, array).getPtr();
        }
    }

    static abstract class _PyArray_Resize
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        _PyArray_Resize() {
        }

        @Specialization
        static int resize(PArray array, long newSize, @Bind(value="this") Node inliningTarget, @Cached ArrayNodes.EnsureCapacityNode ensureCapacityNode, @Cached ArrayNodes.SetLengthNode setLengthNode) {
            ensureCapacityNode.execute(inliningTarget, array, (int)newSize);
            setLengthNode.execute(inliningTarget, array, (int)newSize);
            return 0;
        }
    }
}

