/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.ctypes;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.PythonOS;
import com.oracle.graal.python.builtins.modules.BuiltinConstructors;
import com.oracle.graal.python.builtins.modules.BuiltinFunctions;
import com.oracle.graal.python.builtins.modules.ctypes.CDataTypeBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.CFieldBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.FFIType;
import com.oracle.graal.python.builtins.modules.ctypes.LazyPyCSimpleTypeBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.PyCArgObject;
import com.oracle.graal.python.builtins.modules.ctypes.PyCPointerTypeBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.PyCSimpleTypeBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictObject;
import com.oracle.graal.python.builtins.modules.ctypes.memory.Pointer;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectSetAttr;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetDictIfExistsNode;
import com.oracle.graal.python.nodes.object.SetDictNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.object.PythonObjectSlowPathFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PyCSimpleType})
public final class PyCSimpleTypeBuiltins
extends PythonBuiltins {
    private static final TruffleString T_SIMPLE_TYPE_CHARS = PythonUtils.tsLiteral("cbBhHiIlLdfuzZqQPXOv?g");
    private static final int SIMPLE_TYPE_CHARS_LENGTH = T_SIMPLE_TYPE_CHARS.codePointLengthUncached(PythonUtils.TS_ENCODING);
    protected static final TruffleString T_UPPER_Z = PythonUtils.tsLiteral("Z");
    protected static final TruffleString T_LOWER_Z = PythonUtils.tsLiteral("z");
    protected static final TruffleString T_UPPER_P = PythonUtils.tsLiteral("P");
    protected static final TruffleString T_LOWER_S = PythonUtils.tsLiteral("s");
    protected static final TruffleString T_UPPER_X = PythonUtils.tsLiteral("X");
    protected static final TruffleString T_UPPER_O = PythonUtils.tsLiteral("O");
    private static final TruffleString T__BE = PythonUtils.tsLiteral("_be");
    protected static final TruffleString T_CTYPE_BE = PythonUtils.tsLiteral("__ctype_be__");
    protected static final TruffleString T_CTYPE_LE = PythonUtils.tsLiteral("__ctype_le__");

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return PyCSimpleTypeBuiltinsFactory.getFactories();
    }

    private static Object CreateSwappedType(VirtualFrame frame, Node inliningTarget, Object type, Object[] args, PKeyword[] kwds, Object proto, FFIType.FieldDesc fmt, BuiltinConstructors.TypeNode typeNew, StringNodes.InternStringNode internStringNode, CastToTruffleStringNode toString, GetDictIfExistsNode getDict, SetDictNode setDict, HashingStorageNodes.HashingStorageAddAllToOther addAllToOther, PythonObjectFactory factory) {
        int argsLen = args.length;
        Object[] swapped_args = new Object[argsLen];
        TruffleString suffix = toString.execute(inliningTarget, internStringNode.execute(inliningTarget, T__BE));
        TruffleString name = toString.execute(inliningTarget, args[0]);
        TruffleString newname = StringUtils.cat(name, suffix);
        swapped_args[0] = newname;
        PythonUtils.arraycopy(args, 1, swapped_args, 1, argsLen - 1);
        Object result = typeNew.execute(frame, type, swapped_args[0], swapped_args[1], swapped_args[2], kwds);
        StgDictObject stgdict = factory.createStgDictObject((Object)PythonBuiltinClassType.StgDict);
        stgdict.ffi_type_pointer = fmt.pffi_type;
        stgdict.align = fmt.pffi_type.alignment;
        stgdict.length = 0;
        stgdict.size = fmt.pffi_type.size;
        stgdict.setfunc = fmt.setfunc_swapped;
        stgdict.getfunc = fmt.getfunc_swapped;
        stgdict.proto = proto;
        PDict resDict = getDict.execute(result);
        if (resDict == null) {
            resDict = factory.createDictFixedStorage((PythonObject)result);
        }
        addAllToOther.execute((Frame)frame, inliningTarget, resDict.getDictStorage(), stgdict);
        setDict.execute(inliningTarget, (PythonObject)result, stgdict);
        return result;
    }

    static TruffleString ctypesAllocFormatStringForType(char code, boolean big_endian, TruffleString.FromCharArrayUTF16Node fromCharArrayNode, TruffleString.SwitchEncodingNode switchEncodingNode) {
        char pep_code = code;
        boolean longIs32Bit = PythonOS.getPythonOS() == PythonOS.PLATFORM_WIN32;
        switch (code) {
            case 'i': {
                pep_code = 'i';
                break;
            }
            case 'I': {
                pep_code = 'I';
                break;
            }
            case 'l': {
                pep_code = longIs32Bit ? (char)'l' : 'q';
                break;
            }
            case 'L': {
                pep_code = longIs32Bit ? (char)'L' : 'Q';
                break;
            }
            case '?': {
                pep_code = '?';
            }
        }
        return switchEncodingNode.execute((AbstractTruffleString)fromCharArrayNode.execute(new char[]{big_endian ? (char)'>' : '<', pep_code}), PythonUtils.TS_ENCODING);
    }

    @Builtin(name="from_param", minNumOfPositionalArgs=2, declaresExplicitSelf=true)
    @ImportStatic(value={CDataTypeBuiltins.class})
    @GenerateNodeFactory
    protected static abstract class FromParamNode
    extends PythonBinaryBuiltinNode {
        protected FromParamNode() {
        }

        @Specialization
        static Object PyCSimpleType_from_param(VirtualFrame frame, Object type, Object value, @Bind(value="this") Node inliningTarget, @Cached CFieldBuiltins.SetFuncNode setFuncNode, @Cached BuiltinFunctions.IsInstanceNode isInstanceNode, @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached PyObjectLookupAttr lookupAsParam, @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            if (isInstanceNode.executeWith(frame, value, type)) {
                return value;
            }
            StgDictObject dict = pyTypeStgDictNode.checkAbstractClass(inliningTarget, type, raiseNode);
            TruffleString fmt = (TruffleString)dict.proto;
            assert (fmt != null);
            char code = (char)codePointAtIndexNode.execute((AbstractTruffleString)fmt, 0, PythonUtils.TS_ENCODING);
            FFIType.FieldDesc fd = FFIType._ctypes_get_fielddesc(code);
            assert (fd != null);
            PyCArgObject parg = factory.createCArgObject();
            parg.tag = code;
            parg.pffi_type = fd.pffi_type;
            parg.valuePointer = Pointer.allocate(parg.pffi_type, dict.size);
            try {
                parg.obj = setFuncNode.execute(frame, fd.setfunc, parg.valuePointer, value, 0);
                return parg;
            }
            catch (PException pException) {
                Object as_parameter = lookupAsParam.execute((Frame)frame, inliningTarget, value, CDataTypeBuiltins.T__AS_PARAMETER_);
                if (as_parameter != PNone.NO_VALUE) {
                    Object r = FromParamNode.PyCSimpleType_from_param(frame, type, as_parameter, inliningTarget, setFuncNode, isInstanceNode, pyTypeStgDictNode, lookupAsParam, codePointAtIndexNode, factory, raiseNode);
                    return r;
                }
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.WRONG_TYPE);
            }
        }
    }

    @Builtin(name="__new__", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @ImportStatic(value={PyCPointerTypeBuiltins.class})
    @GenerateNodeFactory
    protected static abstract class PyCSimpleTypeNewNode
    extends PythonBuiltinNode {
        protected PyCSimpleTypeNewNode() {
        }

        @Specialization
        static Object PyCSimpleType_new(VirtualFrame frame, Object type, Object[] args, PKeyword[] kwds, @Bind(value="this") Node inliningTarget, @Cached BuiltinConstructors.TypeNode typeNew, @Cached StringNodes.InternStringNode internStringNode, @Cached GetDictIfExistsNode getDict, @Cached SetDictNode setDict, @Cached HashingStorageNodes.HashingStorageAddAllToOther addAllToOtherNode, @Cached PyObjectLookupAttr lookupAttrType, @Cached TypeNodes.GetBaseClassNode getBaseClassNode, @Cached CastToTruffleStringNode toTruffleStringNode, @Cached PyObjectSetAttr setAttrString, @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached TruffleString.IndexOfStringNode indexOfStringNode, @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached TruffleString.EqualNode eqNode, @Cached TruffleString.FromCharArrayUTF16Node fromCharArrayNode, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            Object result = typeNew.execute(frame, type, args[0], args[1], args[2], kwds);
            Object proto = lookupAttrType.execute((Frame)frame, inliningTarget, result, PyCPointerTypeBuiltins.T__TYPE_);
            if (proto == PNone.NO_VALUE) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.AttributeError, ErrorMessages.CLASS_MUST_DEFINE_A_TYPE_ATTRIBUTE);
            }
            if (!PGuards.isString(proto)) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.CLASS_MUST_DEFINE_A_TYPE_STRING_ATTRIBUTE);
            }
            TruffleString proto_str = toTruffleStringNode.execute(inliningTarget, proto);
            int proto_len = codePointLengthNode.execute((AbstractTruffleString)proto_str, PythonUtils.TS_ENCODING);
            if (proto_len != 1) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.A_TYPE_ATTRIBUTE_WHICH_MUST_BE_A_STRING_OF_LENGTH_1);
            }
            if (indexOfStringNode.execute((AbstractTruffleString)T_SIMPLE_TYPE_CHARS, (AbstractTruffleString)proto_str, 0, SIMPLE_TYPE_CHARS_LENGTH, PythonUtils.TS_ENCODING) < 0) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.AttributeError, ErrorMessages.WHICH_MUST_BE_A_SINGLE_CHARACTER_STRING_CONTAINING_ONE_OF_S, T_SIMPLE_TYPE_CHARS);
            }
            char code = (char)codePointAtIndexNode.execute((AbstractTruffleString)proto_str, 0, PythonUtils.TS_ENCODING);
            FFIType.FieldDesc fmt = FFIType._ctypes_get_fielddesc(code);
            if (fmt == null) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.TYPE_S_NOT_SUPPORTED, proto_str);
            }
            StgDictObject stgdict = factory.createStgDictObject((Object)PythonBuiltinClassType.StgDict);
            stgdict.ffi_type_pointer = fmt.pffi_type;
            stgdict.align = fmt.pffi_type.alignment;
            stgdict.length = 0;
            stgdict.size = fmt.pffi_type.size;
            stgdict.setfunc = fmt.setfunc;
            stgdict.getfunc = fmt.getfunc;
            stgdict.format = PyCSimpleTypeBuiltins.ctypesAllocFormatStringForType(code, false, fromCharArrayNode, switchEncodingNode);
            stgdict.paramfunc = 8;
            stgdict.proto = proto_str;
            PDict resDict = getDict.execute(result);
            if (resDict == null) {
                resDict = factory.createDictFixedStorage((PythonObject)result);
            }
            addAllToOtherNode.execute((Frame)frame, inliningTarget, resDict.getDictStorage(), stgdict);
            setDict.execute(inliningTarget, (PythonObject)result, stgdict);
            PythonContext core = PythonContext.get(inliningTarget);
            PythonObjectSlowPathFactory slowPathFactory = core.factory();
            if (getBaseClassNode.execute(inliningTarget, result) == core.lookupType(PythonBuiltinClassType.SimpleCData)) {
                PythonLanguage language = PythonLanguage.get(internStringNode);
                if (eqNode.execute((AbstractTruffleString)T_LOWER_Z, (AbstractTruffleString)proto_str, PythonUtils.TS_ENCODING)) {
                    LazyPyCSimpleTypeBuiltins.addCCharPFromParam(slowPathFactory, language, result);
                    stgdict.flags |= 0x100;
                } else if (eqNode.execute((AbstractTruffleString)T_UPPER_Z, (AbstractTruffleString)proto_str, PythonUtils.TS_ENCODING)) {
                    LazyPyCSimpleTypeBuiltins.addCWCharPFromParam(slowPathFactory, language, result);
                    stgdict.flags |= 0x100;
                } else if (eqNode.execute((AbstractTruffleString)T_UPPER_P, (AbstractTruffleString)proto_str, PythonUtils.TS_ENCODING)) {
                    LazyPyCSimpleTypeBuiltins.addCVoidPFromParam(slowPathFactory, language, result);
                    stgdict.flags |= 0x100;
                } else if (eqNode.execute((AbstractTruffleString)T_LOWER_S, (AbstractTruffleString)proto_str, PythonUtils.TS_ENCODING) || eqNode.execute((AbstractTruffleString)T_UPPER_X, (AbstractTruffleString)proto_str, PythonUtils.TS_ENCODING) || eqNode.execute((AbstractTruffleString)T_UPPER_O, (AbstractTruffleString)proto_str, PythonUtils.TS_ENCODING)) {
                    stgdict.flags |= 0x100;
                }
            }
            if (type == PythonBuiltinClassType.PyCSimpleType && fmt.setfunc_swapped != FFIType.FieldSet.nil && fmt.getfunc_swapped != FFIType.FieldGet.nil) {
                Object swapped = PyCSimpleTypeBuiltins.CreateSwappedType(frame, inliningTarget, type, args, kwds, proto, fmt, typeNew, internStringNode, toTruffleStringNode, getDict, setDict, addAllToOtherNode, factory);
                StgDictObject sw_dict = pyTypeStgDictNode.execute(inliningTarget, swapped);
                setAttrString.execute((Frame)frame, inliningTarget, result, T_CTYPE_BE, swapped);
                setAttrString.execute((Frame)frame, inliningTarget, result, T_CTYPE_LE, result);
                setAttrString.execute((Frame)frame, inliningTarget, swapped, T_CTYPE_LE, result);
                setAttrString.execute((Frame)frame, inliningTarget, swapped, T_CTYPE_BE, swapped);
                sw_dict.format = switchEncodingNode.execute((AbstractTruffleString)fromCharArrayNode.execute(new char[]{'>', (char)codePointAtIndexNode.execute((AbstractTruffleString)stgdict.format, 1, PythonUtils.TS_ENCODING)}), PythonUtils.TS_ENCODING);
            }
            return result;
        }
    }
}

