/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.hpy;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.common.CExtAsPythonObjectNode;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodes;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyCAccess;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyContext;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyHandle;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyMemberAccessNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNodes;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.hpy.HPyContextSignatureType;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.DescriptorDeleteMarker;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.lib.PyFloatAsDoubleNode;
import com.oracle.graal.python.lib.PyLongAsLongNode;
import com.oracle.graal.python.lib.PyLongAsLongNodeGen;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.BuiltinFunctionRootNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.interop.PForeignToPTypeNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.IsNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

public class GraalHPyMemberAccessNodes {
    static HPyContextSignatureType getCType(int type) {
        switch (type) {
            case 0: {
                return HPyContextSignatureType.Int16_t;
            }
            case 1: {
                return HPyContextSignatureType.Int;
            }
            case 2: {
                return HPyContextSignatureType.Long;
            }
            case 3: {
                return HPyContextSignatureType.CFloat;
            }
            case 4: {
                return HPyContextSignatureType.CDouble;
            }
            case 5: {
                return HPyContextSignatureType.CharPtr;
            }
            case 6: 
            case 16: {
                return HPyContextSignatureType.HPyField;
            }
            case 7: 
            case 8: {
                return HPyContextSignatureType.Int8_t;
            }
            case 14: {
                return HPyContextSignatureType.Bool;
            }
            case 9: {
                return HPyContextSignatureType.Uint8_t;
            }
            case 10: {
                return HPyContextSignatureType.Uint16_t;
            }
            case 11: {
                return HPyContextSignatureType.UnsignedInt;
            }
            case 12: {
                return HPyContextSignatureType.UnsignedLong;
            }
            case 13: 
            case 20: {
                return null;
            }
            case 17: {
                return HPyContextSignatureType.Uint64_t;
            }
            case 18: {
                return HPyContextSignatureType.Int64_t;
            }
            case 19: {
                return HPyContextSignatureType.HPy_ssize_t;
            }
        }
        throw CompilerDirectives.shouldNotReachHere((String)"invalid member type");
    }

    static CExtAsPythonObjectNode getReadConverterNode(int type) {
        return switch (type) {
            case 0, 1, 2, 3, 4, 5, 6, 8, 9, 10, 13, 16, 19, 20 -> null;
            case 14 -> CExtCommonNodesFactory.NativePrimitiveAsPythonBooleanNodeGen.create();
            case 7 -> CExtCommonNodesFactory.NativePrimitiveAsPythonCharNodeGen.create();
            case 11, 12, 17, 18 -> CExtCommonNodesFactory.NativeUnsignedPrimitiveAsPythonObjectNodeGen.create();
            default -> throw CompilerDirectives.shouldNotReachHere((String)"invalid member type");
        };
    }

    static boolean isReadOnlyType(int type) {
        return type == 5 || type == 13;
    }

    @GenerateInline(value=false)
    static abstract class PyFloatAsDoubleCachedNode
    extends Node {
        PyFloatAsDoubleCachedNode() {
        }

        public abstract double execute(VirtualFrame var1, Object var2);

        @Specialization
        static double doGeneric(VirtualFrame frame, Object object, @Bind(value="this") Node inliningTarget, @Cached PyFloatAsDoubleNode pyFloatAsDoubleNode) {
            return pyFloatAsDoubleNode.execute(frame, inliningTarget, object);
        }
    }

    @Builtin(name="hpy_write_member", minNumOfPositionalArgs=2, parameterNames={"$self", "value"})
    protected static abstract class HPyWriteMemberNode
    extends PythonBinaryBuiltinNode {
        private static final Builtin builtin = HPyWriteMemberNode.class.getAnnotation(Builtin.class);
        @Node.Child
        private CExtCommonNodes.AsNativeCharNode asNativeCharNode;
        @Node.Child
        private PyLongAsLongNode pyLongAsLongNode;
        @Node.Child
        private PyFloatAsDoubleCachedNode pyFloatAsDoubleNode;
        @Node.Child
        private CExtCommonNodes.AsNativePrimitiveNode asNativePrimitiveNode;
        @Node.Child
        private BuiltinClassProfiles.IsBuiltinObjectExactProfile isBuiltinObjectProfile;
        @Node.Child
        private IsNode isNode;
        @Node.Child
        private GraalHPyCAccess.ReadHPyFieldNode readHPyFieldNode;
        @Node.Child
        private GraalHPyCAccess.WriteHPyFieldNode writeHPyFieldNode;
        @Node.Child
        private GraalHPyCAccess.WriteGenericNode writeGenericNode;
        @Node.Child
        private GraalHPyNodes.HPyGetNativeSpacePointerNode readNativeSpaceNode;
        private final int type;
        private final int offset;

        protected HPyWriteMemberNode(int type, int offset) {
            this.type = type;
            this.offset = offset;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Specialization
        Object doGeneric(VirtualFrame frame, Object self, Object value, @Bind(value="this") Node inliningTarget, @Cached PRaiseNode.Lazy raiseNode) {
            Object newValue;
            PythonContext context = this.getContext();
            GraalHPyContext hPyContext = context.getHPyContext();
            Object nativeSpacePtr = this.ensureReadNativeSpaceNode().executeCached(self);
            if (nativeSpacePtr == PNone.NO_VALUE) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw PRaiseNode.raiseUncached(this, PythonBuiltinClassType.SystemError, ErrorMessages.ATTEMPTING_WRITE_OFFSET_D, this.offset, self);
            }
            if (value == DescriptorDeleteMarker.INSTANCE) {
                if (this.type == 16) {
                    if (!(self instanceof PythonObject)) throw CompilerDirectives.shouldNotReachHere((String)"Cannot have HPyField on non-Python object");
                    PythonObject pythonObject = (PythonObject)self;
                    Object oldValue = this.ensureReadHPyFieldNode(hPyContext).read(hPyContext, pythonObject, nativeSpacePtr, this.offset);
                    if (oldValue == PNone.NO_VALUE) {
                        throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.AttributeError);
                    }
                } else if (this.type != 6) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.CAN_T_DELETE_NUMERIC_CHAR_ATTRIBUTE);
                }
                newValue = PNone.NO_VALUE;
            } else {
                newValue = value;
            }
            switch (this.type) {
                case 0: {
                    long val = this.ensurePyLongAsLongNode().executeCached((Frame)frame, newValue);
                    this.ensureWriteGenericNode(hPyContext).execute(hPyContext, nativeSpacePtr, (long)this.offset, HPyContextSignatureType.Int16_t, val);
                    return PNone.NONE;
                }
                case 1: {
                    long val = this.ensurePyLongAsLongNode().executeCached((Frame)frame, newValue);
                    this.ensureWriteGenericNode(hPyContext).execute(hPyContext, nativeSpacePtr, (long)this.offset, HPyContextSignatureType.Int, val);
                    return PNone.NONE;
                }
                case 2: {
                    long val = this.ensurePyLongAsLongNode().executeCached((Frame)frame, newValue);
                    this.ensureWriteGenericNode(hPyContext).execute(hPyContext, nativeSpacePtr, (long)this.offset, HPyContextSignatureType.Long, val);
                    return PNone.NONE;
                }
                case 3: {
                    float fvalue = (float)this.ensurePyFloatAsDoubleNode().execute(frame, newValue);
                    this.ensureWriteGenericNode(hPyContext).execute(hPyContext, nativeSpacePtr, (long)this.offset, HPyContextSignatureType.CFloat, Float.valueOf(fvalue));
                    return PNone.NONE;
                }
                case 4: {
                    double dvalue = this.ensurePyFloatAsDoubleNode().execute(frame, newValue);
                    this.ensureWriteGenericNode(hPyContext).execute(hPyContext, nativeSpacePtr, (long)this.offset, HPyContextSignatureType.CDouble, dvalue);
                    return PNone.NONE;
                }
                case 5: 
                case 13: {
                    throw CompilerDirectives.shouldNotReachHere();
                }
                case 6: 
                case 16: {
                    if (!(self instanceof PythonObject)) throw CompilerDirectives.shouldNotReachHere((String)"Cannot have HPyField on non-Python object");
                    PythonObject pythonObject = (PythonObject)self;
                    this.ensureWriteHPyFieldNode(hPyContext).execute(hPyContext, pythonObject, nativeSpacePtr, this.offset, newValue);
                    return PNone.NONE;
                }
                case 7: {
                    long val = this.ensureAsNativeCharNode().executeByte(newValue);
                    this.ensureWriteGenericNode(hPyContext).execute(hPyContext, nativeSpacePtr, (long)this.offset, HPyContextSignatureType.Int8_t, val);
                    return PNone.NONE;
                }
                case 8: {
                    long val = this.ensurePyLongAsLongNode().executeCached((Frame)frame, newValue);
                    this.ensureWriteGenericNode(hPyContext).execute(hPyContext, nativeSpacePtr, (long)this.offset, HPyContextSignatureType.Int8_t, val);
                    return PNone.NONE;
                }
                case 9: {
                    long val = this.ensurePyLongAsLongNode().executeCached((Frame)frame, newValue);
                    this.ensureWriteGenericNode(hPyContext).execute(hPyContext, nativeSpacePtr, (long)this.offset, HPyContextSignatureType.Uint8_t, val);
                    return PNone.NONE;
                }
                case 10: {
                    long val = this.ensurePyLongAsLongNode().executeCached((Frame)frame, newValue);
                    this.ensureWriteGenericNode(hPyContext).execute(hPyContext, nativeSpacePtr, (long)this.offset, HPyContextSignatureType.Uint16_t, val);
                    return PNone.NONE;
                }
                case 11: {
                    long val = this.ensurePyLongAsLongNode().executeCached((Frame)frame, newValue);
                    Object uint = this.ensureAsNativePrimitiveNode().execute(val, 0, hPyContext.getCTypeSize(HPyContextSignatureType.UnsignedInt), true);
                    this.ensureWriteGenericNode(hPyContext).execute(hPyContext, nativeSpacePtr, (long)this.offset, HPyContextSignatureType.UnsignedInt, uint);
                    return PNone.NONE;
                }
                case 12: {
                    long val = this.ensurePyLongAsLongNode().executeCached((Frame)frame, newValue);
                    Object ulong = this.ensureAsNativePrimitiveNode().execute(val, 0, hPyContext.getCTypeSize(HPyContextSignatureType.UnsignedLong), true);
                    this.ensureWriteGenericNode(hPyContext).execute(hPyContext, nativeSpacePtr, (long)this.offset, HPyContextSignatureType.UnsignedLong, ulong);
                    return PNone.NONE;
                }
                case 14: {
                    if (!this.ensureIsBuiltinObjectProfile().profileObject(this, newValue, PythonBuiltinClassType.Boolean)) {
                        throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.ATTR_VALUE_MUST_BE_BOOL);
                    }
                    long val = this.ensureIsNode().isTrue(newValue) ? 1L : 0L;
                    this.ensureWriteGenericNode(hPyContext).execute(hPyContext, nativeSpacePtr, (long)this.offset, HPyContextSignatureType.Bool, val);
                    return PNone.NONE;
                }
                case 17: {
                    long val = this.ensurePyLongAsLongNode().executeCached((Frame)frame, newValue);
                    this.ensureWriteGenericNode(hPyContext).execute(hPyContext, nativeSpacePtr, (long)this.offset, HPyContextSignatureType.Int64_t, val);
                    return PNone.NONE;
                }
                case 18: {
                    long val = this.ensurePyLongAsLongNode().executeCached((Frame)frame, newValue);
                    val = (Long)this.ensureAsNativePrimitiveNode().execute(val, 0, 8, true);
                    this.ensureWriteGenericNode(hPyContext).execute(hPyContext, nativeSpacePtr, (long)this.offset, HPyContextSignatureType.Int64_t, val);
                    return PNone.NONE;
                }
                case 19: {
                    long val = this.ensurePyLongAsLongNode().executeCached((Frame)frame, newValue);
                    this.ensureWriteGenericNode(hPyContext).execute(hPyContext, nativeSpacePtr, (long)this.offset, HPyContextSignatureType.HPy_ssize_t, val);
                    return PNone.NONE;
                }
                default: {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.SystemError, ErrorMessages.BAD_MEMBER_DESCR_TYPE_FOR_S, "");
                }
            }
        }

        private GraalHPyCAccess.ReadHPyFieldNode ensureReadHPyFieldNode(GraalHPyContext ctx) {
            if (this.readHPyFieldNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readHPyFieldNode = (GraalHPyCAccess.ReadHPyFieldNode)this.insert(GraalHPyCAccess.ReadHPyFieldNode.create(ctx));
            }
            return this.readHPyFieldNode;
        }

        private GraalHPyCAccess.WriteHPyFieldNode ensureWriteHPyFieldNode(GraalHPyContext ctx) {
            if (this.writeHPyFieldNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeHPyFieldNode = (GraalHPyCAccess.WriteHPyFieldNode)this.insert(GraalHPyCAccess.WriteHPyFieldNode.create(ctx));
            }
            return this.writeHPyFieldNode;
        }

        private GraalHPyCAccess.WriteGenericNode ensureWriteGenericNode(GraalHPyContext ctx) {
            if (this.writeGenericNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeGenericNode = (GraalHPyCAccess.WriteGenericNode)this.insert(GraalHPyCAccess.WriteGenericNode.create(ctx));
            }
            return this.writeGenericNode;
        }

        private GraalHPyNodes.HPyGetNativeSpacePointerNode ensureReadNativeSpaceNode() {
            if (this.readNativeSpaceNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readNativeSpaceNode = (GraalHPyNodes.HPyGetNativeSpacePointerNode)this.insert(GraalHPyNodesFactory.HPyGetNativeSpacePointerNodeGen.create());
            }
            return this.readNativeSpaceNode;
        }

        private PyLongAsLongNode ensurePyLongAsLongNode() {
            if (this.pyLongAsLongNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.pyLongAsLongNode = (PyLongAsLongNode)this.insert(PyLongAsLongNodeGen.create());
            }
            return this.pyLongAsLongNode;
        }

        private PyFloatAsDoubleCachedNode ensurePyFloatAsDoubleNode() {
            if (this.pyFloatAsDoubleNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.pyFloatAsDoubleNode = (PyFloatAsDoubleCachedNode)this.insert(GraalHPyMemberAccessNodesFactory.PyFloatAsDoubleCachedNodeGen.create());
            }
            return this.pyFloatAsDoubleNode;
        }

        private CExtCommonNodes.AsNativePrimitiveNode ensureAsNativePrimitiveNode() {
            if (this.asNativePrimitiveNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.asNativePrimitiveNode = (CExtCommonNodes.AsNativePrimitiveNode)this.insert(CExtCommonNodesFactory.AsNativePrimitiveNodeGen.create());
            }
            return this.asNativePrimitiveNode;
        }

        private BuiltinClassProfiles.IsBuiltinObjectExactProfile ensureIsBuiltinObjectProfile() {
            if (this.isBuiltinObjectProfile == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isBuiltinObjectProfile = (BuiltinClassProfiles.IsBuiltinObjectExactProfile)this.insert(BuiltinClassProfiles.IsBuiltinObjectExactProfile.create());
            }
            return this.isBuiltinObjectProfile;
        }

        private IsNode ensureIsNode() {
            if (this.isNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isNode = (IsNode)this.insert(IsNode.create());
            }
            return this.isNode;
        }

        private CExtCommonNodes.AsNativeCharNode ensureAsNativeCharNode() {
            if (this.asNativeCharNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.asNativeCharNode = (CExtCommonNodes.AsNativeCharNode)this.insert(CExtCommonNodesFactory.AsNativeCharNodeGen.create());
            }
            return this.asNativeCharNode;
        }

        @CompilerDirectives.TruffleBoundary
        public static PBuiltinFunction createBuiltinFunction(PythonLanguage language, TruffleString propertyName, int type, int offset) {
            if (GraalHPyMemberAccessNodes.isReadOnlyType(type)) {
                return HPyReadOnlyMemberNode.createBuiltinFunction(language, propertyName);
            }
            if (type == 20) {
                return HPyBadMemberDescrNode.createBuiltinFunction(language, propertyName);
            }
            RootCallTarget callTarget = language.createCachedPropAccessCallTarget(l -> new BuiltinFunctionRootNode((PythonLanguage)((Object)l), builtin, (NodeFactory<? extends PythonBuiltinBaseNode>)new PythonUtils.PrototypeNodeFactory<HPyWriteMemberNode>(GraalHPyMemberAccessNodesFactory.HPyWriteMemberNodeGen.create(type, offset)), true), HPyWriteMemberNode.class, builtin.name(), type, offset);
            int flags = PBuiltinFunction.getFlags(builtin, callTarget);
            return PythonObjectFactory.getUncached().createBuiltinFunction(propertyName, null, 0, flags, callTarget);
        }
    }

    @Builtin(name="hpy_bad_member_descr", minNumOfPositionalArgs=2, parameterNames={"$self", "value"})
    protected static abstract class HPyBadMemberDescrNode
    extends PythonBinaryBuiltinNode {
        private static final Builtin builtin = HPyBadMemberDescrNode.class.getAnnotation(Builtin.class);

        protected HPyBadMemberDescrNode() {
        }

        @Specialization
        static Object doGeneric(Object self, Object value, @Cached PRaiseNode raiseNode) {
            if (value == DescriptorDeleteMarker.INSTANCE) {
                throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.CAN_T_DELETE_NUMERIC_CHAR_ATTRIBUTE);
            }
            throw raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.BAD_MEMBER_DESCR_TYPE_FOR_P, self);
        }

        @CompilerDirectives.TruffleBoundary
        public static PBuiltinFunction createBuiltinFunction(PythonLanguage language, TruffleString propertyName) {
            RootCallTarget builtinCt = language.createCachedCallTarget(l -> new BuiltinFunctionRootNode((PythonLanguage)((Object)l), builtin, (NodeFactory<? extends PythonBuiltinBaseNode>)new PythonUtils.PrototypeNodeFactory<HPyBadMemberDescrNode>(GraalHPyMemberAccessNodesFactory.HPyBadMemberDescrNodeGen.create()), true), HPyBadMemberDescrNode.class, builtin.name());
            int flags = PBuiltinFunction.getFlags(builtin, builtinCt);
            return PythonObjectFactory.getUncached().createBuiltinFunction(propertyName, null, 0, flags, builtinCt);
        }
    }

    @Builtin(name="hpy_member_write_read_only", minNumOfPositionalArgs=1, parameterNames={"$self", "value"})
    protected static abstract class HPyReadOnlyMemberNode
    extends PythonBinaryBuiltinNode {
        private static final Builtin builtin = HPyReadOnlyMemberNode.class.getAnnotation(Builtin.class);
        private final TruffleString propertyName;

        protected HPyReadOnlyMemberNode(TruffleString propertyName) {
            this.propertyName = propertyName;
        }

        @Specialization
        Object doGeneric(Object self, Object value, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.ATTRIBUTE_S_OF_P_OBJECTS_IS_NOT_WRITABLE, this.propertyName, self);
        }

        @CompilerDirectives.TruffleBoundary
        public static PBuiltinFunction createBuiltinFunction(PythonLanguage language, TruffleString propertyName) {
            RootCallTarget builtinCt = language.createCachedCallTarget(l -> new BuiltinFunctionRootNode((PythonLanguage)((Object)l), builtin, (NodeFactory<? extends PythonBuiltinBaseNode>)new PythonUtils.PrototypeNodeFactory<HPyReadOnlyMemberNode>(GraalHPyMemberAccessNodesFactory.HPyReadOnlyMemberNodeGen.create(propertyName)), true), HPyReadOnlyMemberNode.class, builtin.name());
            int flags = PBuiltinFunction.getFlags(builtin, builtinCt);
            return PythonObjectFactory.getUncached().createBuiltinFunction(propertyName, null, 0, flags, builtinCt);
        }
    }

    @Builtin(name="hpy_member_read", minNumOfPositionalArgs=1, parameterNames={"$self"})
    protected static abstract class HPyReadMemberNode
    extends PythonUnaryBuiltinNode {
        private static final Builtin builtin = HPyReadMemberNode.class.getAnnotation(Builtin.class);
        @Node.Child
        private GraalHPyCAccess.ReadGenericNode readGenericNode;
        @Node.Child
        private GraalHPyCAccess.ReadHPyFieldNode readHPyFieldNode;
        @Node.Child
        private GraalHPyCAccess.GetElementPtrNode getElementPtrNode;
        @Node.Child
        private GraalHPyCAccess.IsNullNode isNullNode;
        @Node.Child
        private GraalHPyNodes.HPyFromCharPointerNode fromCharPointerNode;
        @Node.Child
        private CExtAsPythonObjectNode asPythonObjectNode;
        @Node.Child
        private PForeignToPTypeNode fromForeign;
        @Node.Child
        private GraalHPyNodes.HPyGetNativeSpacePointerNode readNativeSpaceNode;
        private final int type;
        private final HPyContextSignatureType fieldType;
        private final int offset;

        protected HPyReadMemberNode(int offset, int type, CExtAsPythonObjectNode asPythonObjectNode) {
            this.fieldType = GraalHPyMemberAccessNodes.getCType(type);
            this.offset = offset;
            this.type = type;
            this.asPythonObjectNode = asPythonObjectNode;
            if (asPythonObjectNode == null) {
                this.fromForeign = PForeignToPTypeNode.create();
            }
        }

        @Specialization
        Object doGeneric(VirtualFrame frame, Object self, @Bind(value="this") Node inliningTarget, @Cached PRaiseNode.Lazy raiseNode) {
            GraalHPyContext hPyContext = this.getContext().getHPyContext();
            Object nativeSpacePtr = this.ensureReadNativeSpaceNode().executeCached(self);
            if (nativeSpacePtr == PNone.NO_VALUE) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.SystemError, ErrorMessages.ATTEMPTING_READ_FROM_OFFSET_D, this.offset, self);
            }
            switch (this.type) {
                case 6: 
                case 16: {
                    if (self instanceof PythonObject) {
                        PythonObject pythonObject = (PythonObject)self;
                        Object fieldValue = this.ensureReadHPyFieldNode(hPyContext).read(hPyContext, pythonObject, nativeSpacePtr, this.offset);
                        if (fieldValue == GraalHPyHandle.NULL_HANDLE_DELEGATE) {
                            if (this.type == 6) {
                                return PNone.NONE;
                            }
                            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.AttributeError);
                        }
                        return fieldValue;
                    }
                    throw CompilerDirectives.shouldNotReachHere((String)"Cannot have HPyField on non-Python object");
                }
                case 20: {
                    return PNone.NONE;
                }
                case 5: {
                    Object nativeResult = this.ensureReadGenericNode(hPyContext).execute(hPyContext, nativeSpacePtr, this.offset, this.fieldType);
                    if (this.ensureIsNullNode(hPyContext).execute(hPyContext, nativeResult)) {
                        return PNone.NONE;
                    }
                    return this.ensureFromCharPointerNode(hPyContext).execute(hPyContext, nativeResult, false);
                }
                case 13: {
                    Object elementPtr = this.ensureGetElementPtrNode(hPyContext).execute(hPyContext, nativeSpacePtr, this.offset);
                    return this.ensureFromCharPointerNode(hPyContext).execute(hPyContext, elementPtr, false);
                }
            }
            assert (this.fieldType != null);
            Object nativeResult = this.ensureReadGenericNode(hPyContext).execute(hPyContext, nativeSpacePtr, this.offset, this.fieldType);
            if (this.asPythonObjectNode != null) {
                return this.asPythonObjectNode.execute(nativeResult);
            }
            return this.fromForeign.executeConvert(nativeResult);
        }

        private GraalHPyCAccess.ReadGenericNode ensureReadGenericNode(GraalHPyContext ctx) {
            if (this.readGenericNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readGenericNode = (GraalHPyCAccess.ReadGenericNode)this.insert(GraalHPyCAccess.ReadGenericNode.create(ctx));
            }
            return this.readGenericNode;
        }

        private GraalHPyCAccess.IsNullNode ensureIsNullNode(GraalHPyContext ctx) {
            if (this.isNullNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isNullNode = (GraalHPyCAccess.IsNullNode)this.insert(GraalHPyCAccess.IsNullNode.create(ctx));
            }
            return this.isNullNode;
        }

        private GraalHPyCAccess.ReadHPyFieldNode ensureReadHPyFieldNode(GraalHPyContext ctx) {
            if (this.readHPyFieldNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readHPyFieldNode = (GraalHPyCAccess.ReadHPyFieldNode)this.insert(GraalHPyCAccess.ReadHPyFieldNode.create(ctx));
            }
            return this.readHPyFieldNode;
        }

        private GraalHPyCAccess.GetElementPtrNode ensureGetElementPtrNode(GraalHPyContext ctx) {
            if (this.getElementPtrNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getElementPtrNode = (GraalHPyCAccess.GetElementPtrNode)this.insert(GraalHPyCAccess.GetElementPtrNode.create(ctx));
            }
            return this.getElementPtrNode;
        }

        private GraalHPyNodes.HPyFromCharPointerNode ensureFromCharPointerNode(GraalHPyContext ctx) {
            if (this.fromCharPointerNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.fromCharPointerNode = (GraalHPyNodes.HPyFromCharPointerNode)this.insert(GraalHPyNodes.HPyFromCharPointerNode.create(ctx));
            }
            return this.fromCharPointerNode;
        }

        private GraalHPyNodes.HPyGetNativeSpacePointerNode ensureReadNativeSpaceNode() {
            if (this.readNativeSpaceNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readNativeSpaceNode = (GraalHPyNodes.HPyGetNativeSpacePointerNode)this.insert(GraalHPyNodesFactory.HPyGetNativeSpacePointerNodeGen.create());
            }
            return this.readNativeSpaceNode;
        }

        @CompilerDirectives.TruffleBoundary
        public static PBuiltinFunction createBuiltinFunction(PythonLanguage language, TruffleString propertyName, int type, int offset) {
            CExtAsPythonObjectNode asPythonObjectNode = GraalHPyMemberAccessNodes.getReadConverterNode(type);
            RootCallTarget callTarget = language.createCachedPropAccessCallTarget(l -> new BuiltinFunctionRootNode((PythonLanguage)((Object)l), builtin, (NodeFactory<? extends PythonBuiltinBaseNode>)new PythonUtils.PrototypeNodeFactory<HPyReadMemberNode>(GraalHPyMemberAccessNodesFactory.HPyReadMemberNodeGen.create(offset, type, asPythonObjectNode)), true), HPyReadMemberNode.class, builtin.name(), type, offset);
            int flags = PBuiltinFunction.getFlags(builtin, callTarget);
            return PythonObjectFactory.getUncached().createBuiltinFunction(propertyName, null, 0, flags, callTarget);
        }
    }
}

