/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.function;

import com.oracle.graal.python.builtins.BoundBuiltinCallable;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodes;
import com.oracle.graal.python.builtins.objects.function.BuiltinMethodDescriptor;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.function.Signature;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlot;
import com.oracle.graal.python.nodes.PRootNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.function.BuiltinFunctionRootNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import java.lang.invoke.VarHandle;
import java.util.Arrays;

@ExportLibrary(value=InteropLibrary.class)
public final class PBuiltinFunction
extends PythonBuiltinObject
implements BoundBuiltinCallable<PBuiltinFunction> {
    private final PString name;
    private final TruffleString qualname;
    private final Object enclosingType;
    private final RootCallTarget callTarget;
    private final Signature signature;
    private final int flags;
    private final TpSlot slot;
    private final ExternalFunctionNodes.PExternalFunctionWrapper slotWrapper;
    private BuiltinMethodDescriptor descriptor;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final Object[] defaults;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final PKeyword[] kwDefaults;

    public PBuiltinFunction(PythonBuiltinClassType cls, Shape shape, TruffleString name, Object enclosingType, Object[] defaults, PKeyword[] kwDefaults, int flags, RootCallTarget callTarget, TpSlot slot, ExternalFunctionNodes.PExternalFunctionWrapper slotWrapper) {
        super((Object)cls, shape);
        this.name = PythonUtils.toPString(name);
        this.qualname = enclosingType != null ? StringUtils.cat(TypeNodes.GetNameNode.doSlowPath(enclosingType), StringLiterals.T_DOT, name) : name;
        this.enclosingType = enclosingType;
        this.callTarget = callTarget;
        this.signature = ((PRootNode)callTarget.getRootNode()).getSignature();
        this.flags = flags;
        this.defaults = defaults;
        this.kwDefaults = kwDefaults != null ? kwDefaults : PBuiltinFunction.generateKwDefaults(this.signature);
        this.slot = slot;
        this.slotWrapper = slotWrapper;
    }

    public PBuiltinFunction(PythonBuiltinClassType cls, Shape shape, TruffleString name, Object enclosingType, Object[] defaults, PKeyword[] kwDefaults, int flags, RootCallTarget callTarget) {
        this(cls, shape, name, enclosingType, defaults, kwDefaults, flags, callTarget, null, null);
    }

    private static PKeyword[] generateKwDefaults(Signature signature) {
        TruffleString[] keywordNames = signature.getKeywordNames();
        PKeyword[] kwDefaults = PKeyword.create(keywordNames.length);
        for (int i = 0; i < keywordNames.length; ++i) {
            kwDefaults[i] = new PKeyword(keywordNames[i], PNone.NO_VALUE);
        }
        return kwDefaults;
    }

    public static Object[] generateDefaults(int numDefaults) {
        if (numDefaults == 0) {
            return PythonUtils.EMPTY_OBJECT_ARRAY;
        }
        Object[] defaults = new Object[numDefaults];
        Arrays.fill(defaults, PNone.NO_VALUE);
        return defaults;
    }

    public RootNode getFunctionRootNode() {
        return this.callTarget.getRootNode();
    }

    public TpSlot getSlot() {
        return this.slot;
    }

    public ExternalFunctionNodes.PExternalFunctionWrapper getSlotWrapper() {
        return this.slotWrapper;
    }

    public NodeFactory<? extends PythonBuiltinBaseNode> getBuiltinNodeFactory() {
        RootNode functionRootNode = this.getFunctionRootNode();
        if (functionRootNode instanceof BuiltinFunctionRootNode) {
            BuiltinFunctionRootNode builtinRoot = (BuiltinFunctionRootNode)functionRootNode;
            return builtinRoot.getFactory();
        }
        return null;
    }

    public boolean isReverseOperationSlot() {
        return PBuiltinFunction.isReverseOperationSlot(this.callTarget);
    }

    public static boolean isReverseOperationSlot(RootCallTarget ct) {
        RootNode functionRootNode = ct.getRootNode();
        if (functionRootNode instanceof BuiltinFunctionRootNode) {
            return ((BuiltinFunctionRootNode)functionRootNode).getBuiltin().reverseOperation();
        }
        return false;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean isStatic() {
        return (this.flags & 0x20) != 0;
    }

    public boolean needsDeclaringType() {
        return (this.flags & 0x200) != 0;
    }

    @CompilerDirectives.TruffleBoundary
    public static int getFlags(Builtin builtin, RootCallTarget callTarget) {
        return PBuiltinFunction.getFlags(builtin, ((PRootNode)callTarget.getRootNode()).getSignature());
    }

    @CompilerDirectives.TruffleBoundary
    public static int getFlags(Builtin builtin, Signature signature) {
        if (builtin == null) {
            return 0;
        }
        int flags = 0;
        if (builtin.isClassmethod()) {
            flags |= 0x10;
        }
        if (builtin.isStaticmethod()) {
            flags |= 0x20;
        }
        if (!signature.takesKeywordArgs() && !signature.takesVarArgs()) {
            int params = signature.getParameterIds().length;
            if (params == 1) {
                return flags | 4;
            }
            if (params == 2) {
                return flags | 8;
            }
        }
        flags |= 1;
        if (signature.takesKeywordArgs()) {
            flags |= 2;
        }
        return flags;
    }

    public Class<? extends PythonBuiltinBaseNode> getNodeClass() {
        return this.getBuiltinNodeFactory() != null ? this.getBuiltinNodeFactory().getNodeClass() : null;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public RootCallTarget getCallTarget() {
        return this.callTarget;
    }

    public TruffleString getName() {
        return this.name.getMaterialized();
    }

    public PString getCApiName() {
        return this.name;
    }

    public TruffleString getQualname() {
        return this.qualname;
    }

    public Object getEnclosingType() {
        return this.enclosingType;
    }

    @Override
    public String toString() {
        CompilerAsserts.neverPartOfCompilation();
        return String.format("PBuiltinFunction %s at 0x%x", this.qualname, this.hashCode());
    }

    @Override
    public PBuiltinFunction boundToObject(PythonBuiltinClassType klass, PythonObjectFactory factory) {
        if (klass == this.enclosingType) {
            return this;
        }
        PBuiltinFunction func = factory.createBuiltinFunction(this, (Object)klass);
        func.setAttribute(SpecialAttributeNames.T___DOC__, this.getAttribute(SpecialAttributeNames.T___DOC__));
        return func;
    }

    public Object[] getDefaults() {
        return this.defaults;
    }

    public PKeyword[] getKwDefaults() {
        return this.kwDefaults;
    }

    @ExportMessage
    boolean hasExecutableName() {
        return true;
    }

    @ExportMessage
    TruffleString getExecutableName() {
        return this.getName();
    }

    public void setDescriptor(BuiltinMethodDescriptor value) {
        assert (value.getName().equals(this.getName().toJavaStringUncached()) && this.getBuiltinNodeFactory() == value.getFactory()) : String.valueOf(this.getName()) + " vs " + String.valueOf(value);
        VarHandle.storeStoreFence();
        BuiltinMethodDescriptor local = this.descriptor;
        assert (local == null || local == value) : value;
        this.descriptor = value;
    }

    public BuiltinMethodDescriptor getDescriptor() {
        return this.descriptor;
    }
}

