/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.method;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.function.AbstractFunctionBuiltins;
import com.oracle.graal.python.builtins.objects.method.AbstractBuiltinMethodBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.method.PMethod;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.attributes.GetAttributeNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PBuiltinFunctionOrMethod, PythonBuiltinClassType.MethodWrapper})
public final class AbstractBuiltinMethodBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return AbstractBuiltinMethodBuiltinsFactory.getFactories();
    }

    @Builtin(name="__qualname__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class MethodQualName
    extends PythonUnaryBuiltinNode {
        @Specialization
        static TruffleString getQualName(VirtualFrame frame, PMethod method, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached(value="create(T___NAME__)") GetAttributeNode getNameAttrNode, @Cached.Shared @Cached(value="create(T___QUALNAME__)") GetAttributeNode getQualNameAttrNode, @Cached.Shared @Cached TypeNodes.IsTypeNode isTypeNode, @Cached.Shared @Cached CastToTruffleStringNode castToStringNode, @Cached.Shared @Cached InlinedConditionProfile isGlobalProfile, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            return MethodQualName.makeQualname(frame, inliningTarget, method, method.getSelf(), getQualNameAttrNode, getNameAttrNode, castToStringNode, getClassNode, isTypeNode, isGlobalProfile, simpleTruffleStringFormatNode, raiseNode);
        }

        @Specialization
        static TruffleString getQualName(VirtualFrame frame, PBuiltinMethod method, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached(value="create(T___NAME__)") GetAttributeNode getNameAttrNode, @Cached.Shared @Cached(value="create(T___QUALNAME__)") GetAttributeNode getQualNameAttrNode, @Cached.Shared @Cached TypeNodes.IsTypeNode isTypeNode, @Cached.Shared @Cached CastToTruffleStringNode castToStringNode, @Cached.Shared @Cached InlinedConditionProfile isGlobalProfile, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            return MethodQualName.makeQualname(frame, inliningTarget, method, method.getSelf(), getQualNameAttrNode, getNameAttrNode, castToStringNode, getClassNode, isTypeNode, isGlobalProfile, simpleTruffleStringFormatNode, raiseNode);
        }

        private static TruffleString makeQualname(VirtualFrame frame, Node inliningTarget, Object method, Object self, GetAttributeNode getQualNameAttrNode, GetAttributeNode getNameAttrNode, CastToTruffleStringNode castToStringNode, GetClassNode getClassNode, TypeNodes.IsTypeNode isTypeNode, InlinedConditionProfile isGlobalProfile, StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode, PRaiseNode.Lazy raiseNode) {
            TruffleString typeQualName;
            TruffleString methodName;
            try {
                methodName = castToStringNode.execute(inliningTarget, getNameAttrNode.executeObject(frame, method));
            }
            catch (CannotCastException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.IS_NOT_A_UNICODE_OBJECT, SpecialAttributeNames.T___NAME__);
            }
            if (isGlobalProfile.profile(inliningTarget, self == PNone.NO_VALUE || self instanceof PythonModule)) {
                return methodName;
            }
            Object type = isTypeNode.execute(inliningTarget, self) ? self : getClassNode.execute(inliningTarget, self);
            try {
                typeQualName = castToStringNode.execute(inliningTarget, getQualNameAttrNode.executeObject(frame, type));
            }
            catch (CannotCastException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.IS_NOT_A_UNICODE_OBJECT, SpecialAttributeNames.T___QUALNAME__);
            }
            return simpleTruffleStringFormatNode.format("%s.%s", typeQualName, methodName);
        }
    }

    @Builtin(name="__name__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class MethodName
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object getName(VirtualFrame frame, PBuiltinMethod method, @Cached.Shared @Cached(value="create(T___NAME__)") GetAttributeNode getNameAttrNode) {
            return getNameAttrNode.executeObject(frame, method.getFunction());
        }

        @Specialization
        static Object getName(VirtualFrame frame, PMethod method, @Cached.Shared @Cached(value="create(T___NAME__)") GetAttributeNode getNameAttrNode) {
            return getNameAttrNode.executeObject(frame, method.getFunction());
        }
    }

    @Builtin(name="__text_signature__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    public static abstract class TextSignatureNode
    extends PythonBinaryBuiltinNode {
        @Node.Child
        AbstractFunctionBuiltins.TextSignatureNode subNode = AbstractFunctionBuiltins.TextSignatureNode.create();

        @Specialization
        Object getTextSignature(VirtualFrame frame, PBuiltinMethod self, Object value) {
            return this.subNode.execute(frame, self.getFunction(), value);
        }

        @Specialization
        Object getTextSignature(VirtualFrame frame, PMethod self, Object value) {
            return this.subNode.execute(frame, self.getFunction(), value);
        }
    }
}

