/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.ssl;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.PythonOS;
import com.oracle.graal.python.builtins.modules.SSLModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.bytes.PBytesLike;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.exception.OSErrorEnum;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.socket.PSocket;
import com.oracle.graal.python.builtins.objects.ssl.CertUtils;
import com.oracle.graal.python.builtins.objects.ssl.PMemoryBIO;
import com.oracle.graal.python.builtins.objects.ssl.PSSLContext;
import com.oracle.graal.python.builtins.objects.ssl.PSSLSocket;
import com.oracle.graal.python.builtins.objects.ssl.SSLCipher;
import com.oracle.graal.python.builtins.objects.ssl.SSLCipherSelector;
import com.oracle.graal.python.builtins.objects.ssl.SSLContextBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.ssl.SSLContextBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.ssl.SSLErrorCode;
import com.oracle.graal.python.builtins.objects.ssl.SSLMethod;
import com.oracle.graal.python.builtins.objects.ssl.SSLProtocol;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.lib.PyCallableCheckNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyNumberIndexNode;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.lib.PyUnicodeFSDecoderNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.attributes.GetAttributeNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonQuaternaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypes;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaLongExactNode;
import com.oracle.graal.python.nodes.util.CastToJavaStringNode;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.IPAddressUtil;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.LinkOption;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.bouncycastle.util.encoders.DecoderException;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PSSLContext})
public final class SSLContextBuiltins
extends PythonBuiltins {
    private static final TruffleString T_ENVIRON = PythonUtils.tsLiteral("environ");

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return SSLContextBuiltinsFactory.getFactories();
    }

    @CompilerDirectives.TruffleBoundary
    static SSLEngine createSSLEngine(Node raisingNode, PSSLContext context, boolean serverMode, String serverHostname) {
        SSLEngine engine;
        try {
            context.init();
        }
        catch (IOException | InvalidAlgorithmParameterException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException ex) {
            throw PConstructAndRaiseNode.raiseUncachedSSLError(SSLErrorCode.ERROR_SSL, ex);
        }
        SSLParameters parameters = new SSLParameters();
        if (serverHostname != null && !SSLContextBuiltins.isIPAddress(serverHostname)) {
            try {
                parameters.setServerNames(Collections.singletonList(new SNIHostName(serverHostname)));
            }
            catch (IllegalArgumentException e) {
                if (serverHostname.contains("\u0000")) {
                    throw PRaiseNode.raiseUncached(raisingNode, PythonBuiltinClassType.TypeError, ErrorMessages.ARG_MUST_BE_ENCODED_NON_NULL);
                }
                throw PRaiseNode.raiseUncached(raisingNode, PythonBuiltinClassType.ValueError, ErrorMessages.INVALID_HOSTNAME);
            }
            if (context.getCheckHostname()) {
                parameters.setEndpointIdentificationAlgorithm("HTTPS");
            }
            engine = context.getContext().createSSLEngine(serverHostname, -1);
        } else {
            engine = context.getContext().createSSLEngine();
        }
        engine.setUseClientMode(!serverMode);
        engine.setEnabledProtocols(context.computeEnabledProtocols());
        List<SSLCipher> enabledCiphers = context.computeEnabledCiphers(engine);
        String[] enabledCipherNames = new String[enabledCiphers.size()];
        for (int i = 0; i < enabledCiphers.size(); ++i) {
            enabledCipherNames[i] = enabledCiphers.get(i).name();
        }
        parameters.setCipherSuites(enabledCipherNames);
        if (context.getAlpnProtocols() != null) {
            parameters.setApplicationProtocols(context.getAlpnProtocols());
        }
        if (serverMode) {
            switch (context.getVerifyMode()) {
                case 0: {
                    parameters.setNeedClientAuth(false);
                    parameters.setWantClientAuth(false);
                    break;
                }
                case 1: {
                    parameters.setWantClientAuth(true);
                    break;
                }
                case 2: {
                    parameters.setNeedClientAuth(true);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        engine.setSSLParameters(parameters);
        return engine;
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean isIPAddress(String str) {
        return IPAddressUtil.isIPv4LiteralAddress(str) || IPAddressUtil.isIPv6LiteralAddress(str) || str.startsWith("[") && str.endsWith("]") && IPAddressUtil.isIPv6LiteralAddress(str.substring(1, str.length() - 1));
    }

    private static void setMinMaxVersion(Node inliningTarget, PRaiseNode.Lazy raiseNode, PSSLContext context, boolean maximum, int value) {
        if (context.getMethod().isSingleVersion()) {
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.CONTEXT_DOESNT_SUPPORT_MIN_MAX);
        }
        SSLProtocol selected = null;
        switch (value) {
            case -2: {
                selected = maximum ? SSLModuleBuiltins.getMinimumVersion() : null;
                break;
            }
            case -1: {
                selected = maximum ? null : SSLModuleBuiltins.getMaximumVersion();
                break;
            }
            default: {
                for (SSLProtocol protocol : SSLProtocol.values()) {
                    if (protocol.getId() != value) continue;
                    selected = protocol;
                    break;
                }
                if (selected != null) break;
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.UNSUPPORTED_PROTOCOL_VERSION, value);
            }
        }
        if (maximum) {
            context.setMaximumVersion(selected);
        } else {
            context.setMinimumVersion(selected);
        }
    }

    @Builtin(name="get_ca_certs", minNumOfPositionalArgs=1, parameterNames={"$self", "binary_form"})
    @ArgumentClinic(name="binary_form", conversion=ArgumentClinic.ClinicConversion.Boolean, useDefaultForNone=true, defaultValue="false")
    @GenerateNodeFactory
    static abstract class GetCACerts
    extends PythonBinaryClinicBuiltinNode {
        GetCACerts() {
        }

        @Specialization(guards={"!binary_form"})
        Object getCerts(VirtualFrame frame, PSSLContext self, boolean binary_form, @Bind(value="this") Node inliningTarget, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            try {
                List result = PythonUtils.newList();
                for (X509Certificate cert : self.getCACerts()) {
                    if (!CertUtils.isCA(cert, CertUtils.getKeyUsage(cert))) continue;
                    PythonUtils.add(result, CertUtils.decodeCertificate(this.getContext().factory(), cert));
                }
                return factory.createList(PythonUtils.toArray(result));
            }
            catch (KeyStoreException | NoSuchAlgorithmException | CertificateParsingException ex) {
                throw constructAndRaiseNode.get(inliningTarget).raiseSSLError((Frame)frame, SSLErrorCode.ERROR_SSL, ex);
            }
        }

        @Specialization(guards={"binary_form"})
        static Object getCertsBinary(PSSLContext self, boolean binary_form, @Cached.Shared @Cached PythonObjectFactory factory) {
            try {
                List result = PythonUtils.newList();
                for (X509Certificate cert : self.getCACerts()) {
                    if (!CertUtils.isCA(cert, CertUtils.getKeyUsage(cert))) continue;
                    PythonUtils.add(result, factory.createBytes(CertUtils.getEncoded(cert)));
                }
                return factory.createList(PythonUtils.toArray(result));
            }
            catch (KeyStoreException | NoSuchAlgorithmException | CertificateEncodingException ex) {
                throw PConstructAndRaiseNode.raiseUncachedSSLError(SSLErrorCode.ERROR_SSL, ex);
            }
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return SSLContextBuiltinsClinicProviders.GetCACertsClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="_set_alpn_protocols", minNumOfPositionalArgs=2, numOfPositionalOnlyArgs=2, parameterNames={"$self", "protos"})
    @ArgumentClinic(name="protos", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer)
    @GenerateNodeFactory
    static abstract class SetAlpnProtocols
    extends PythonBinaryClinicBuiltinNode {
        SetAlpnProtocols() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        static Object setFromBuffer(VirtualFrame frame, PSSLContext self, Object buffer, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @CachedLibrary(value="buffer") PythonBufferAccessLibrary bufferLib) {
            try {
                byte[] bytes = bufferLib.getInternalOrCopiedByteArray(buffer);
                int len = bufferLib.getBufferLength(buffer);
                self.setAlpnProtocols(SetAlpnProtocols.parseProtocols(bytes, len));
                PNone pNone = PNone.NONE;
                return pNone;
            }
            finally {
                bufferLib.release(buffer, frame, indirectCallData);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static String[] parseProtocols(byte[] bytes, int length) {
            byte len;
            ArrayList<String> protocols = new ArrayList<String>();
            for (int i = 0; i < length; i += len) {
                if (++i + (len = bytes[i]) > length) continue;
                protocols.add(new String(bytes, i, (int)len, StandardCharsets.US_ASCII));
            }
            return protocols.toArray(new String[0]);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return SSLContextBuiltinsClinicProviders.SetAlpnProtocolsClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="load_dh_params", minNumOfPositionalArgs=2, parameterNames={"$self", "filepath"})
    @GenerateNodeFactory
    static abstract class LoadDhParamsNode
    extends PythonBinaryBuiltinNode {
        LoadDhParamsNode() {
        }

        @Specialization
        static PNone load(VirtualFrame frame, PSSLContext self, Object pathObject, @Cached PyUnicodeFSDecoderNode asPath, @Cached PRaiseNode raiseNode) {
            TruffleString path = asPath.execute((Frame)frame, pathObject);
            throw raiseNode.raise(PythonBuiltinClassType.NotImplementedError);
        }
    }

    static abstract class GetPasswordNode
    extends PNodeWithContext {
        private static final int MAX_LEN = 1024;

        GetPasswordNode() {
        }

        public abstract char[] execute(VirtualFrame var1, Object var2);

        @Specialization(guards={"isString(password)"})
        static char[] doString(Object password, @Cached CastToJavaStringNode cast, @Cached.Shared @Cached PRaiseNode raiseNode) {
            String str = cast.execute(password);
            GetPasswordNode.checkPasswordLength(raiseNode, str.length());
            return GetPasswordNode.stringToChars(str);
        }

        @Specialization(limit="2")
        static char[] doBytes(PBytesLike bytes, @CachedLibrary(value="bytes") PythonBufferAccessLibrary bufferLib, @Cached.Shared @Cached PRaiseNode raiseNode) {
            byte[] data = bufferLib.getInternalOrCopiedByteArray(bytes);
            int length = bufferLib.getBufferLength(bytes);
            GetPasswordNode.checkPasswordLength(raiseNode, length);
            char[] res = new char[length];
            for (int i = 0; i < res.length; ++i) {
                res[i] = (char)data[i];
            }
            return res;
        }

        @Fallback
        static char[] doCallable(VirtualFrame frame, Object callable, @Bind(value="this") Node inliningTarget, @Cached PyCallableCheckNode callableCheckNode, @Cached CallNode callNode, @Cached GetPasswordNode recursive, @Cached.Shared @Cached PRaiseNode raiseNode) {
            if (callableCheckNode.execute(inliningTarget, callable)) {
                Object result = callNode.execute((Frame)frame, callable, new Object[0]);
                if (PGuards.isString(result) || result instanceof PBytesLike) {
                    return recursive.execute(frame, result);
                }
                throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.PSSWD_CALLBACK_MUST_RETURN_STR);
            }
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.PSSWD_SHOULD_BE_STR_OR_CALLABLE);
        }

        @CompilerDirectives.TruffleBoundary
        private static char[] stringToChars(String str) {
            return str.toCharArray();
        }

        private static void checkPasswordLength(PRaiseNode raiseNode, int length) {
            if (length > 1024) {
                throw raiseNode.raise(PythonBuiltinClassType.ValueError, ErrorMessages.PSSWD_CANNOT_BE_LONGER_THAN_D_BYTES, 1024);
            }
        }
    }

    @Builtin(name="load_cert_chain", minNumOfPositionalArgs=2, parameterNames={"$self", "certfile", "keyfile", "password"})
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class LoadCertChainNode
    extends PythonQuaternaryBuiltinNode {
        LoadCertChainNode() {
        }

        @Specialization
        Object load(VirtualFrame frame, PSSLContext self, Object certfile, Object keyfile, Object passwordObj, @Bind(value="this") Node inliningTarget, @Cached PyUnicodeFSDecoderNode asPath, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached GetPasswordNode getPasswordNode, @Cached TruffleString.ToJavaStringNode toJavaStringNode, @Cached TruffleString.EqualNode eqNode, @Cached PRaiseNode.Lazy raiseNode) {
            if (!PGuards.isString(certfile) && !PGuards.isBytes(certfile)) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.S_SHOULD_BE_A_VALID_FILESYSTEMPATH, "certfile");
            }
            if (!(keyfile instanceof PNone || PGuards.isString(keyfile) || PGuards.isBytes(keyfile))) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.S_SHOULD_BE_A_VALID_FILESYSTEMPATH, "keyfile");
            }
            Object kf = keyfile instanceof PNone ? certfile : keyfile;
            TruffleFile certTruffleFile = this.toTruffleFile(frame, inliningTarget, asPath.execute((Frame)frame, certfile), toJavaStringNode, eqNode, constructAndRaiseNode);
            TruffleFile keyTruffleFile = this.toTruffleFile(frame, inliningTarget, asPath.execute((Frame)frame, kf), toJavaStringNode, eqNode, constructAndRaiseNode);
            try {
                try {
                    return this.load(this.getContext(), certTruffleFile, keyTruffleFile, null, self);
                }
                catch (CertUtils.NeedsPasswordException e) {
                    if (passwordObj != PNone.NONE) {
                        char[] password = getPasswordNode.execute(frame, passwordObj);
                        try {
                            return this.load(this.getContext(), certTruffleFile, keyTruffleFile, password, self);
                        }
                        catch (CertUtils.NeedsPasswordException e1) {
                            throw CompilerDirectives.shouldNotReachHere();
                        }
                    }
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.NotImplementedError, ErrorMessages.PASSWORD_NOT_IMPLEMENTED);
                }
            }
            catch (IOException ex) {
                throw constructAndRaiseNode.get(inliningTarget).raiseSSLError((Frame)frame, SSLErrorCode.ERROR_SSL, ex);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private Object load(PythonContext context, TruffleFile certTruffleFile, TruffleFile keyTruffleFile, char[] password, PSSLContext self) throws IOException, CertUtils.NeedsPasswordException {
            try (BufferedReader certReader = this.getReader(certTruffleFile, "certfile");){
                Object object;
                block12: {
                    BufferedReader keyReader = this.getReader(keyTruffleFile, "keyfile");
                    try {
                        object = LoadCertChainNode.load(context, self, certReader, keyReader, password);
                        if (keyReader == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (keyReader != null) {
                            try {
                                keyReader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    keyReader.close();
                }
                return object;
            }
        }

        private BufferedReader getReader(TruffleFile file, String arg) throws IOException {
            try {
                SSLModuleBuiltins.LOGGER.fine(() -> String.format("load_cert_chain %s:%s", arg, file.getPath()));
                return file.newBufferedReader();
            }
            catch (CannotCastException e) {
                throw PRaiseNode.raiseUncached(this, PythonBuiltinClassType.TypeError, ErrorMessages.S_SHOULD_BE_A_VALID_FILESYSTEMPATH, arg);
            }
        }

        private static Object load(PythonContext context, PSSLContext self, BufferedReader certReader, BufferedReader keyReader, char[] password) throws CertUtils.NeedsPasswordException {
            try {
                X509Certificate[] certs;
                try {
                    List<Object> certificates = CertUtils.getCertificates(certReader, true);
                    certs = certificates.toArray(new X509Certificate[certificates.size()]);
                    if (certs.length == 0) {
                        throw PConstructAndRaiseNode.raiseUncachedSSLError(SSLErrorCode.ERROR_SSL_PEM_LIB, ErrorMessages.SSL_PEM_LIB, new Object[0]);
                    }
                }
                catch (IOException | DecoderException e) {
                    throw PConstructAndRaiseNode.raiseUncachedSSLError(SSLErrorCode.ERROR_SSL_PEM_LIB, ErrorMessages.SSL_PEM_LIB, new Object[0]);
                }
                PrivateKey pk = CertUtils.getPrivateKey(context, keyReader, password, certs[0]);
                self.setCertChain(pk, PythonUtils.EMPTY_CHAR_ARRAY, certs);
                return PNone.NONE;
            }
            catch (IOException | GeneralSecurityException ex) {
                throw PConstructAndRaiseNode.raiseUncachedSSLError(SSLErrorCode.ERROR_SSL, ex);
            }
        }

        private TruffleFile toTruffleFile(VirtualFrame frame, Node inliningTarget, TruffleString path, TruffleString.ToJavaStringNode toJavaStringNode, TruffleString.EqualNode eqNode, PConstructAndRaiseNode.Lazy constructAndRaiseNode) throws PException {
            try {
                TruffleFile file = this.getContext().getEnv().getPublicTruffleFile(toJavaStringNode.execute((AbstractTruffleString)path));
                if (!file.exists(new LinkOption[0])) {
                    throw constructAndRaiseNode.get(inliningTarget).raiseOSError((Frame)frame, OSErrorEnum.ENOENT);
                }
                return file;
            }
            catch (Exception e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSError((Frame)frame, e, eqNode);
            }
        }
    }

    @Builtin(name="load_verify_locations", minNumOfPositionalArgs=1, parameterNames={"$self", "cafile", "capath", "cadata"})
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class LoadVerifyLocationsNode
    extends PythonQuaternaryBuiltinNode {
        LoadVerifyLocationsNode() {
        }

        @Specialization
        Object load(VirtualFrame frame, PSSLContext self, Object cafile, Object capath, Object cadata, @Bind(value="this") Node inliningTarget, @Cached PyUnicodeFSDecoderNode asPath, @Cached CastToJavaStringNode castToString, @Cached SequenceStorageNodes.ToByteArrayNode toBytes, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached TruffleString.ToJavaStringNode toJavaStringNode, @Cached TruffleString.EqualNode eqNode, @Cached PRaiseNode.Lazy raiseNode) {
            block15: {
                TruffleFile file;
                if (cafile instanceof PNone && capath instanceof PNone && cadata instanceof PNone) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.CA_FILE_PATH_DATA_CANNOT_BE_ALL_OMMITED);
                }
                if (!(cafile instanceof PNone || PGuards.isString(cafile) || PGuards.isBytes(cafile))) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.S_SHOULD_BE_A_VALID_FILESYSTEMPATH, "cafile");
                }
                if (!(capath instanceof PNone || PGuards.isString(capath) || PGuards.isBytes(capath))) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.S_SHOULD_BE_A_VALID_FILESYSTEMPATH, "capath");
                }
                if (!(cafile instanceof PNone)) {
                    file = this.toTruffleFile(frame, inliningTarget, asPath, cafile, toJavaStringNode, eqNode, constructAndRaiseNode);
                    if (!file.exists(new LinkOption[0])) {
                        throw constructAndRaiseNode.get(inliningTarget).raiseOSError((Frame)frame, OSErrorEnum.ENOENT);
                    }
                } else {
                    file = null;
                }
                TruffleFile path = !(capath instanceof PNone) ? this.toTruffleFile(frame, inliningTarget, asPath, capath, toJavaStringNode, eqNode, constructAndRaiseNode) : null;
                try {
                    if (!(cadata instanceof PNone)) {
                        Collection<Object> certificates;
                        try {
                            certificates = LoadVerifyLocationsNode.fromString(inliningTarget, castToString.execute(cadata), raiseNode);
                        }
                        catch (CannotCastException cannotCastException) {
                            if (cadata instanceof PBytesLike) {
                                certificates = LoadVerifyLocationsNode.fromBytesLike(toBytes.execute(inliningTarget, ((PBytesLike)cadata).getSequenceStorage()));
                            }
                            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.S_SHOULD_BE_ASCII_OR_BYTELIKE, "cadata");
                        }
                        self.setCAEntries(certificates);
                    }
                    if (file == null && path == null) break block15;
                    SSLModuleBuiltins.LOGGER.fine(() -> String.format("LoadVerifyLocationsNode cafile: %s, capath: %s", file != null ? file.getPath() : "None", path != null ? path.getPath() : "None"));
                    try {
                        self.setCAEntries(CertUtils.loadVerifyLocations(file, path));
                    }
                    catch (CertUtils.NoCertificateFoundException e) {
                        throw constructAndRaiseNode.get(inliningTarget).raiseSSLError((Frame)frame, SSLErrorCode.ERROR_NO_CERTIFICATE_OR_CRL_FOUND, ErrorMessages.NO_CERTIFICATE_OR_CRL_FOUND, new Object[0]);
                    }
                    catch (IOException | DecoderException e) {
                        throw constructAndRaiseNode.get(inliningTarget).raiseSSLError((Frame)frame, SSLErrorCode.ERROR_SSL_PEM_LIB, ErrorMessages.X509_PEM_LIB, new Object[0]);
                    }
                }
                catch (IOException | GeneralSecurityException ex) {
                    throw constructAndRaiseNode.get(inliningTarget).raiseSSLError((Frame)frame, SSLErrorCode.ERROR_SSL, ex);
                }
            }
            return PNone.NONE;
        }

        private TruffleFile toTruffleFile(VirtualFrame frame, Node inliningTarget, PyUnicodeFSDecoderNode asPath, Object fileObject, TruffleString.ToJavaStringNode toJavaStringNode, TruffleString.EqualNode eqNode, PConstructAndRaiseNode.Lazy constructAndRaiseNode) throws PException {
            try {
                return this.getContext().getEnv().getPublicTruffleFile(toJavaStringNode.execute((AbstractTruffleString)asPath.execute((Frame)frame, fileObject)));
            }
            catch (Exception e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSError((Frame)frame, e, eqNode);
            }
        }

        private static List<Object> fromString(Node inliningTarget, String dataString, PRaiseNode.Lazy raiseNode) throws IOException, CertificateException, CRLException {
            if (dataString.isEmpty()) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.EMPTY_CERTIFICATE_DATA);
            }
            return LoadVerifyLocationsNode.getCertificates(dataString);
        }

        @CompilerDirectives.TruffleBoundary
        private static List<Object> getCertificates(String dataString) throws PException, CRLException, IOException, CertificateException {
            BufferedReader r = new BufferedReader(new StringReader(dataString));
            try {
                List<Object> certificates = CertUtils.getCertificates(r);
                if (certificates.isEmpty()) {
                    throw PConstructAndRaiseNode.raiseUncachedSSLError(SSLErrorCode.ERROR_NO_START_LINE, ErrorMessages.SSL_PEM_NO_START_LINE, new Object[0]);
                }
                List<Object> list = certificates;
                return list;
            }
            catch (DecoderException e) {
                throw PConstructAndRaiseNode.raiseUncachedSSLError(SSLErrorCode.ERROR_BAD_BASE64_DECODE, ErrorMessages.BAD_BASE64_DECODE, new Object[0]);
            }
            catch (IOException e) {
                throw PConstructAndRaiseNode.raiseUncachedSSLError(SSLErrorCode.ERROR_SSL_PEM_LIB, ErrorMessages.SSL_PEM_LIB, new Object[0]);
            }
            finally {
                try {
                    r.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static Collection<?> fromBytesLike(byte[] bytes) {
            try {
                return CertUtils.generateCertificates(bytes);
            }
            catch (CertificateException ex) {
                String msg = ex.getMessage();
                if (msg != null) {
                    if (msg.contains("No certificate data found")) {
                        throw PConstructAndRaiseNode.raiseUncachedSSLError(SSLErrorCode.ERROR_NOT_ENOUGH_DATA, ErrorMessages.NOT_ENOUGH_DATA, new Object[0]);
                    }
                } else {
                    msg = "error while reading cadata";
                }
                throw PConstructAndRaiseNode.raiseUncachedSSLError(null, new Object[]{SSLErrorCode.ERROR_SSL, PythonUtils.toTruffleStringUncached(msg)});
            }
        }
    }

    @Builtin(name="cert_store_stats", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class CertStoreStatsNode
    extends PythonUnaryBuiltinNode {
        public static final TruffleString T_X509 = PythonUtils.tsLiteral("x509");
        public static final TruffleString T_CRL = PythonUtils.tsLiteral("crl");
        public static final TruffleString T_X509_CA = PythonUtils.tsLiteral("x509_ca");

        CertStoreStatsNode() {
        }

        @Specialization
        static Object storeStats(VirtualFrame frame, PSSLContext self, @Bind(value="this") Node inliningTarget, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PythonObjectFactory factory) {
            try {
                int x509 = 0;
                int crl = 0;
                int ca = 0;
                for (X509Certificate cert : self.getCACerts()) {
                    boolean[] keyUsage = CertUtils.getKeyUsage(cert);
                    if (CertUtils.isCrl(keyUsage)) {
                        ++crl;
                        continue;
                    }
                    ++x509;
                    if (!CertUtils.isCA(cert, keyUsage)) continue;
                    ++ca;
                }
                return factory.createDict(new PKeyword[]{new PKeyword(T_X509, x509), new PKeyword(T_CRL, crl), new PKeyword(T_X509_CA, ca)});
            }
            catch (Exception ex) {
                throw constructAndRaiseNode.get(inliningTarget).raiseSSLError((Frame)frame, SSLErrorCode.ERROR_SSL, ex);
            }
        }
    }

    @Builtin(name="set_default_verify_paths", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class SetDefaultVerifyPathsNode
    extends PythonUnaryBuiltinNode {
        SetDefaultVerifyPathsNode() {
        }

        @Specialization
        Object set(VirtualFrame frame, PSSLContext self, @Bind(value="this") Node inliningTarget, @Cached PyUnicodeFSDecoderNode asPath, @Cached(value="createEnvironLookup()") GetAttributeNode getAttribute, @Cached HashingStorageNodes.HashingStorageGetItem getItem, @Cached(value="createCertFileKey()") PBytes certFileKey, @Cached(value="createCertDirKey()") PBytes certDirKey, @Cached TruffleString.ToJavaStringNode toJavaStringNode) {
            PythonModule posix = PythonOS.getPythonOS() == PythonOS.PLATFORM_WIN32 ? this.getContext().lookupBuiltinModule(BuiltinNames.T_NT) : this.getContext().lookupBuiltinModule(BuiltinNames.T_POSIX);
            PDict environ = (PDict)getAttribute.executeObject(frame, posix);
            HashingStorage storage = environ.getDictStorage();
            TruffleFile file = this.toTruffleFile(frame, asPath, getItem.execute((Frame)frame, inliningTarget, storage, certFileKey), toJavaStringNode);
            TruffleFile path = this.toTruffleFile(frame, asPath, getItem.execute((Frame)frame, inliningTarget, storage, certDirKey), toJavaStringNode);
            if (file != null || path != null) {
                SSLModuleBuiltins.LOGGER.fine(() -> String.format("set_default_verify_paths file: %s. path: %s", file != null ? file.getPath() : "None", path != null ? path.getPath() : "None"));
                try {
                    self.setCAEntries(CertUtils.loadVerifyLocations(file, path));
                }
                catch (CertUtils.NoCertificateFoundException | IOException | GeneralSecurityException | DecoderException ex) {
                    SSLModuleBuiltins.LOGGER.log(Level.FINER, "", ex);
                }
            } else {
                self.setUseDefaultTrustStore(true);
            }
            return PNone.NONE;
        }

        @CompilerDirectives.TruffleBoundary
        @NeverDefault
        protected PBytes createCertFileKey() {
            return PythonObjectFactory.getUncached().createBytes("SSL_CERT_FILE".getBytes());
        }

        @CompilerDirectives.TruffleBoundary
        @NeverDefault
        protected PBytes createCertDirKey() {
            return PythonObjectFactory.getUncached().createBytes("SSL_CERT_DIR".getBytes());
        }

        @NeverDefault
        protected static GetAttributeNode createEnvironLookup() {
            return GetAttributeNode.create(T_ENVIRON);
        }

        private TruffleFile toTruffleFile(VirtualFrame frame, PyUnicodeFSDecoderNode asPath, Object path, TruffleString.ToJavaStringNode toJavaStringNode) throws PException {
            if (path == null) {
                return null;
            }
            try {
                TruffleFile file = this.getContext().getEnv().getPublicTruffleFile(toJavaStringNode.execute((AbstractTruffleString)asPath.execute((Frame)frame, path)));
                if (!file.exists(new LinkOption[0])) {
                    return null;
                }
                return file;
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    @Builtin(name="post_handshake_auth", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class PostHandshakeAuthNode
    extends PythonUnaryBuiltinNode {
        PostHandshakeAuthNode() {
        }

        @Specialization
        static Object pha(PSSLContext self) {
            return PNone.NONE;
        }
    }

    @Builtin(name="sni_callback", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    static abstract class SNICallbackNode
    extends PythonBinaryBuiltinNode {
        SNICallbackNode() {
        }

        @Specialization
        static Object notImplemented(PSSLContext self, Object value, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.NotImplementedError);
        }
    }

    @Builtin(name="num_tickets", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class NumTicketsNode
    extends PythonBinaryBuiltinNode {
        NumTicketsNode() {
        }

        @Specialization(guards={"isNoValue(value)"})
        static int get(PSSLContext self, PNone value, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.NotImplementedError);
        }

        @Specialization(guards={"!isNoValue(value)"})
        static Object set(VirtualFrame frame, PSSLContext self, Object value, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.NotImplementedError);
        }
    }

    @Builtin(name="set_ciphers", minNumOfPositionalArgs=2, parameterNames={"$self", "cipherlist"})
    @ArgumentClinic(name="cipherlist", conversion=ArgumentClinic.ClinicConversion.TString)
    @GenerateNodeFactory
    static abstract class SetCiphersNode
    extends PythonClinicBuiltinNode {
        SetCiphersNode() {
        }

        @Specialization
        Object setCiphers(PSSLContext self, TruffleString cipherlist, @Cached TruffleString.ToJavaStringNode toJavaStringNode) {
            self.setCiphers(SSLCipherSelector.selectCiphers(this, toJavaStringNode.execute((AbstractTruffleString)cipherlist)));
            return PNone.NONE;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return SSLContextBuiltinsClinicProviders.SetCiphersNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="get_ciphers", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class GetCiphersNode
    extends PythonUnaryBuiltinNode {
        GetCiphersNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static PList getCiphers(PSSLContext self) {
            List<SSLCipher> ciphers = self.computeEnabledCiphers(self.getContext().createSSLEngine());
            Object[] dicts = new Object[ciphers.size()];
            for (int i = 0; i < dicts.length; ++i) {
                dicts[i] = PythonObjectFactory.getUncached().createDict(ciphers.get(i).asKeywords());
            }
            return PythonObjectFactory.getUncached().createList(dicts);
        }
    }

    @Builtin(name="maximum_version", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    static abstract class MaximumVersionNode
    extends PythonBinaryBuiltinNode {
        MaximumVersionNode() {
        }

        @Specialization(guards={"isNoValue(none)"})
        static int get(PSSLContext self, Object none) {
            return self.getMaximumVersion() != null ? self.getMaximumVersion().getId() : -1;
        }

        @Specialization(guards={"!isNoValue(obj)"})
        static Object set(VirtualFrame frame, PSSLContext self, Object obj, @Bind(value="this") Node inliningTarget, @Cached PyNumberAsSizeNode asSizeNode, @Cached PRaiseNode.Lazy raiseNode) {
            SSLContextBuiltins.setMinMaxVersion(inliningTarget, raiseNode, self, true, asSizeNode.executeExact((Frame)frame, inliningTarget, obj));
            return PNone.NONE;
        }
    }

    @Builtin(name="minimum_version", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    static abstract class MinimumVersionNode
    extends PythonBinaryBuiltinNode {
        MinimumVersionNode() {
        }

        @Specialization(guards={"isNoValue(none)"})
        static int get(PSSLContext self, Object none) {
            return self.getMinimumVersion() != null ? self.getMinimumVersion().getId() : -2;
        }

        @Specialization(guards={"!isNoValue(obj)"})
        static Object set(VirtualFrame frame, PSSLContext self, Object obj, @Bind(value="this") Node inliningTarget, @Cached PyNumberAsSizeNode asSizeNode, @Cached PRaiseNode.Lazy raiseNode) {
            SSLContextBuiltins.setMinMaxVersion(inliningTarget, raiseNode, self, false, asSizeNode.executeExact((Frame)frame, inliningTarget, obj));
            return PNone.NONE;
        }
    }

    @Builtin(name="verify_mode", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    static abstract class VerifyModeNode
    extends PythonBinaryBuiltinNode {
        VerifyModeNode() {
        }

        @Specialization(guards={"isNoValue(value)"})
        static int get(PSSLContext self, PNone value) {
            return self.getVerifyMode();
        }

        @Specialization(guards={"!isNoValue(value)"})
        static Object set(VirtualFrame frame, PSSLContext self, Object value, @Bind(value="this") Node inliningTarget, @Cached PyNumberAsSizeNode asSizeNode, @Cached PRaiseNode.Lazy raiseNode) {
            int mode = asSizeNode.executeLossy((Frame)frame, inliningTarget, value);
            if (mode == 0 && self.getCheckHostname()) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.CANNOT_SET_VERIFY_MODE_TO_CERT_NONE);
            }
            switch (mode) {
                case 0: 
                case 1: 
                case 2: {
                    self.setVerifyMode(mode);
                    return PNone.NONE;
                }
            }
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.INVALID_VALUE_FOR_VERIFY_MODE);
        }
    }

    @Builtin(name="options", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    static abstract class OptionsNode
    extends PythonBinaryBuiltinNode {
        OptionsNode() {
        }

        @Specialization(guards={"isNoValue(none)"})
        static long getOptions(PSSLContext self, PNone none) {
            return self.getOptions();
        }

        @Specialization(guards={"!isNoValue(valueObj)"})
        static Object setOption(VirtualFrame frame, PSSLContext self, Object valueObj, @Bind(value="this") Node inliningTarget, @Cached PyNumberIndexNode indexNode, @Cached CastToJavaLongExactNode cast) {
            long value = cast.execute(inliningTarget, indexNode.execute((Frame)frame, inliningTarget, valueObj));
            self.setOptions(value);
            return PNone.NONE;
        }
    }

    @Builtin(name="protocol", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class ProtocolNode
    extends PythonUnaryBuiltinNode {
        ProtocolNode() {
        }

        @Specialization
        static int getProtocol(PSSLContext self) {
            return self.getMethod().getPythonId();
        }
    }

    @Builtin(name="verify_flags", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    static abstract class VerifyFlagsNode
    extends PythonBinaryBuiltinNode {
        VerifyFlagsNode() {
        }

        @Specialization(guards={"isNoValue(none)"})
        static long getVerifyFlags(PSSLContext self, PNone none) {
            return self.getVerifyFlags();
        }

        @Specialization(guards={"!isNoValue(flags)"})
        static Object setVerifyFlags(VirtualFrame frame, PSSLContext self, Object flags, @Bind(value="this") Node inliningTarget, @Cached PyNumberAsSizeNode asSizeNode) {
            self.setVerifyFlags(asSizeNode.executeLossy((Frame)frame, inliningTarget, flags));
            return PNone.NONE;
        }
    }

    @Builtin(name="check_hostname", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    static abstract class CheckHostnameNode
    extends PythonBinaryBuiltinNode {
        CheckHostnameNode() {
        }

        @Specialization(guards={"isNoValue(none)"})
        static boolean getCheckHostname(PSSLContext self, PNone none) {
            return self.getCheckHostname();
        }

        @Specialization(guards={"!isNoValue(value)"})
        static Object setCheckHostname(VirtualFrame frame, PSSLContext self, Object value, @Bind(value="this") Node inliningTarget, @Cached PyObjectIsTrueNode isTrueNode) {
            boolean checkHostname = isTrueNode.execute((Frame)frame, inliningTarget, value);
            if (checkHostname && self.getVerifyMode() == 0) {
                self.setVerifyMode(2);
            }
            self.setCheckHostname(checkHostname);
            return PNone.NONE;
        }
    }

    @Builtin(name="_wrap_bio", minNumOfPositionalArgs=4, parameterNames={"$self", "incoming", "outgoing", "server_side", "server_hostname"}, keywordOnlyNames={"owner", "session"})
    @ArgumentClinic(name="server_side", conversion=ArgumentClinic.ClinicConversion.Boolean)
    @GenerateNodeFactory
    static abstract class WrapBIONode
    extends PythonClinicBuiltinNode {
        WrapBIONode() {
        }

        @Specialization
        static Object wrap(PSSLContext context, PMemoryBIO incoming, PMemoryBIO outgoing, boolean serverSide, Object serverHostnameObj, Object owner, PNone session, @Bind(value="this") Node inliningTarget, @Cached StringNodes.CastToTruffleStringCheckedNode cast, @Cached TruffleString.ToJavaStringNode toJavaStringNode, @Cached PythonObjectFactory factory) {
            TruffleString serverHostname = null;
            if (!(serverHostnameObj instanceof PNone)) {
                serverHostname = cast.cast(inliningTarget, serverHostnameObj, ErrorMessages.S_MUST_BE_NONE_OR_STRING, "serverHostname", serverHostnameObj);
            }
            SSLEngine engine = SSLContextBuiltins.createSSLEngine(inliningTarget, context, serverSide, serverHostname == null ? null : toJavaStringNode.execute(serverHostname));
            PSSLSocket sslSocket = factory.createSSLSocket((Object)PythonBuiltinClassType.PSSLSocket, context, engine, incoming, outgoing);
            if (!(owner instanceof PNone)) {
                sslSocket.setOwner(owner);
            }
            sslSocket.setServerHostname(serverHostname);
            return sslSocket;
        }

        @Fallback
        static Object wrap(Object context, Object incoming, Object outgoing, Object serverSide, Object serverHostname, Object owner, Object session, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.INVALID_WRAP_BIO_CALL);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return SSLContextBuiltinsClinicProviders.WrapBIONodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="_wrap_socket", minNumOfPositionalArgs=3, parameterNames={"$self", "sock", "server_side", "server_hostname"}, keywordOnlyNames={"owner", "session"})
    @ArgumentClinic(name="server_side", conversion=ArgumentClinic.ClinicConversion.Boolean)
    @GenerateNodeFactory
    static abstract class WrapSocketNode
    extends PythonClinicBuiltinNode {
        WrapSocketNode() {
        }

        @Specialization
        static Object wrap(PSSLContext context, PSocket sock, boolean serverSide, Object serverHostnameObj, Object owner, PNone session, @Bind(value="this") Node inliningTarget, @Cached StringNodes.CastToTruffleStringCheckedNode cast, @Cached TruffleString.ToJavaStringNode toJavaStringNode, @Cached PythonObjectFactory factory) {
            TruffleString serverHostname = null;
            if (!(serverHostnameObj instanceof PNone)) {
                serverHostname = cast.cast(inliningTarget, serverHostnameObj, ErrorMessages.S_MUST_BE_NONE_OR_STRING, "serverHostname", serverHostnameObj);
            }
            SSLEngine engine = SSLContextBuiltins.createSSLEngine(inliningTarget, context, serverSide, serverHostname == null ? null : toJavaStringNode.execute(serverHostname));
            PSSLSocket sslSocket = factory.createSSLSocket((Object)PythonBuiltinClassType.PSSLSocket, context, engine, sock);
            if (!(owner instanceof PNone)) {
                sslSocket.setOwner(owner);
            }
            sslSocket.setServerHostname(serverHostname);
            return sslSocket;
        }

        @Fallback
        static Object wrap(Object context, Object sock, Object serverSide, Object serverHostname, Object owner, Object session, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.INVALID_WRAP_SOCKET_CALL);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return SSLContextBuiltinsClinicProviders.WrapSocketNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="_SSLContext", constructsClass=PythonBuiltinClassType.PSSLContext, minNumOfPositionalArgs=2, parameterNames={"type", "protocol"})
    @ArgumentClinic(name="protocol", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class SSLContextNode
    extends PythonBinaryClinicBuiltinNode {
        SSLContextNode() {
        }

        @Specialization
        static PSSLContext createContext(VirtualFrame frame, Object type, int protocol, @Bind(value="this") Node inliningTarget, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            SSLMethod method = SSLMethod.fromPythonId(protocol);
            if (method == null) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.INVALID_OR_UNSUPPORTED_PROTOCOL_VERSION, "NULL");
            }
            try {
                int verifyMode;
                boolean checkHostname;
                if (method == SSLMethod.TLS_CLIENT) {
                    checkHostname = true;
                    verifyMode = 2;
                } else {
                    checkHostname = false;
                    verifyMode = 0;
                }
                PSSLContext context = factory.createSSLContext(type, method, 32768, checkHostname, verifyMode, SSLContextNode.createSSLContext());
                long options = 131072L;
                if (method != SSLMethod.SSL3) {
                    options |= 0x2000000L;
                }
                context.setOptions(options);
                return context;
            }
            catch (NoSuchAlgorithmException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.INVALID_OR_UNSUPPORTED_PROTOCOL_VERSION, e);
            }
            catch (KeyManagementException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseSSLError((Frame)frame, SSLErrorCode.ERROR_SSL, e);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static SSLContext createSSLContext() throws NoSuchAlgorithmException, KeyManagementException {
            SSLContext context = SSLContext.getInstance("TLS");
            context.getClientSessionContext().setSessionCacheSize(0);
            context.init(null, null, null);
            return context;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return SSLContextBuiltinsClinicProviders.SSLContextNodeClinicProviderGen.INSTANCE;
        }
    }
}

