/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.bytecode;

import com.oracle.graal.python.compiler.CodeUnit;
import com.oracle.graal.python.nodes.bytecode.PBytecodeRootNode;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.strings.TruffleString;

public final class FrameInfo {
    @CompilerDirectives.CompilationFinal
    PBytecodeRootNode rootNode;

    public PBytecodeRootNode getRootNode() {
        return this.rootNode;
    }

    public int getBci(Frame frame) {
        if (frame.isInt(this.rootNode.bcioffset)) {
            return frame.getInt(this.rootNode.bcioffset);
        }
        return -1;
    }

    public Object getYieldFrom(Frame generatorFrame, int bci, int stackTop) {
        if (bci > 3 && bci < this.rootNode.bytecode.length && this.rootNode.bytecode[bci - 3] == 100 && this.rootNode.bytecode[bci - 1] == 97 && this.rootNode.bytecode[bci] == 99) {
            return generatorFrame.getObject(stackTop);
        }
        return null;
    }

    @Idempotent
    public int getVariableCount() {
        CodeUnit code = this.rootNode.getCodeUnit();
        return code.varnames.length + code.cellvars.length + code.freevars.length;
    }

    public TruffleString getVariableName(int slot) {
        CodeUnit code = this.rootNode.getCodeUnit();
        if (slot < code.varnames.length) {
            return code.varnames[slot];
        }
        if (slot < code.varnames.length + code.cellvars.length) {
            return code.cellvars[slot - code.varnames.length];
        }
        return code.freevars[slot - code.varnames.length - code.cellvars.length];
    }
}

