/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.object;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.object.SlowPathGetInstanceShapeNode;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.instrumentation.AllocationReporter;
import com.oracle.truffle.api.object.Shape;
import java.util.Objects;

public final class PythonObjectSlowPathFactory
extends PythonObjectFactory {
    private final AllocationReporter reporter;
    private final PythonLanguage language;
    private final SlowPathGetInstanceShapeNode getInstanceShapeNode;

    public PythonObjectSlowPathFactory(AllocationReporter reporter, PythonLanguage language) {
        this.reporter = Objects.requireNonNull(reporter);
        this.language = language;
        this.getInstanceShapeNode = new SlowPathGetInstanceShapeNode(language);
    }

    @Override
    public PythonLanguage getLanguage() {
        return this.language;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    protected AllocationReporter executeTrace(Object arg0Value, long arg1Value) {
        assert (PythonContext.get(null).getAllocationReporter() == this.reporter);
        return PythonObjectFactory.doTrace(arg0Value, arg1Value, this.reporter);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    protected Shape executeGetShape(Object arg0Value, boolean arg1Value) {
        return this.getInstanceShapeNode.execute(arg0Value);
    }

    public boolean isAdoptable() {
        return false;
    }
}

