/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.plugins.dsl;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.logging.Logger;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.kotlin.dsl.plugins.dsl.KotlinCompilerWarningSilencingLogger;
import org.gradle.kotlin.dsl.plugins.dsl.KotlinCompilerWarningSubstitutingLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.tasks.KotlinCompile;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006\u001a\u0014\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0014\u0010\u0011\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"documentationRegistry", "Lorg/gradle/api/internal/DocumentationRegistry;", "Lorg/gradle/api/Project;", "getDocumentationRegistry", "(Lorg/gradle/api/Project;)Lorg/gradle/api/internal/DocumentationRegistry;", "experimentalWarningLink", "", "getExperimentalWarningLink", "(Lorg/gradle/api/Project;)Ljava/lang/String;", "kotlinDslPluginExperimentalWarning", "target", "link", "applyExperimentalWarning", "", "Lorg/jetbrains/kotlin/gradle/tasks/KotlinCompile;", "experimentalWarning", "", "replaceLoggerWith", "logger", "Lorg/gradle/api/logging/Logger;", "plugins"})
public final class KotlinDslCompilerPluginsKt {
    private static final void applyExperimentalWarning(@NotNull KotlinCompile $receiver, boolean experimentalWarning) {
        Logger logger;
        if (experimentalWarning) {
            Logger logger2 = $receiver.getLogger();
            Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"logger");
            String string = $receiver.getProject().toString();
            Project project = $receiver.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            logger = new KotlinCompilerWarningSubstitutingLogger(logger2, string, KotlinDslCompilerPluginsKt.getExperimentalWarningLink(project));
        } else {
            Logger logger3 = $receiver.getLogger();
            Intrinsics.checkExpressionValueIsNotNull((Object)logger3, (String)"logger");
            logger = new KotlinCompilerWarningSilencingLogger(logger3);
        }
        KotlinDslCompilerPluginsKt.replaceLoggerWith($receiver, logger);
    }

    private static final void replaceLoggerWith(@NotNull KotlinCompile $receiver, Logger logger) {
        KotlinCompile kotlinCompile = $receiver;
        if (kotlinCompile == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.internal.TaskInternal");
        }
        ((TaskInternal)kotlinCompile).replaceLogger(logger);
    }

    @NotNull
    public static final String kotlinDslPluginExperimentalWarning(@NotNull String target, @NotNull String link) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)link, (String)"link");
        return "The `kotlin-dsl` plugin applied to " + target + " enables experimental Kotlin compiler features. For more information see " + link;
    }

    private static final String getExperimentalWarningLink(@NotNull Project $receiver) {
        String string = KotlinDslCompilerPluginsKt.getDocumentationRegistry($receiver).getDocumentationFor("kotlin_dsl", "sec:kotlin-dsl_plugin");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"documentationRegistry.ge\u2026 \"sec:kotlin-dsl_plugin\")");
        return string;
    }

    private static final DocumentationRegistry getDocumentationRegistry(@NotNull Project $receiver) {
        Project $receiver$iv = $receiver;
        boolean $i$f$serviceOf = false;
        Project project = $receiver$iv;
        if (project == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.internal.project.ProjectInternal");
        }
        ServiceRegistry serviceRegistry = ((ProjectInternal)project).getServices();
        Intrinsics.checkExpressionValueIsNotNull((Object)serviceRegistry, (String)"(this as ProjectInternal).services");
        ServiceRegistry $receiver$iv$iv = serviceRegistry;
        boolean $i$f$get = false;
        Object object = $receiver$iv$iv.get(DocumentationRegistry.class);
        if (object == null) {
            Intrinsics.throwNpe();
        }
        return (DocumentationRegistry)object;
    }

    public static final /* synthetic */ void access$applyExperimentalWarning(KotlinCompile $receiver, boolean experimentalWarning) {
        KotlinDslCompilerPluginsKt.applyExperimentalWarning($receiver, experimentalWarning);
    }
}

