/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream;

import java.util.Iterator;
import java.util.LinkedList;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.AdjacencyListGraph;
import org.graphstream.graph.implementations.Graphs;
import org.graphstream.stream.AttributeSink;
import org.graphstream.stream.ElementSink;
import org.graphstream.stream.PipeBase;
import org.graphstream.stream.Replayable;
import org.graphstream.stream.Sink;
import org.graphstream.stream.SinkAdapter;
import org.graphstream.stream.Source;
import org.graphstream.util.GraphDiff;
import org.graphstream.util.VerboseSink;

public class Timeline
implements Source,
Replayable,
Iterable<Graph> {
    public static final String TIME_PREFIX = "time";
    LinkedList<StepDiff> diffs = new LinkedList();
    protected boolean changed = false;
    protected Graph initialGraph;
    protected Graph currentGraph;
    protected GraphDiff currentDiff = null;
    protected Connector connector = new Connector();
    protected PipeBase pipe = new PipeBase();
    protected int seeker;

    public void reset() {
    }

    public void play(double from, double to) {
        this.play(from, to, this.pipe);
    }

    public void play(double from, double to, Sink sink) {
        if (this.diffs.size() == 0) {
            return;
        }
        if (from > to) {
            int j;
            for (int i = this.diffs.size() - 1; i > 0 && this.diffs.get((int)i).step > from; --i) {
            }
            for (j = i; j > 0 && this.diffs.get((int)j).step >= to; --j) {
            }
            for (int k = i; k >= j; --k) {
                this.diffs.get((int)k).diff.reverse(sink);
            }
        } else {
            int j;
            for (int i = 0; i < this.diffs.size() - 1 && this.diffs.get((int)i).step < from; ++i) {
            }
            for (j = i; j < this.diffs.size() - 1 && this.diffs.get((int)j).step <= to; ++j) {
            }
            for (int k = i; k <= j; ++k) {
                this.diffs.get((int)k).diff.apply(sink);
            }
        }
    }

    public void play() {
        this.play(this.initialGraph.getStep(), this.currentGraph.getStep());
    }

    public void play(Sink sink) {
        this.play(this.initialGraph.getStep(), this.currentGraph.getStep(), sink);
    }

    public void playback() {
        this.play(this.currentGraph.getStep(), this.initialGraph.getStep());
    }

    public void playback(Sink sink) {
        this.play(this.currentGraph.getStep(), this.initialGraph.getStep(), sink);
    }

    public void seek(int i) {
        this.seeker = i;
    }

    public void seekStart() {
        this.seeker = 0;
    }

    public void seekEnd() {
        this.seeker = this.diffs.size();
    }

    public boolean hasNext() {
        return this.seeker < this.diffs.size();
    }

    public void next() {
        if (this.seeker >= this.diffs.size()) {
            return;
        }
        this.diffs.get((int)this.seeker++).diff.apply(this.pipe);
    }

    public boolean hasPrevious() {
        return this.seeker > 0;
    }

    public void previous() {
        if (this.seeker <= 0) {
            return;
        }
        this.diffs.get((int)(--this.seeker)).diff.reverse(this.pipe);
    }

    public void begin(Source source) {
        this.initialGraph = new AdjacencyListGraph("initial");
        this.currentGraph = new AdjacencyListGraph("initial");
        this.begin();
    }

    public void begin(Graph source) {
        this.initialGraph = Graphs.clone(source);
        this.currentGraph = source;
        this.begin();
    }

    protected void begin() {
        this.currentGraph.addSink(this.connector);
        this.pushDiff();
    }

    public void end() {
        if (this.currentDiff != null) {
            this.currentDiff.end();
            this.diffs.add(new StepDiff(this.currentGraph.getStep(), this.currentDiff));
        }
        this.currentGraph.removeSink(this.connector);
        this.currentGraph = Graphs.clone(this.currentGraph);
    }

    protected void pushDiff() {
        if (this.currentDiff != null) {
            this.currentDiff.end();
            this.diffs.add(new StepDiff(this.currentGraph.getStep(), this.currentDiff));
        }
        this.currentDiff = new GraphDiff();
        this.currentDiff.start(this.currentGraph);
    }

    @Override
    public Iterator<Graph> iterator() {
        return new TimelineIterator();
    }

    @Override
    public Replayable.Controller getReplayController() {
        return new TimelineReplayController();
    }

    @Override
    public void addSink(Sink sink) {
        this.pipe.addSink(sink);
    }

    @Override
    public void removeSink(Sink sink) {
        this.pipe.removeSink(sink);
    }

    @Override
    public void addAttributeSink(AttributeSink sink) {
        this.pipe.addAttributeSink(sink);
    }

    @Override
    public void removeAttributeSink(AttributeSink sink) {
        this.pipe.removeAttributeSink(sink);
    }

    @Override
    public void addElementSink(ElementSink sink) {
        this.pipe.addElementSink(sink);
    }

    @Override
    public void removeElementSink(ElementSink sink) {
        this.pipe.removeElementSink(sink);
    }

    @Override
    public void clearElementSinks() {
        this.pipe.clearElementSinks();
    }

    @Override
    public void clearAttributeSinks() {
        this.pipe.clearAttributeSinks();
    }

    @Override
    public void clearSinks() {
        this.pipe.clearSinks();
    }

    public static void main(String ... strings) throws Exception {
        AdjacencyListGraph g = new AdjacencyListGraph("g");
        Timeline timeline = new Timeline();
        timeline.addSink(new VerboseSink());
        timeline.begin(g);
        g.stepBegins(0.0);
        g.addNode("A");
        g.addNode("B");
        g.stepBegins(1.0);
        g.addNode("C");
        timeline.end();
        System.out.printf("############\n", new Object[0]);
        System.out.printf("# Play :\n", new Object[0]);
        timeline.play();
        System.out.printf("############\n", new Object[0]);
        System.out.printf("# Playback :\n", new Object[0]);
        timeline.playback();
        System.out.printf("############\n", new Object[0]);
        System.out.printf("# Sequence :\n", new Object[0]);
        int i = 0;
        for (Graph it : timeline) {
            System.out.printf(" Graph#%d %s\n", i, Timeline.toString(it));
        }
        System.out.printf("############\n", new Object[0]);
    }

    private static String toString(Graph g) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("id=\"").append(g.getId()).append("\" node={");
        for (Node n : g) {
            buffer.append("\"").append(n.getId()).append("\", ");
        }
        buffer.append("}, edges={");
        for (Edge e : g.getEachEdge()) {
            buffer.append("\"").append(e.getId()).append("\":\"").append(e.getSourceNode().getId()).append("\"--\"").append(e.getTargetNode().getId()).append("\", ");
        }
        buffer.append("}");
        return buffer.toString();
    }

    protected class TimelineIterator
    implements Iterator<Graph> {
        Graph current;
        int idx;

        public TimelineIterator() {
            this.current = Graphs.clone(Timeline.this.initialGraph);
            this.idx = 0;
        }

        @Override
        public boolean hasNext() {
            return this.idx < Timeline.this.diffs.size();
        }

        @Override
        public Graph next() {
            if (this.idx >= Timeline.this.diffs.size()) {
                return null;
            }
            Timeline.this.diffs.get((int)this.idx++).diff.apply(this.current);
            return Graphs.clone(this.current);
        }

        @Override
        public void remove() {
        }
    }

    protected class TimelineReplayController
    extends PipeBase
    implements Replayable.Controller {
        protected TimelineReplayController() {
        }

        @Override
        public void replay() {
            Timeline.this.play(this);
        }

        @Override
        public void replay(String sourceId) {
            String tmp = this.sourceId;
            this.sourceId = sourceId;
            Timeline.this.play(this);
            this.sourceId = tmp;
        }
    }

    protected class Connector
    extends SinkAdapter {
        protected Connector() {
        }

        @Override
        public void stepBegins(String sourceId, long timeId, double step) {
            Timeline.this.pushDiff();
        }
    }

    private class StepDiff {
        double step;
        GraphDiff diff;

        StepDiff(double step, GraphDiff diff) {
            this.step = step;
            this.diff = diff;
        }
    }
}

