/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file;

import java.awt.Color;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.graphstream.stream.file.FileSourceXML;

public class FileSourceGEXF
extends FileSourceXML {
    private static final Pattern IS_DOUBLE = Pattern.compile("^-?\\d+([.]\\d+)?$");
    protected GEXFParser parser;

    @Override
    protected void afterStartDocument() throws IOException, XMLStreamException {
        this.parser = new GEXFParser();
        this.parser.__gexf();
    }

    @Override
    public boolean nextEvents() throws IOException {
        return false;
    }

    @Override
    protected void beforeEndDocument() {
        this.parser = null;
    }

    public static interface GEXFConstants {

        public static enum TimeFormatType {
            INTEGER,
            DOUBLE,
            DATE,
            DATETIME;

        }

        public static enum ClassType {
            NODE,
            EDGE;

        }

        public static enum AttributeType {
            INTEGER,
            LONG,
            FLOAT,
            DOUBLE,
            BOOLEAN,
            ANYURI,
            LISTSTRING,
            STRING;

        }

        public static enum EdgeShapeType {
            SOLID,
            DOTTED,
            DASHED,
            DOUBLE;

        }

        public static enum NodeShapeType {
            DISC,
            SQUARE,
            TRIANGLE,
            DIAMOND,
            IMAGE;

        }

        public static enum EdgeType {
            DIRECTED,
            UNDIRECTED,
            MUTUAL;

        }

        public static enum WeightType {
            FLOAT;

        }

        public static enum ModeType {
            STATIC,
            DYNAMIC;

        }

        public static enum IDType {
            INTEGER,
            STRING;

        }

        public static enum EDGESHAPEAttribute {
            VALUE,
            START,
            STARTOPEN,
            END,
            ENDOPEN;

        }

        public static enum THICKNESSAttribute {
            VALUE,
            START,
            STARTOPEN,
            END,
            ENDOPEN;

        }

        public static enum EDGEAttribute {
            START,
            STARTOPEN,
            END,
            ENDOPEN,
            ID,
            TYPE,
            LABEL,
            SOURCE,
            TARGET,
            WEIGHT;

        }

        public static enum NODESHAPEAttribute {
            VALUE,
            URI,
            START,
            STARTOPEN,
            END,
            ENDOPEN;

        }

        public static enum SIZEAttribute {
            VALUE,
            START,
            STARTOPEN,
            END,
            ENDOPEN;

        }

        public static enum POSITIONAttribute {
            X,
            Y,
            Z,
            START,
            STARTOPEN,
            END,
            ENDOPEN;

        }

        public static enum COLORAttribute {
            R,
            G,
            B,
            A,
            START,
            STARTOPEN,
            END,
            ENDOPEN;

        }

        public static enum SPELLAttribute {
            START,
            STARTOPEN,
            END,
            ENDOPEN;

        }

        public static enum EDGESAttribute {
            COUNT;

        }

        public static enum PARENTAttribute {
            FOR;

        }

        public static enum ATTVALUEAttribute {
            FOR,
            VALUE,
            START,
            STARTOPEN,
            END,
            ENDOPEN;

        }

        public static enum NODEAttribute {
            START,
            STARTOPEN,
            END,
            ENDOPEN,
            PID,
            ID,
            LABEL;

        }

        public static enum NODESAttribute {
            COUNT;

        }

        public static enum ATTRIBUTEAttribute {
            ID,
            TITLE,
            TYPE;

        }

        public static enum ATTRIBUTESAttribute {
            CLASS,
            MODE,
            START,
            STARTOPEN,
            END,
            ENDOPEN;

        }

        public static enum GRAPHAttribute {
            TIMEFORMAT,
            START,
            STARTOPEN,
            END,
            ENDOPEN,
            DEFAULTEDGETYPE,
            IDTYPE,
            MODE;

        }

        public static enum METAAttribute {
            LASTMODIFIEDDATE;

        }

        public static enum GEXFAttribute {
            XMLNS,
            VERSION;

        }

        public static enum Balise {
            GEXF,
            GRAPH,
            META,
            CREATOR,
            KEYWORDS,
            DESCRIPTION,
            NODES,
            NODE,
            EDGES,
            EDGE,
            COLOR,
            POSITION,
            SIZE,
            SHAPE,
            THICKNESS,
            DEFAULT,
            OPTIONS,
            ATTVALUES,
            PARENTS,
            SPELLS;

        }
    }

    private class GEXFParser
    extends FileSourceXML.Parser
    implements GEXFConstants {
        GEXFConstants.EdgeType defaultEdgeType;
        GEXFConstants.TimeFormatType timeFormat;
        HashMap<String, Attribute> nodeAttributesDefinition;
        HashMap<String, Attribute> edgeAttributesDefinition;

        GEXFParser() {
            super(FileSourceGEXF.this);
            this.defaultEdgeType = GEXFConstants.EdgeType.UNDIRECTED;
            this.timeFormat = GEXFConstants.TimeFormatType.INTEGER;
            this.nodeAttributesDefinition = new HashMap();
            this.edgeAttributesDefinition = new HashMap();
        }

        private long getTime(String time) {
            long t = 0L;
            switch (this.timeFormat) {
                case INTEGER: {
                    t = Integer.valueOf(time).intValue();
                    break;
                }
                case DOUBLE: {
                    break;
                }
                case DATE: {
                    break;
                }
            }
            return t;
        }

        private void __gexf() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGEXF.this.getNextEvent();
            FileSourceGEXF.this.checkValid(e, 1, "gexf");
            e = FileSourceGEXF.this.getNextEvent();
            if (FileSourceGEXF.this.isEvent(e, 1, "meta")) {
                FileSourceGEXF.this.pushback(e);
                this.__meta();
            } else {
                FileSourceGEXF.this.pushback(e);
            }
            this.__graph();
            e = FileSourceGEXF.this.getNextEvent();
            FileSourceGEXF.this.checkValid(e, 2, "gexf");
        }

        private void __meta() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGEXF.this.getNextEvent();
            FileSourceGEXF.this.checkValid(e, 1, "meta");
            EnumMap<GEXFConstants.METAAttribute, String> attributes = this.getAttributes(GEXFConstants.METAAttribute.class, e.asStartElement());
            if (attributes.containsKey((Object)GEXFConstants.METAAttribute.LASTMODIFIEDDATE)) {
                FileSourceGEXF.this.sendGraphAttributeAdded(FileSourceGEXF.this.sourceId, "lastmodifieddate", attributes.get((Object)GEXFConstants.METAAttribute.LASTMODIFIEDDATE));
            }
            e = FileSourceGEXF.this.getNextEvent();
            while (!FileSourceGEXF.this.isEvent(e, 2, "meta")) {
                try {
                    GEXFConstants.Balise b = GEXFConstants.Balise.valueOf(FileSourceGEXF.this.toConstantName(e.asStartElement().getName().getLocalPart()));
                    FileSourceGEXF.this.pushback(e);
                    switch (b) {
                        case CREATOR: {
                            String str = this.__creator();
                            FileSourceGEXF.this.sendGraphAttributeAdded(FileSourceGEXF.this.sourceId, "creator", str);
                            break;
                        }
                        case KEYWORDS: {
                            String str = this.__keywords();
                            FileSourceGEXF.this.sendGraphAttributeAdded(FileSourceGEXF.this.sourceId, "keywords", str);
                            break;
                        }
                        case DESCRIPTION: {
                            String str = this.__description();
                            FileSourceGEXF.this.sendGraphAttributeAdded(FileSourceGEXF.this.sourceId, "description", str);
                            break;
                        }
                        default: {
                            throw FileSourceGEXF.this.newParseError(e, "meta children should be one of 'creator','keywords' or 'description'", new Object[0]);
                        }
                    }
                }
                catch (IllegalArgumentException ex) {
                    throw FileSourceGEXF.this.newParseError(e, "unknown element '%s'", e.asStartElement().getName().getLocalPart());
                }
                e = FileSourceGEXF.this.getNextEvent();
            }
            FileSourceGEXF.this.checkValid(e, 2, "meta");
        }

        private String __creator() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGEXF.this.getNextEvent();
            FileSourceGEXF.this.checkValid(e, 1, "creator");
            String creator = this.__characters();
            e = FileSourceGEXF.this.getNextEvent();
            FileSourceGEXF.this.checkValid(e, 2, "creator");
            return creator;
        }

        private String __keywords() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGEXF.this.getNextEvent();
            FileSourceGEXF.this.checkValid(e, 1, "keywords");
            String keywords = this.__characters();
            e = FileSourceGEXF.this.getNextEvent();
            FileSourceGEXF.this.checkValid(e, 2, "keywords");
            return keywords;
        }

        private String __description() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGEXF.this.getNextEvent();
            FileSourceGEXF.this.checkValid(e, 1, "description");
            String description = this.__characters();
            e = FileSourceGEXF.this.getNextEvent();
            FileSourceGEXF.this.checkValid(e, 2, "description");
            return description;
        }

        private void __graph() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGEXF.this.getNextEvent();
            FileSourceGEXF.this.checkValid(e, 1, "graph");
            EnumMap<GEXFConstants.GRAPHAttribute, String> attributes = this.getAttributes(GEXFConstants.GRAPHAttribute.class, e.asStartElement());
            if (attributes.containsKey((Object)GEXFConstants.GRAPHAttribute.DEFAULTEDGETYPE)) {
                try {
                    this.defaultEdgeType = GEXFConstants.EdgeType.valueOf(FileSourceGEXF.this.toConstantName(attributes.get((Object)GEXFConstants.GRAPHAttribute.DEFAULTEDGETYPE)));
                }
                catch (IllegalArgumentException ex) {
                    throw FileSourceGEXF.this.newParseError(e, "'defaultedgetype' value should be one of 'directed', 'undirected' or 'mutual'", new Object[0]);
                }
            }
            if (attributes.containsKey((Object)GEXFConstants.GRAPHAttribute.TIMEFORMAT)) {
                try {
                    this.timeFormat = GEXFConstants.TimeFormatType.valueOf(FileSourceGEXF.this.toConstantName(attributes.get((Object)GEXFConstants.GRAPHAttribute.TIMEFORMAT)));
                }
                catch (IllegalArgumentException ex) {
                    throw FileSourceGEXF.this.newParseError(e, "'timeformat' value should be one of 'integer', 'double', 'date' or 'datetime'", new Object[0]);
                }
            }
            e = FileSourceGEXF.this.getNextEvent();
            while (FileSourceGEXF.this.isEvent(e, 1, "attributes")) {
                FileSourceGEXF.this.pushback(e);
                this.__attributes();
                e = FileSourceGEXF.this.getNextEvent();
            }
            while (FileSourceGEXF.this.isEvent(e, 1, "nodes") || FileSourceGEXF.this.isEvent(e, 1, "edges")) {
                if (FileSourceGEXF.this.isEvent(e, 1, "nodes")) {
                    FileSourceGEXF.this.pushback(e);
                    this.__nodes();
                } else {
                    FileSourceGEXF.this.pushback(e);
                    this.__edges();
                }
                e = FileSourceGEXF.this.getNextEvent();
            }
            FileSourceGEXF.this.checkValid(e, 2, "graph");
        }

        private void __attributes() throws IOException, XMLStreamException {
            GEXFConstants.ClassType type;
            XMLEvent e = FileSourceGEXF.this.getNextEvent();
            FileSourceGEXF.this.checkValid(e, 1, "attributes");
            EnumMap<GEXFConstants.ATTRIBUTESAttribute, String> attributes = this.getAttributes(GEXFConstants.ATTRIBUTESAttribute.class, e.asStartElement());
            this.checkRequiredAttributes(e, attributes, new GEXFConstants.ATTRIBUTESAttribute[]{GEXFConstants.ATTRIBUTESAttribute.CLASS});
            try {
                type = GEXFConstants.ClassType.valueOf(FileSourceGEXF.this.toConstantName(attributes.get((Object)GEXFConstants.ATTRIBUTESAttribute.CLASS)));
            }
            catch (IllegalArgumentException ex) {
                throw FileSourceGEXF.this.newParseError(e, "'class' value shoudl be one of 'node' or 'edge'", new Object[0]);
            }
            HashMap<String, Attribute> attr = type == GEXFConstants.ClassType.NODE ? this.nodeAttributesDefinition : this.edgeAttributesDefinition;
            e = FileSourceGEXF.this.getNextEvent();
            while (FileSourceGEXF.this.isEvent(e, 1, "attribute")) {
                FileSourceGEXF.this.pushback(e);
                Attribute a = this.__attribute();
                attr.put(a.id, a);
                e = FileSourceGEXF.this.getNextEvent();
            }
            FileSourceGEXF.this.checkValid(e, 2, "attributes");
        }

        private Attribute __attribute() throws IOException, XMLStreamException {
            GEXFConstants.AttributeType type;
            XMLEvent e = FileSourceGEXF.this.getNextEvent();
            FileSourceGEXF.this.checkValid(e, 1, "attribute");
            EnumMap<GEXFConstants.ATTRIBUTEAttribute, String> attributes = this.getAttributes(GEXFConstants.ATTRIBUTEAttribute.class, e.asStartElement());
            this.checkRequiredAttributes(e, attributes, new GEXFConstants.ATTRIBUTEAttribute[]{GEXFConstants.ATTRIBUTEAttribute.ID, GEXFConstants.ATTRIBUTEAttribute.TITLE, GEXFConstants.ATTRIBUTEAttribute.TYPE});
            String id = attributes.get((Object)GEXFConstants.ATTRIBUTEAttribute.ID);
            String title = attributes.get((Object)GEXFConstants.ATTRIBUTEAttribute.TITLE);
            try {
                type = GEXFConstants.AttributeType.valueOf(FileSourceGEXF.this.toConstantName(attributes.get((Object)GEXFConstants.ATTRIBUTEAttribute.TYPE)));
            }
            catch (IllegalArgumentException ex) {
                throw FileSourceGEXF.this.newParseError(e, "'type' of attribute should be one of 'integer', 'long', 'float, 'double', 'string', 'liststring', 'anyURI' or 'boolean'", new Object[0]);
            }
            Attribute theAttribute = new Attribute(id, title, type);
            e = FileSourceGEXF.this.getNextEvent();
            while (!FileSourceGEXF.this.isEvent(e, 2, "attribute")) {
                try {
                    GEXFConstants.Balise b = GEXFConstants.Balise.valueOf(FileSourceGEXF.this.toConstantName(e.asStartElement().getName().getLocalPart()));
                    FileSourceGEXF.this.pushback(e);
                    switch (b) {
                        case DEFAULT: {
                            try {
                                theAttribute.setDefault(this.__default());
                                break;
                            }
                            catch (Exception invalid) {
                                throw FileSourceGEXF.this.newParseError(e, "invalid 'default' value", new Object[0]);
                            }
                        }
                        case OPTIONS: {
                            theAttribute.setOptions(this.__options());
                            break;
                        }
                        default: {
                            throw FileSourceGEXF.this.newParseError(e, "attribute children should be one of 'default' or 'options'", new Object[0]);
                        }
                    }
                }
                catch (IllegalArgumentException ex) {
                    throw FileSourceGEXF.this.newParseError(e, "unknown element '%s'", e.asStartElement().getName().getLocalPart());
                }
                e = FileSourceGEXF.this.getNextEvent();
            }
            FileSourceGEXF.this.checkValid(e, 2, "attribute");
            return theAttribute;
        }

        private String __default() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGEXF.this.getNextEvent();
            FileSourceGEXF.this.checkValid(e, 1, "default");
            String def = this.__characters();
            e = FileSourceGEXF.this.getNextEvent();
            FileSourceGEXF.this.checkValid(e, 2, "default");
            return def;
        }

        private String __options() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGEXF.this.getNextEvent();
            FileSourceGEXF.this.checkValid(e, 1, "options");
            String options = this.__characters();
            e = FileSourceGEXF.this.getNextEvent();
            FileSourceGEXF.this.checkValid(e, 2, "options");
            return options;
        }

        private void __nodes() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGEXF.this.getNextEvent();
            FileSourceGEXF.this.checkValid(e, 1, "nodes");
            e = FileSourceGEXF.this.getNextEvent();
            while (FileSourceGEXF.this.isEvent(e, 1, "node")) {
                FileSourceGEXF.this.pushback(e);
                this.__node();
                e = FileSourceGEXF.this.getNextEvent();
            }
            FileSourceGEXF.this.checkValid(e, 2, "nodes");
        }

        private void __node() throws IOException, XMLStreamException {
            HashSet<String> defined = new HashSet<String>();
            XMLEvent e = FileSourceGEXF.this.getNextEvent();
            FileSourceGEXF.this.checkValid(e, 1, "node");
            EnumMap<GEXFConstants.NODEAttribute, String> attributes = this.getAttributes(GEXFConstants.NODEAttribute.class, e.asStartElement());
            this.checkRequiredAttributes(e, attributes, new GEXFConstants.NODEAttribute[]{GEXFConstants.NODEAttribute.ID});
            String id = attributes.get((Object)GEXFConstants.NODEAttribute.ID);
            FileSourceGEXF.this.sendNodeAdded(FileSourceGEXF.this.sourceId, id);
            if (attributes.containsKey((Object)GEXFConstants.NODEAttribute.LABEL)) {
                FileSourceGEXF.this.sendNodeAttributeAdded(FileSourceGEXF.this.sourceId, id, "label", attributes.get((Object)GEXFConstants.NODEAttribute.LABEL));
            }
            e = FileSourceGEXF.this.getNextEvent();
            while (!FileSourceGEXF.this.isEvent(e, 2, "node")) {
                try {
                    GEXFConstants.Balise b = GEXFConstants.Balise.valueOf(FileSourceGEXF.this.toConstantName(e.asStartElement().getName().getLocalPart()));
                    FileSourceGEXF.this.pushback(e);
                    switch (b) {
                        case ATTVALUES: {
                            defined.addAll(this.__attvalues(GEXFConstants.ClassType.NODE, id));
                            break;
                        }
                        case COLOR: {
                            this.__color(GEXFConstants.ClassType.NODE, id);
                            break;
                        }
                        case POSITION: {
                            this.__position(id);
                            break;
                        }
                        case SIZE: {
                            this.__size(id);
                            break;
                        }
                        case SHAPE: {
                            this.__node_shape(id);
                            break;
                        }
                        case SPELLS: {
                            this.__spells();
                            break;
                        }
                        case NODES: {
                            this.__nodes();
                            break;
                        }
                        case EDGES: {
                            this.__edges();
                            break;
                        }
                        case PARENTS: {
                            this.__parents(id);
                            break;
                        }
                        default: {
                            throw FileSourceGEXF.this.newParseError(e, "attribute children should be one of 'attvalues', 'color', 'position', 'size', shape', 'spells', 'nodes, 'edges' or 'parents'", new Object[0]);
                        }
                    }
                }
                catch (IllegalArgumentException ex) {
                    throw FileSourceGEXF.this.newParseError(e, "unknown element '%s'", e.asStartElement().getName().getLocalPart());
                }
                e = FileSourceGEXF.this.getNextEvent();
            }
            for (Attribute theAttribute : this.nodeAttributesDefinition.values()) {
                if (defined.contains(theAttribute.id)) continue;
                FileSourceGEXF.this.sendNodeAttributeAdded(FileSourceGEXF.this.sourceId, id, theAttribute.title, theAttribute.def);
            }
            FileSourceGEXF.this.checkValid(e, 2, "node");
        }

        private HashSet<String> __attvalues(GEXFConstants.ClassType type, String elementId) throws IOException, XMLStreamException {
            HashSet<String> defined = new HashSet<String>();
            XMLEvent e = FileSourceGEXF.this.getNextEvent();
            FileSourceGEXF.this.checkValid(e, 1, "attvalues");
            e = FileSourceGEXF.this.getNextEvent();
            while (FileSourceGEXF.this.isEvent(e, 1, "attvalue")) {
                FileSourceGEXF.this.pushback(e);
                defined.add(this.__attvalue(type, elementId));
                e = FileSourceGEXF.this.getNextEvent();
            }
            FileSourceGEXF.this.checkValid(e, 2, "attvalues");
            return defined;
        }

        private String __attvalue(GEXFConstants.ClassType type, String elementId) throws IOException, XMLStreamException {
            Object value;
            XMLEvent e = FileSourceGEXF.this.getNextEvent();
            FileSourceGEXF.this.checkValid(e, 1, "attvalue");
            EnumMap<GEXFConstants.ATTVALUEAttribute, String> attributes = this.getAttributes(GEXFConstants.ATTVALUEAttribute.class, e.asStartElement());
            this.checkRequiredAttributes(e, attributes, new GEXFConstants.ATTVALUEAttribute[]{GEXFConstants.ATTVALUEAttribute.FOR, GEXFConstants.ATTVALUEAttribute.VALUE});
            Attribute theAttribute = type == GEXFConstants.ClassType.NODE ? this.nodeAttributesDefinition.get(attributes.get((Object)GEXFConstants.ATTVALUEAttribute.FOR)) : this.edgeAttributesDefinition.get(attributes.get((Object)GEXFConstants.ATTVALUEAttribute.FOR));
            if (theAttribute == null) {
                throw FileSourceGEXF.this.newParseError(e, "undefined attribute \"%s\"", attributes.get((Object)GEXFConstants.ATTVALUEAttribute.FOR));
            }
            try {
                value = theAttribute.getValue(attributes.get((Object)GEXFConstants.ATTVALUEAttribute.VALUE));
            }
            catch (Exception ex) {
                throw FileSourceGEXF.this.newParseError(e, "invalid 'value' value", new Object[0]);
            }
            switch (type) {
                case NODE: {
                    FileSourceGEXF.this.sendNodeAttributeAdded(FileSourceGEXF.this.sourceId, elementId, theAttribute.title, value);
                    break;
                }
                case EDGE: {
                    FileSourceGEXF.this.sendEdgeAttributeAdded(FileSourceGEXF.this.sourceId, elementId, theAttribute.title, value);
                }
            }
            e = FileSourceGEXF.this.getNextEvent();
            FileSourceGEXF.this.checkValid(e, 2, "attvalue");
            return theAttribute.id;
        }

        private void __spells() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGEXF.this.getNextEvent();
            FileSourceGEXF.this.checkValid(e, 1, "spells");
            do {
                this.__spell();
            } while (FileSourceGEXF.this.isEvent(e = FileSourceGEXF.this.getNextEvent(), 1, "spell"));
            FileSourceGEXF.this.checkValid(e, 2, "spells");
        }

        private void __spell() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGEXF.this.getNextEvent();
            FileSourceGEXF.this.checkValid(e, 1, "spell");
            EnumMap<GEXFConstants.SPELLAttribute, String> attributes = this.getAttributes(GEXFConstants.SPELLAttribute.class, e.asStartElement());
            e = FileSourceGEXF.this.getNextEvent();
            FileSourceGEXF.this.checkValid(e, 2, "spell");
        }

        private void __parents(String nodeId) throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGEXF.this.getNextEvent();
            FileSourceGEXF.this.checkValid(e, 1, "parents");
            e = FileSourceGEXF.this.getNextEvent();
            while (FileSourceGEXF.this.isEvent(e, 1, "parent")) {
                this.__parent(nodeId);
                e = FileSourceGEXF.this.getNextEvent();
            }
            FileSourceGEXF.this.checkValid(e, 2, "parents");
        }

        private void __parent(String nodeId) throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGEXF.this.getNextEvent();
            FileSourceGEXF.this.checkValid(e, 1, "parent");
            EnumMap<GEXFConstants.PARENTAttribute, String> attributes = this.getAttributes(GEXFConstants.PARENTAttribute.class, e.asStartElement());
            this.checkRequiredAttributes(e, attributes, new GEXFConstants.PARENTAttribute[]{GEXFConstants.PARENTAttribute.FOR});
            FileSourceGEXF.this.sendNodeAttributeAdded(FileSourceGEXF.this.sourceId, attributes.get((Object)GEXFConstants.PARENTAttribute.FOR), "parent", nodeId);
            e = FileSourceGEXF.this.getNextEvent();
            FileSourceGEXF.this.checkValid(e, 2, "parent");
        }

        private void __color(GEXFConstants.ClassType type, String id) throws IOException, XMLStreamException {
            int a = 255;
            XMLEvent e = FileSourceGEXF.this.getNextEvent();
            FileSourceGEXF.this.checkValid(e, 1, "color");
            EnumMap<GEXFConstants.COLORAttribute, String> attributes = this.getAttributes(GEXFConstants.COLORAttribute.class, e.asStartElement());
            this.checkRequiredAttributes(e, attributes, new GEXFConstants.COLORAttribute[]{GEXFConstants.COLORAttribute.R, GEXFConstants.COLORAttribute.G, GEXFConstants.COLORAttribute.B});
            int r = Integer.valueOf(attributes.get((Object)GEXFConstants.COLORAttribute.R));
            int g = Integer.valueOf(attributes.get((Object)GEXFConstants.COLORAttribute.G));
            int b = Integer.valueOf(attributes.get((Object)GEXFConstants.COLORAttribute.B));
            if (attributes.containsKey((Object)GEXFConstants.COLORAttribute.A)) {
                a = Integer.valueOf(attributes.get((Object)GEXFConstants.COLORAttribute.A));
            }
            Color color = new Color(r, g, b, a);
            switch (type) {
                case NODE: {
                    FileSourceGEXF.this.sendNodeAttributeAdded(FileSourceGEXF.this.sourceId, id, "ui.color", color);
                    break;
                }
                case EDGE: {
                    FileSourceGEXF.this.sendEdgeAttributeAdded(FileSourceGEXF.this.sourceId, id, "ui.color", color);
                }
            }
            e = FileSourceGEXF.this.getNextEvent();
            if (FileSourceGEXF.this.isEvent(e, 1, "spells")) {
                FileSourceGEXF.this.pushback(e);
                this.__spells();
                e = FileSourceGEXF.this.getNextEvent();
            }
            FileSourceGEXF.this.checkValid(e, 2, "color");
        }

        private void __position(String nodeId) throws IOException, XMLStreamException {
            double[] xyz = new double[]{0.0, 0.0, 0.0};
            XMLEvent e = FileSourceGEXF.this.getNextEvent();
            FileSourceGEXF.this.checkValid(e, 1, "position");
            EnumMap<GEXFConstants.POSITIONAttribute, String> attributes = this.getAttributes(GEXFConstants.POSITIONAttribute.class, e.asStartElement());
            this.checkRequiredAttributes(e, attributes, new GEXFConstants.POSITIONAttribute[]{GEXFConstants.POSITIONAttribute.X, GEXFConstants.POSITIONAttribute.Y, GEXFConstants.POSITIONAttribute.Z});
            xyz[0] = Double.valueOf(attributes.get((Object)GEXFConstants.POSITIONAttribute.X));
            xyz[1] = Double.valueOf(attributes.get((Object)GEXFConstants.POSITIONAttribute.Y));
            xyz[2] = Double.valueOf(attributes.get((Object)GEXFConstants.POSITIONAttribute.Z));
            FileSourceGEXF.this.sendNodeAttributeAdded(FileSourceGEXF.this.sourceId, nodeId, "xyz", xyz);
            e = FileSourceGEXF.this.getNextEvent();
            if (FileSourceGEXF.this.isEvent(e, 1, "spells")) {
                FileSourceGEXF.this.pushback(e);
                this.__spells();
                e = FileSourceGEXF.this.getNextEvent();
            }
            FileSourceGEXF.this.checkValid(e, 2, "position");
        }

        private void __size(String nodeId) throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGEXF.this.getNextEvent();
            FileSourceGEXF.this.checkValid(e, 1, "size");
            EnumMap<GEXFConstants.SIZEAttribute, String> attributes = this.getAttributes(GEXFConstants.SIZEAttribute.class, e.asStartElement());
            this.checkRequiredAttributes(e, attributes, new GEXFConstants.SIZEAttribute[]{GEXFConstants.SIZEAttribute.VALUE});
            double value = Double.valueOf(attributes.get((Object)GEXFConstants.SIZEAttribute.VALUE));
            FileSourceGEXF.this.sendNodeAttributeAdded(FileSourceGEXF.this.sourceId, nodeId, "ui.size", value);
            e = FileSourceGEXF.this.getNextEvent();
            if (FileSourceGEXF.this.isEvent(e, 1, "spells")) {
                FileSourceGEXF.this.pushback(e);
                this.__spells();
                e = FileSourceGEXF.this.getNextEvent();
            }
            FileSourceGEXF.this.checkValid(e, 2, "size");
        }

        private void __node_shape(String nodeId) throws IOException, XMLStreamException {
            GEXFConstants.NodeShapeType type;
            XMLEvent e = FileSourceGEXF.this.getNextEvent();
            FileSourceGEXF.this.checkValid(e, 1, "shape");
            EnumMap<GEXFConstants.NODESHAPEAttribute, String> attributes = this.getAttributes(GEXFConstants.NODESHAPEAttribute.class, e.asStartElement());
            this.checkRequiredAttributes(e, attributes, new GEXFConstants.NODESHAPEAttribute[]{GEXFConstants.NODESHAPEAttribute.VALUE});
            try {
                type = GEXFConstants.NodeShapeType.valueOf(FileSourceGEXF.this.toConstantName(attributes.get((Object)GEXFConstants.NODESHAPEAttribute.VALUE)));
            }
            catch (IllegalArgumentException ex) {
                throw FileSourceGEXF.this.newParseError(e, "'value' should be one of 'disc', 'diamond', 'triangle', 'square' or 'image'", new Object[0]);
            }
            switch (type) {
                case IMAGE: {
                    if (!attributes.containsKey((Object)GEXFConstants.NODESHAPEAttribute.URI)) {
                        throw FileSourceGEXF.this.newParseError(e, "'image' shape type needs 'uri' attribute", new Object[0]);
                    }
                    String uri = attributes.get((Object)GEXFConstants.NODESHAPEAttribute.URI);
                    FileSourceGEXF.this.sendNodeAttributeAdded(FileSourceGEXF.this.sourceId, nodeId, "ui.style", String.format("fill-mode: image-scaled; fill-image: url('%s');", uri));
                    break;
                }
                default: {
                    FileSourceGEXF.this.sendNodeAttributeAdded(FileSourceGEXF.this.sourceId, nodeId, "ui.style", String.format("shape: %s;", type.name().toLowerCase()));
                }
            }
            e = FileSourceGEXF.this.getNextEvent();
            if (FileSourceGEXF.this.isEvent(e, 1, "spells")) {
                FileSourceGEXF.this.pushback(e);
                this.__spells();
                e = FileSourceGEXF.this.getNextEvent();
            }
            FileSourceGEXF.this.checkValid(e, 2, "shape");
        }

        private void __edges() throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGEXF.this.getNextEvent();
            FileSourceGEXF.this.checkValid(e, 1, "edges");
            e = FileSourceGEXF.this.getNextEvent();
            while (FileSourceGEXF.this.isEvent(e, 1, "edge")) {
                FileSourceGEXF.this.pushback(e);
                this.__edge();
                e = FileSourceGEXF.this.getNextEvent();
            }
            FileSourceGEXF.this.checkValid(e, 2, "edges");
        }

        private void __edge() throws IOException, XMLStreamException {
            GEXFConstants.EdgeType type = this.defaultEdgeType;
            HashSet<String> defined = new HashSet<String>();
            XMLEvent e = FileSourceGEXF.this.getNextEvent();
            FileSourceGEXF.this.checkValid(e, 1, "edge");
            EnumMap<GEXFConstants.EDGEAttribute, String> attributes = this.getAttributes(GEXFConstants.EDGEAttribute.class, e.asStartElement());
            this.checkRequiredAttributes(e, attributes, new GEXFConstants.EDGEAttribute[]{GEXFConstants.EDGEAttribute.ID, GEXFConstants.EDGEAttribute.SOURCE, GEXFConstants.EDGEAttribute.TARGET});
            String id = attributes.get((Object)GEXFConstants.EDGEAttribute.ID);
            String source = attributes.get((Object)GEXFConstants.EDGEAttribute.SOURCE);
            String target = attributes.get((Object)GEXFConstants.EDGEAttribute.TARGET);
            if (attributes.containsKey((Object)GEXFConstants.EDGEAttribute.TYPE)) {
                try {
                    type = GEXFConstants.EdgeType.valueOf(FileSourceGEXF.this.toConstantName(attributes.get((Object)GEXFConstants.EDGEAttribute.TYPE)));
                }
                catch (IllegalArgumentException ex) {
                    throw FileSourceGEXF.this.newParseError(e, "edge type should be one of 'undirected', 'undirected' or 'mutual'", new Object[0]);
                }
            }
            switch (type) {
                case DIRECTED: {
                    FileSourceGEXF.this.sendEdgeAdded(FileSourceGEXF.this.sourceId, id, source, target, true);
                    break;
                }
                case MUTUAL: 
                case UNDIRECTED: {
                    FileSourceGEXF.this.sendEdgeAdded(FileSourceGEXF.this.sourceId, id, source, target, false);
                }
            }
            if (attributes.containsKey((Object)GEXFConstants.EDGEAttribute.LABEL)) {
                FileSourceGEXF.this.sendEdgeAttributeAdded(FileSourceGEXF.this.sourceId, id, "ui.label", attributes.get((Object)GEXFConstants.EDGEAttribute.LABEL));
            }
            if (attributes.containsKey((Object)GEXFConstants.EDGEAttribute.WEIGHT)) {
                try {
                    double d = Double.valueOf(attributes.get((Object)GEXFConstants.EDGEAttribute.WEIGHT));
                    FileSourceGEXF.this.sendEdgeAttributeAdded(FileSourceGEXF.this.sourceId, id, "weight", d);
                }
                catch (NumberFormatException ex) {
                    throw FileSourceGEXF.this.newParseError(e, "'weight' attribute of edge should be a real", new Object[0]);
                }
            }
            e = FileSourceGEXF.this.getNextEvent();
            while (!FileSourceGEXF.this.isEvent(e, 2, "edge")) {
                try {
                    GEXFConstants.Balise b = GEXFConstants.Balise.valueOf(FileSourceGEXF.this.toConstantName(e.asStartElement().getName().getLocalPart()));
                    FileSourceGEXF.this.pushback(e);
                    switch (b) {
                        case ATTVALUES: {
                            defined.addAll(this.__attvalues(GEXFConstants.ClassType.EDGE, id));
                            break;
                        }
                        case SPELLS: {
                            this.__spells();
                            break;
                        }
                        case COLOR: {
                            this.__color(GEXFConstants.ClassType.EDGE, id);
                            break;
                        }
                        case THICKNESS: {
                            this.__thickness(id);
                            break;
                        }
                        case SHAPE: {
                            this.__edge_shape(id);
                            break;
                        }
                        default: {
                            throw FileSourceGEXF.this.newParseError(e, "edge children should be one of 'attvalues', 'color', 'thicknes', 'shape' or 'spells'", new Object[0]);
                        }
                    }
                }
                catch (IllegalArgumentException ex) {
                    throw FileSourceGEXF.this.newParseError(e, "unknown tag '%s'", e.asStartElement().getName().getLocalPart());
                }
                e = FileSourceGEXF.this.getNextEvent();
            }
            for (String key : this.edgeAttributesDefinition.keySet()) {
                if (defined.contains(key)) continue;
                FileSourceGEXF.this.sendEdgeAttributeAdded(FileSourceGEXF.this.sourceId, id, key, this.edgeAttributesDefinition.get((Object)key).def);
            }
            FileSourceGEXF.this.checkValid(e, 2, "edge");
        }

        private void __edge_shape(String edgeId) throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGEXF.this.getNextEvent();
            FileSourceGEXF.this.checkValid(e, 1, "shape");
            EnumMap<GEXFConstants.EDGESHAPEAttribute, String> attributes = this.getAttributes(GEXFConstants.EDGESHAPEAttribute.class, e.asStartElement());
            this.checkRequiredAttributes(e, attributes, new GEXFConstants.EDGESHAPEAttribute[]{GEXFConstants.EDGESHAPEAttribute.VALUE});
            try {
                GEXFConstants.EdgeShapeType type = GEXFConstants.EdgeShapeType.valueOf(FileSourceGEXF.this.toConstantName(attributes.get((Object)GEXFConstants.EDGESHAPEAttribute.VALUE)));
            }
            catch (IllegalArgumentException ex) {
                throw FileSourceGEXF.this.newParseError(e, "'value' of shape should be one of 'solid', 'dotted', 'dashed' or 'double'", new Object[0]);
            }
            e = FileSourceGEXF.this.getNextEvent();
            if (FileSourceGEXF.this.isEvent(e, 1, "spells")) {
                FileSourceGEXF.this.pushback(e);
                this.__spells();
                e = FileSourceGEXF.this.getNextEvent();
            }
            FileSourceGEXF.this.checkValid(e, 2, "shape");
        }

        private void __thickness(String edgeId) throws IOException, XMLStreamException {
            XMLEvent e = FileSourceGEXF.this.getNextEvent();
            FileSourceGEXF.this.checkValid(e, 1, "thickness");
            EnumMap<GEXFConstants.THICKNESSAttribute, String> attributes = this.getAttributes(GEXFConstants.THICKNESSAttribute.class, e.asStartElement());
            this.checkRequiredAttributes(e, attributes, new GEXFConstants.THICKNESSAttribute[]{GEXFConstants.THICKNESSAttribute.VALUE});
            e = FileSourceGEXF.this.getNextEvent();
            if (FileSourceGEXF.this.isEvent(e, 1, "spells")) {
                FileSourceGEXF.this.pushback(e);
                this.__spells();
                e = FileSourceGEXF.this.getNextEvent();
            }
            FileSourceGEXF.this.checkValid(e, 2, "thickness");
        }
    }

    private class Attribute
    implements GEXFConstants {
        final String id;
        final String title;
        final GEXFConstants.AttributeType type;
        Object def;
        String options;

        Attribute(String id, String title, GEXFConstants.AttributeType type) {
            this.id = id;
            this.title = title;
            this.type = type;
        }

        Object getValue(String value) {
            Object[] r;
            switch (this.type) {
                case INTEGER: {
                    r = Integer.valueOf(value);
                    break;
                }
                case LONG: {
                    r = Long.valueOf(value);
                    break;
                }
                case FLOAT: {
                    r = Float.valueOf(value);
                    break;
                }
                case DOUBLE: {
                    r = Double.valueOf(value);
                    break;
                }
                case BOOLEAN: {
                    r = Boolean.valueOf(value);
                    break;
                }
                case LISTSTRING: {
                    String[] list = value.split("\\|");
                    boolean isDouble = true;
                    for (int i = 0; i < list.length; ++i) {
                        isDouble = isDouble && IS_DOUBLE.matcher(list[i]).matches();
                    }
                    if (isDouble) {
                        double[] dlist = new double[list.length];
                        for (int i = 0; i < list.length; ++i) {
                            dlist[i] = Double.parseDouble(list[i]);
                        }
                        r = dlist;
                        break;
                    }
                    r = list;
                    break;
                }
                case ANYURI: {
                    try {
                        r = new URI(value);
                        break;
                    }
                    catch (URISyntaxException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
                default: {
                    r = value;
                }
            }
            return r;
        }

        void setDefault(String value) {
            this.def = this.getValue(value);
        }

        void setOptions(String options) {
            this.options = options;
        }
    }
}

