/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file;

import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Stack;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.graphstream.stream.SourceBase;
import org.graphstream.stream.file.FileSource;

public abstract class FileSourceXML
extends SourceBase
implements FileSource,
XMLStreamConstants {
    protected XMLEventReader reader;
    private Stack<XMLEvent> events = new Stack();

    protected FileSourceXML() {
    }

    @Override
    public void readAll(String fileName) throws IOException {
        this.readAll(new FileReader(fileName));
    }

    @Override
    public void readAll(URL url) throws IOException {
        this.readAll(url.openStream());
    }

    @Override
    public void readAll(InputStream stream) throws IOException {
        this.readAll(new InputStreamReader(stream));
    }

    @Override
    public void readAll(Reader reader) throws IOException {
        this.begin(reader);
        while (this.nextEvents()) {
        }
        this.end();
    }

    @Override
    public void begin(String fileName) throws IOException {
        this.begin(new FileReader(fileName));
    }

    @Override
    public void begin(URL url) throws IOException {
        this.begin(url.openStream());
    }

    @Override
    public void begin(InputStream stream) throws IOException {
        this.begin(new InputStreamReader(stream));
    }

    @Override
    public void begin(Reader reader) throws IOException {
        this.openStream(reader);
    }

    protected abstract void afterStartDocument() throws IOException, XMLStreamException;

    protected abstract void beforeEndDocument() throws IOException, XMLStreamException;

    @Override
    public abstract boolean nextEvents() throws IOException;

    @Override
    public boolean nextStep() throws IOException {
        return this.nextEvents();
    }

    @Override
    public void end() throws IOException {
        this.closeStream();
    }

    protected XMLEvent getNextEvent() throws IOException, XMLStreamException {
        this.skipWhiteSpaces();
        if (this.events.size() > 0) {
            return this.events.pop();
        }
        return this.reader.nextEvent();
    }

    protected void pushback(XMLEvent e) {
        this.events.push(e);
    }

    protected XMLStreamException newParseError(XMLEvent e, String msg, Object ... args) {
        return new XMLStreamException(String.format(msg, args), e.getLocation());
    }

    protected boolean isEvent(XMLEvent e, int type, String name) {
        boolean valid;
        boolean bl = valid = e.getEventType() == type;
        if (valid) {
            switch (type) {
                case 1: {
                    valid = e.asStartElement().getName().getLocalPart().equals(name);
                    break;
                }
                case 2: {
                    valid = e.asEndElement().getName().getLocalPart().equals(name);
                    break;
                }
                case 10: {
                    valid = ((Attribute)e).getName().getLocalPart().equals(name);
                    break;
                }
            }
        }
        return valid;
    }

    protected void checkValid(XMLEvent e, int type, String name) throws XMLStreamException {
        boolean valid = this.isEvent(e, type, name);
        if (!valid) {
            throw this.newParseError(e, "expecting %s, got %s", this.gotWhat(type, name), this.gotWhat(e));
        }
    }

    private String gotWhat(XMLEvent e) {
        String v = null;
        switch (e.getEventType()) {
            case 1: {
                v = e.asStartElement().getName().getLocalPart();
                break;
            }
            case 2: {
                v = e.asEndElement().getName().getLocalPart();
                break;
            }
            case 10: {
                v = ((Attribute)e).getName().getLocalPart();
            }
        }
        return this.gotWhat(e.getEventType(), v);
    }

    private String gotWhat(int type, String v) {
        switch (type) {
            case 1: {
                return String.format("'<%s>'", v);
            }
            case 2: {
                return String.format("'</%s>'", v);
            }
            case 10: {
                return String.format("attribute '%s'", v);
            }
            case 13: {
                return "namespace";
            }
            case 3: {
                return "processing instruction";
            }
            case 5: {
                return "comment";
            }
            case 7: {
                return "document start";
            }
            case 8: {
                return "document end";
            }
            case 11: {
                return "dtd";
            }
            case 4: {
                return "characters";
            }
        }
        return "UNKNOWN";
    }

    private void skipWhiteSpaces() throws IOException, XMLStreamException {
        XMLEvent e;
        while (this.isEvent(e = this.events.size() > 0 ? this.events.pop() : this.reader.nextEvent(), 4, null) && e.asCharacters().getData().matches("^\\s*$")) {
        }
        this.pushback(e);
    }

    protected void openStream(Reader stream) throws IOException {
        if (this.reader != null) {
            this.closeStream();
        }
        try {
            this.reader = XMLInputFactory.newInstance().createXMLEventReader(stream);
            XMLEvent e = this.getNextEvent();
            this.checkValid(e, 7, null);
            this.afterStartDocument();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new IOException(e);
        }
    }

    protected void closeStream() throws IOException {
        try {
            this.beforeEndDocument();
            this.reader.close();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
        finally {
            this.reader = null;
        }
    }

    protected String toConstantName(Attribute a) {
        return this.toConstantName(a.getName().getLocalPart());
    }

    protected String toConstantName(String value) {
        return value.toUpperCase().replaceAll("\\W", "_");
    }

    protected class Parser {
        protected Parser() {
        }

        protected String __characters() throws IOException, XMLStreamException {
            StringBuilder buffer = new StringBuilder();
            XMLEvent e = FileSourceXML.this.getNextEvent();
            while (e.getEventType() == 4) {
                buffer.append(e.asCharacters());
                e = FileSourceXML.this.getNextEvent();
            }
            FileSourceXML.this.pushback(e);
            return buffer.toString();
        }

        protected <T extends Enum<T>> EnumMap<T, String> getAttributes(Class<T> cls, StartElement e) {
            EnumMap<T, String> values = new EnumMap<T, String>(cls);
            Iterator<Attribute> attributes = e.asStartElement().getAttributes();
            block0: while (attributes.hasNext()) {
                Attribute a = attributes.next();
                for (int i = 0; i < ((Enum[])cls.getEnumConstants()).length; ++i) {
                    if (!((Enum[])cls.getEnumConstants())[i].name().equals(FileSourceXML.this.toConstantName(a))) continue;
                    values.put(((Enum[])cls.getEnumConstants())[i], a.getValue());
                    continue block0;
                }
            }
            return values;
        }

        protected <T extends Enum<T>> void checkRequiredAttributes(XMLEvent e, EnumMap<T, String> attributes, T ... required) throws XMLStreamException {
            if (required != null) {
                for (int i = 0; i < required.length; ++i) {
                    if (attributes.containsKey(required[i])) continue;
                    throw FileSourceXML.this.newParseError(e, "'%s' attribute is required for <%s> element", ((Enum)required[i]).name().toLowerCase(), e.asStartElement().getName().getLocalPart());
                }
            }
        }
    }
}

