/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.sync;

import java.security.AccessControlException;
import java.util.HashMap;

public class SinkTime {
    public static final String SYNC_DISABLE_KEY = "org.graphstream.stream.sync.disable";
    protected static final boolean disableSync;
    protected HashMap<String, Long> times = new HashMap();

    protected boolean setTimeFor(String sourceId, long timeId) {
        Long knownTimeId = this.times.get(sourceId);
        if (knownTimeId == null) {
            this.times.put(sourceId, timeId);
            return true;
        }
        if (timeId > knownTimeId) {
            this.times.put(sourceId, timeId);
            return true;
        }
        return false;
    }

    public boolean isNewEvent(String sourceId, long timeId) {
        return disableSync || this.setTimeFor(sourceId, timeId);
    }

    static {
        boolean off;
        try {
            off = System.getProperty(SYNC_DISABLE_KEY) != null;
        }
        catch (AccessControlException ex) {
            off = false;
        }
        disableSync = off;
    }
}

