/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.swingViewer;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics2D;
import org.graphstream.ui.graphicGraph.GraphicGraph;
import org.graphstream.ui.graphicGraph.StyleGroupListener;
import org.graphstream.ui.swingViewer.GraphRenderer;
import org.graphstream.ui.view.Selection;

public abstract class GraphRendererBase
implements GraphRenderer,
StyleGroupListener {
    protected GraphicGraph graph;
    protected Selection selection = null;
    protected Container renderingSurface;

    @Override
    public void open(GraphicGraph graph, Container renderingSurface) {
        if (this.graph != null) {
            throw new RuntimeException("renderer already open, cannot open twice");
        }
        this.graph = graph;
        this.renderingSurface = renderingSurface;
        this.graph.getStyleGroups().addListener(this);
    }

    @Override
    public void close() {
        if (this.graph != null) {
            this.graph.getStyleGroups().removeListener(this);
            this.graph = null;
        }
    }

    public Container getRenderingSurface() {
        return this.renderingSurface;
    }

    @Override
    public void beginSelectionAt(double x1, double y1) {
        if (this.selection == null) {
            this.selection = new Selection();
        }
        this.selection.x1 = x1;
        this.selection.y1 = y1;
        this.selection.x2 = x1;
        this.selection.y2 = y1;
    }

    @Override
    public void selectionGrowsAt(double x, double y) {
        this.selection.x2 = x;
        this.selection.y2 = y;
    }

    @Override
    public void endSelectionAt(double x2, double y2) {
        this.selection = null;
    }

    protected void displayNothingToDo(Graphics2D g, int w, int h) {
        String msg1 = "Graph width/height/depth is zero !!";
        String msg2 = "Place components using the 'xyz' attribute.";
        g.setColor(Color.RED);
        g.drawLine(0, 0, w, h);
        g.drawLine(0, h, w, 0);
        double msg1length = g.getFontMetrics().stringWidth(msg1);
        double msg2length = g.getFontMetrics().stringWidth(msg2);
        double x = w / 2;
        double y = h / 2;
        g.setColor(Color.BLACK);
        g.drawString(msg1, (float)(x - msg1length / 2.0), (float)(y - 20.0));
        g.drawString(msg2, (float)(x - msg2length / 2.0), (float)(y + 20.0));
    }
}

