/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.alerts;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.List;
import java.util.Set;
import org.graylog2.plugin.database.users.User;
import org.graylog2.shared.users.UserService;

public class EmailRecipients {
    private final UserService userService;
    private final List<String> usernames;
    private final List<String> emails;
    private Set<String> resolvedEmails;

    @Inject
    public EmailRecipients(UserService userService, @Assisted(value="usernames") List<String> usernames, @Assisted(value="emails") List<String> emails) {
        this.userService = userService;
        this.usernames = usernames;
        this.emails = emails;
    }

    public Set<String> getEmailRecipients() {
        if (this.resolvedEmails != null) {
            return this.resolvedEmails;
        }
        ImmutableSet.Builder emails = ImmutableSet.builder();
        emails.addAll(this.emails);
        for (String username : this.usernames) {
            User user = this.userService.load(username);
            if (user == null || Strings.isNullOrEmpty((String)user.getEmail())) continue;
            Iterable addresses = Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)user.getEmail());
            emails.addAll(addresses);
        }
        this.resolvedEmails = emails.build();
        return this.resolvedEmails;
    }

    public boolean isEmpty() {
        return this.usernames.isEmpty() && this.emails.isEmpty();
    }

    public static interface Factory {
        public EmailRecipients create(@Assisted(value="usernames") List<String> var1, @Assisted(value="emails") List<String> var2);
    }
}

