/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.alerts.types;

import com.google.common.collect.Lists;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.graylog2.alerts.AbstractAlertCondition;
import org.graylog2.indexer.FieldTypeException;
import org.graylog2.indexer.results.FieldStatsResult;
import org.graylog2.indexer.results.ResultMessage;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.MessageSummary;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.alarms.AlertCondition;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.configuration.fields.ConfigurationField;
import org.graylog2.plugin.configuration.fields.DropdownField;
import org.graylog2.plugin.configuration.fields.NumberField;
import org.graylog2.plugin.configuration.fields.TextField;
import org.graylog2.plugin.indexer.searches.timeranges.InvalidRangeParametersException;
import org.graylog2.plugin.indexer.searches.timeranges.RelativeRange;
import org.graylog2.plugin.streams.Stream;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldValueAlertCondition
extends AbstractAlertCondition {
    private static final Logger LOG = LoggerFactory.getLogger(FieldValueAlertCondition.class);
    private final int time;
    private final ThresholdType thresholdType;
    private final Number threshold;
    private final CheckType type;
    private final String field;
    private final DecimalFormat decimalFormat;
    private final Searches searches;

    @AssistedInject
    public FieldValueAlertCondition(Searches searches, @Assisted Stream stream, @Nullable @Assisted(value="id") String id, @Assisted DateTime createdAt, @Assisted(value="userid") String creatorUserId, @Assisted Map<String, Object> parameters, @Assisted(value="title") @Nullable String title) {
        super(stream, id, AbstractAlertCondition.Type.FIELD_VALUE.toString(), createdAt, creatorUserId, parameters, title);
        this.searches = searches;
        this.decimalFormat = new DecimalFormat("#.###", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        this.time = Tools.getNumber(parameters.get("time"), 5).intValue();
        this.thresholdType = ThresholdType.valueOf(((String)parameters.get("threshold_type")).toUpperCase(Locale.ENGLISH));
        this.threshold = Tools.getNumber(parameters.get("threshold"), 0.0).doubleValue();
        this.type = CheckType.valueOf(((String)parameters.get("type")).toUpperCase(Locale.ENGLISH));
        this.field = (String)parameters.get("field");
    }

    @Override
    public String getDescription() {
        return "time: " + this.time + ", field: " + this.field + ", check type: " + this.type.toString().toLowerCase(Locale.ENGLISH) + ", threshold_type: " + this.thresholdType.toString().toLowerCase(Locale.ENGLISH) + ", threshold: " + this.decimalFormat.format(this.threshold) + ", grace: " + this.grace + ", repeat notifications: " + this.repeatNotifications;
    }

    @Override
    public AbstractAlertCondition.CheckResult runCheck() {
        try {
            boolean triggered;
            double result;
            String filter = "streams:" + this.stream.getId();
            FieldStatsResult fieldStatsResult = this.searches.fieldStats(this.field, "*", filter, RelativeRange.create(this.time * 60), false, true, false);
            if (fieldStatsResult.getCount() == 0L) {
                LOG.debug("Alert check <{}> did not match any messages. Returning not triggered.", (Object)this.type);
                return new AbstractAlertCondition.NegativeCheckResult();
            }
            switch (this.type) {
                case MEAN: {
                    result = fieldStatsResult.getMean();
                    break;
                }
                case MIN: {
                    result = fieldStatsResult.getMin();
                    break;
                }
                case MAX: {
                    result = fieldStatsResult.getMax();
                    break;
                }
                case SUM: {
                    result = fieldStatsResult.getSum();
                    break;
                }
                case STDDEV: {
                    result = fieldStatsResult.getStdDeviation();
                    break;
                }
                default: {
                    LOG.error("No such field value check type: [{}]. Returning not triggered.", (Object)this.type);
                    return new AbstractAlertCondition.NegativeCheckResult();
                }
            }
            LOG.debug("Alert check <{}> result: [{}]", (Object)this.id, (Object)result);
            if (Double.isInfinite(result)) {
                LOG.debug("Infinite value. Returning not triggered.");
                return new AbstractAlertCondition.NegativeCheckResult();
            }
            switch (this.thresholdType) {
                case HIGHER: {
                    triggered = result > this.threshold.doubleValue();
                    break;
                }
                case LOWER: {
                    triggered = result < this.threshold.doubleValue();
                    break;
                }
                default: {
                    triggered = false;
                }
            }
            if (triggered) {
                ArrayList summaries;
                String resultDescription = "Field " + this.field + " had a " + (Object)((Object)this.type) + " of " + this.decimalFormat.format(result) + " in the last " + this.time + " minutes with trigger condition " + (Object)((Object)this.thresholdType) + " than " + this.decimalFormat.format(this.threshold) + ". (Current grace time: " + this.grace + " minutes)";
                if (this.getBacklog() > 0) {
                    List<ResultMessage> searchResult = fieldStatsResult.getSearchHits();
                    summaries = Lists.newArrayListWithCapacity((int)searchResult.size());
                    for (ResultMessage resultMessage : searchResult) {
                        Message msg = resultMessage.getMessage();
                        summaries.add(new MessageSummary(resultMessage.getIndex(), msg));
                    }
                } else {
                    summaries = Collections.emptyList();
                }
                return new AbstractAlertCondition.CheckResult(true, this, resultDescription, Tools.nowUTC(), summaries);
            }
            return new AbstractAlertCondition.NegativeCheckResult();
        }
        catch (InvalidRangeParametersException e) {
            LOG.error("Invalid timerange.", (Throwable)e);
            return null;
        }
        catch (FieldTypeException e) {
            LOG.debug("Field [{}] seems not to have a numerical type or doesn't even exist at all. Returning not triggered.", (Object)this.field, (Object)e);
            return new AbstractAlertCondition.NegativeCheckResult();
        }
    }

    public static class Descriptor
    extends AlertCondition.Descriptor {
        public Descriptor() {
            super("Field Aggregation Alert Condition", "https://www.graylog.org/", "This condition is triggered when the aggregated value of a field is higher/lower than a defined threshold for a given time range.");
        }
    }

    public static class Config
    implements AlertCondition.Config {
        @Override
        public ConfigurationRequest getRequestedConfiguration() {
            ConfigurationRequest configurationRequest = ConfigurationRequest.createWithFields(new TextField("field", "Field", "", "Field name that should be checked", ConfigurationField.Optional.NOT_OPTIONAL), new NumberField("time", "Time Range", 5, "Evaluate the condition for all messages received in the given number of minutes", ConfigurationField.Optional.NOT_OPTIONAL), new DropdownField("threshold_type", "Threshold Type", ThresholdType.HIGHER.toString(), DropdownField.ValueTemplates.valueMapFromEnum(ThresholdType.class, thresholdType -> thresholdType.name().toLowerCase(Locale.ENGLISH)), "Select condition to trigger alert: when value is higher or lower than the threshold", ConfigurationField.Optional.NOT_OPTIONAL), new NumberField("threshold", "Threshold", 0.0, "Value which triggers an alert if crossed", ConfigurationField.Optional.NOT_OPTIONAL), new DropdownField("type", "Aggregation Type", CheckType.MAX.toString(), Arrays.stream(CheckType.values()).collect(Collectors.toMap(Enum::toString, CheckType::getDescription)), "Select statistical function to use in the aggregation", ConfigurationField.Optional.NOT_OPTIONAL));
            configurationRequest.addFields(AbstractAlertCondition.getDefaultConfigurationFields());
            return configurationRequest;
        }
    }

    public static interface Factory
    extends AlertCondition.Factory {
        @Override
        public FieldValueAlertCondition create(Stream var1, @Assisted(value="id") String var2, DateTime var3, @Assisted(value="userid") String var4, Map<String, Object> var5, @Assisted(value="title") @Nullable String var6);

        @Override
        public Config config();

        @Override
        public Descriptor descriptor();
    }

    static enum ThresholdType {
        LOWER,
        HIGHER;

    }

    static enum CheckType {
        MEAN("mean value"),
        MIN("min value"),
        MAX("max value"),
        SUM("sum"),
        STDDEV("standard deviation");

        private final String description;

        private CheckType(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

