/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.buffers;

import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.graylog2.buffers.OutputBuffer;
import org.graylog2.shared.buffers.ProcessBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Buffers {
    private static final Logger LOG = LoggerFactory.getLogger(Buffers.class);
    private static final long DEFAULT_MAX_WAIT = 30L;
    private final ProcessBuffer processBuffer;
    private final OutputBuffer outputBuffer;

    @Inject
    public Buffers(ProcessBuffer processBuffer, OutputBuffer outputBuffer) {
        this.processBuffer = processBuffer;
        this.outputBuffer = outputBuffer;
    }

    public void waitForEmptyBuffers() {
        this.waitForEmptyBuffers(30L, TimeUnit.SECONDS);
    }

    public void waitForEmptyBuffers(long maxWait, TimeUnit timeUnit) {
        LOG.info("Waiting until all buffers are empty.");
        Callable<Boolean> checkForEmptyBuffers = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                if (Buffers.this.processBuffer.isEmpty() && Buffers.this.outputBuffer.isEmpty()) {
                    return true;
                }
                LOG.info("Waiting for buffers to drain. ({}p/{}o)", (Object)Buffers.this.processBuffer.getUsage(), (Object)Buffers.this.outputBuffer.getUsage());
                return false;
            }
        };
        Retryer retryer = RetryerBuilder.newBuilder().retryIfResult(Predicates.not((Predicate)Predicates.equalTo((Object)Boolean.TRUE))).withWaitStrategy(WaitStrategies.fixedWait((long)1L, (TimeUnit)TimeUnit.SECONDS)).withStopStrategy(StopStrategies.stopAfterDelay((long)maxWait, (TimeUnit)timeUnit)).build();
        try {
            retryer.call((Callable)checkForEmptyBuffers);
        }
        catch (RetryException e) {
            LOG.info("Buffers not empty after {} {}. Giving up.", (Object)maxWait, (Object)timeUnit.name().toLowerCase(Locale.ENGLISH));
            return;
        }
        catch (ExecutionException e) {
            LOG.error("Error while waiting for empty buffers.", (Throwable)e);
            return;
        }
        LOG.info("All buffers are empty. Continuing.");
    }
}

