/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.configuration;

import com.github.joschi.jadconfig.Parameter;
import com.github.joschi.jadconfig.util.Duration;
import com.github.joschi.jadconfig.validators.PositiveDurationValidator;
import com.github.joschi.jadconfig.validators.PositiveIntegerValidator;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.graylog2.configuration.converters.URIListConverter;
import org.graylog2.configuration.validators.ListOfURIsWithHostAndSchemeValidator;
import org.graylog2.configuration.validators.NonEmptyListValidator;

public class ElasticsearchClientConfiguration {
    @Parameter(value="elasticsearch_hosts", converter=URIListConverter.class, validators={NonEmptyListValidator.class, ListOfURIsWithHostAndSchemeValidator.class})
    List<URI> elasticsearchHosts = Collections.singletonList(URI.create("http://127.0.0.1:9200"));
    @Parameter(value="elasticsearch_connect_timeout")
    Duration elasticsearchConnectTimeout = Duration.seconds((long)10L);
    @Parameter(value="elasticsearch_socket_timeout", validators={PositiveDurationValidator.class})
    Duration elasticsearchSocketTimeout = Duration.seconds((long)60L);
    @Parameter(value="elasticsearch_idle_timeout")
    Duration elasticsearchIdleTimeout = Duration.seconds((long)-1L);
    @Parameter(value="elasticsearch_max_total_connections", validators={PositiveIntegerValidator.class})
    int elasticsearchMaxTotalConnections = 20;
    @Parameter(value="elasticsearch_max_total_connections_per_route", validators={PositiveIntegerValidator.class})
    int elasticsearchMaxTotalConnectionsPerRoute = 2;
    @Parameter(value="elasticsearch_max_retries", validators={PositiveIntegerValidator.class})
    int elasticsearchMaxRetries = 2;
    @Parameter(value="elasticsearch_discovery_enabled")
    boolean discoveryEnabled = false;
    @Parameter(value="elasticsearch_discovery_filter")
    String discoveryFilter = null;
    @Parameter(value="elasticsearch_discovery_frequency", validator=PositiveDurationValidator.class)
    Duration discoveryFrequency = Duration.seconds((long)30L);
    @Parameter(value="elasticsearch_compression_enabled")
    boolean compressionEnabled = false;
}

