/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.grok;

import com.google.common.base.Strings;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import oi.thekraken.grok.api.Grok;
import oi.thekraken.grok.api.exception.GrokException;
import org.graylog2.database.NotFoundException;
import org.graylog2.grok.GrokPattern;
import org.graylog2.grok.GrokPatternService;
import org.graylog2.plugin.database.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryGrokPatternService
implements GrokPatternService {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryGrokPatternService.class);
    private AtomicLong idGen = new AtomicLong(0L);
    private final ConcurrentMap<String, GrokPattern> store = new MapMaker().makeMap();

    @Override
    public GrokPattern load(String patternId) throws NotFoundException {
        GrokPattern pattern = (GrokPattern)this.store.get(patternId);
        if (pattern == null) {
            throw new NotFoundException("Couldn't find Grok pattern with ID " + patternId);
        }
        return pattern;
    }

    @Override
    public Set<GrokPattern> loadAll() {
        return Sets.newHashSet(this.store.values());
    }

    @Override
    public GrokPattern save(GrokPattern pattern) throws ValidationException {
        if (!this.validate(pattern)) {
            throw new ValidationException("Pattern named " + pattern.name() + " is not valid!");
        }
        GrokPattern toSave = pattern.id() == null ? pattern.toBuilder().id(this.createId()).build() : pattern;
        this.store.put(toSave.id(), toSave);
        return toSave;
    }

    private GrokPattern uncheckedSave(GrokPattern pattern) {
        try {
            return this.save(pattern);
        }
        catch (ValidationException e) {
            return null;
        }
    }

    @Override
    public List<GrokPattern> saveAll(Collection<GrokPattern> patterns, boolean replace) throws ValidationException {
        for (GrokPattern pattern : patterns) {
            if (this.validate(pattern)) continue;
            throw new ValidationException("Pattern " + pattern.name() + " invalid.");
        }
        if (replace) {
            this.deleteAll();
        }
        return patterns.stream().map(this::uncheckedSave).collect(Collectors.toList());
    }

    @Override
    public boolean validate(GrokPattern pattern) {
        boolean fieldsMissing = !Strings.isNullOrEmpty((String)pattern.name()) && !Strings.isNullOrEmpty((String)pattern.pattern());
        try {
            Grok grok = new Grok();
            grok.addPattern(pattern.name(), pattern.pattern());
            grok.compile("%{" + pattern.name() + "}");
        }
        catch (GrokException grok) {
        }
        catch (PatternSyntaxException e) {
            LOG.warn("Invalid regular expression syntax for '" + pattern.name() + "' with pattern " + pattern.pattern(), (Throwable)e);
            return false;
        }
        return fieldsMissing;
    }

    @Override
    public int delete(String patternId) {
        return this.store.remove(patternId) == null ? 0 : 1;
    }

    @Override
    public int deleteAll() {
        int size = this.store.size();
        this.store.clear();
        return size;
    }

    private String createId() {
        return String.valueOf(this.idGen.incrementAndGet());
    }
}

