/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.results;

import com.google.common.collect.Maps;
import io.searchbox.core.search.aggregation.HistogramAggregation;
import java.util.Collections;
import java.util.Map;
import org.graylog2.indexer.results.HistogramResult;
import org.graylog2.indexer.searches.Searches;
import org.joda.time.DateTime;

public class DateHistogramResult
extends HistogramResult {
    private final Map<Long, Long> result;
    private final Searches.DateHistogramInterval interval;

    public static DateHistogramResult empty(String originalQuery, String builtQuery, Searches.DateHistogramInterval interval) {
        return new DateHistogramResult(originalQuery, builtQuery, interval);
    }

    private DateHistogramResult(String originalQuery, String builtQuery, Searches.DateHistogramInterval interval) {
        super(originalQuery, builtQuery, 0L);
        this.result = Collections.emptyMap();
        this.interval = interval;
    }

    public DateHistogramResult(HistogramAggregation result, String originalQuery, String builtQuery, Searches.DateHistogramInterval interval, long tookMs) {
        super(originalQuery, builtQuery, tookMs);
        this.result = Maps.newTreeMap();
        for (HistogramAggregation.Histogram histogram : result.getBuckets()) {
            DateTime keyAsDate = new DateTime((Object)histogram.getKey());
            this.result.put(keyAsDate.getMillis() / 1000L, histogram.getCount());
        }
        this.interval = interval;
    }

    @Override
    public Searches.DateHistogramInterval getInterval() {
        return this.interval;
    }

    @Override
    public Map<Long, Long> getResults() {
        return this.result;
    }
}

