/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.results;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.graylog2.indexer.ranges.IndexRange;
import org.graylog2.indexer.results.IndexQueryResult;
import org.graylog2.indexer.results.ResultMessage;
import org.graylog2.plugin.Message;

public class SearchResult
extends IndexQueryResult {
    private final long totalResults;
    private final List<ResultMessage> results;
    private final Set<String> fields;
    private final Set<IndexRange> usedIndices;

    public SearchResult(List<ResultMessage> hits, long totalResults, Set<IndexRange> usedIndices, String originalQuery, String builtQuery, long tookMs) {
        super(originalQuery, builtQuery, tookMs);
        this.results = hits;
        this.fields = this.extractFields(hits);
        this.totalResults = totalResults;
        this.usedIndices = usedIndices;
    }

    private SearchResult(String query, String originalQuery) {
        super(query, originalQuery, 0L);
        this.results = Collections.emptyList();
        this.fields = Collections.emptySet();
        this.usedIndices = Collections.emptySet();
        this.totalResults = 0L;
    }

    public long getTotalResults() {
        return this.totalResults;
    }

    public List<ResultMessage> getResults() {
        return this.results;
    }

    public Set<String> getFields() {
        return this.fields;
    }

    @VisibleForTesting
    Set<String> extractFields(List<ResultMessage> hits) {
        HashSet filteredFields = Sets.newHashSet();
        hits.forEach(hit -> {
            Message message = hit.getMessage();
            for (String field : message.getFieldNames()) {
                if (Message.FILTERED_FIELDS.contains((Object)field)) continue;
                filteredFields.add(field);
            }
        });
        return filteredFields;
    }

    public Set<IndexRange> getUsedIndices() {
        return this.usedIndices;
    }

    public static SearchResult empty(String query, String originalQuery) {
        return new SearchResult(query, originalQuery);
    }
}

