/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.retention.strategies;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.periodical.IndexRetentionThread;
import org.graylog2.plugin.indexer.retention.RetentionStrategy;
import org.graylog2.shared.system.activities.Activity;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIndexCountBasedRetentionStrategy
implements RetentionStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractIndexCountBasedRetentionStrategy.class);
    private final Indices indices;
    private final ActivityWriter activityWriter;

    public AbstractIndexCountBasedRetentionStrategy(Indices indices, ActivityWriter activityWriter) {
        this.indices = Objects.requireNonNull(indices);
        this.activityWriter = Objects.requireNonNull(activityWriter);
    }

    protected abstract Optional<Integer> getMaxNumberOfIndices(IndexSet var1);

    protected abstract void retain(String var1, IndexSet var2);

    @Override
    public void retain(IndexSet indexSet) {
        Map<String, Set<String>> deflectorIndices = indexSet.getAllIndexAliases();
        int indexCount = (int)deflectorIndices.keySet().stream().filter(indexName -> !this.indices.isReopened((String)indexName)).count();
        Optional<Integer> maxIndices = this.getMaxNumberOfIndices(indexSet);
        if (!maxIndices.isPresent()) {
            LOG.warn("No retention strategy configuration found, not running index retention!");
            return;
        }
        if (indexCount <= maxIndices.get()) {
            LOG.debug("Number of indices ({}) lower than limit ({}). Not performing any retention actions.", (Object)indexCount, (Object)maxIndices.get());
            return;
        }
        int removeCount = indexCount - maxIndices.get();
        String msg = "Number of indices (" + indexCount + ") higher than limit (" + maxIndices.get() + "). Running retention for " + removeCount + " indices.";
        LOG.info(msg);
        this.activityWriter.write(new Activity(msg, IndexRetentionThread.class));
        this.runRetention(indexSet, deflectorIndices, removeCount);
    }

    private void runRetention(IndexSet indexSet, Map<String, Set<String>> deflectorIndices, int removeCount) {
        Set orderedIndices = Arrays.stream(indexSet.getManagedIndices()).filter(indexName -> !this.indices.isReopened((String)indexName)).filter(indexName -> !deflectorIndices.getOrDefault(indexName, Collections.emptySet()).contains(indexSet.getWriteIndexAlias())).sorted((indexName1, indexName2) -> indexSet.extractIndexNumber((String)indexName2).orElse(0).compareTo(indexSet.extractIndexNumber((String)indexName1).orElse(0))).collect(Collectors.toCollection(LinkedHashSet::new));
        orderedIndices.stream().skip(orderedIndices.size() - removeCount).forEach(indexName -> {
            String strategyName = this.getClass().getCanonicalName();
            String msg = "Running retention strategy [" + strategyName + "] for index <" + indexName + ">";
            LOG.info(msg);
            this.activityWriter.write(new Activity(msg, IndexRetentionThread.class));
            this.retain((String)indexName, indexSet);
        });
    }
}

