/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.converters;

import com.google.common.base.Strings;
import java.util.Map;
import org.graylog2.ConfigurationException;
import org.graylog2.lookup.LookupTableService;
import org.graylog2.plugin.inputs.Converter;
import org.graylog2.plugin.lookup.LookupResult;

public class LookupTableConverter
extends Converter {
    private static final String CONFIG_LOOKUP_TABLE_NAME = "lookup_table_name";
    private final LookupTableService.Function lookupTable;

    public LookupTableConverter(Map<String, Object> config, LookupTableService lookupTableService) throws ConfigurationException {
        super(Converter.Type.LOOKUP_TABLE, config);
        String lookupTableName = (String)config.get(CONFIG_LOOKUP_TABLE_NAME);
        if (Strings.isNullOrEmpty((String)lookupTableName)) {
            throw new ConfigurationException("Missing converter config value: lookup_table_name");
        }
        if (!lookupTableService.hasTable(lookupTableName)) {
            throw new IllegalStateException("Configured lookup table <" + lookupTableName + "> doesn't exist");
        }
        this.lookupTable = lookupTableService.newBuilder().lookupTable(lookupTableName).build();
    }

    @Override
    public Object convert(String value) {
        LookupResult result = this.lookupTable.lookup(value);
        if (result == null || result.isEmpty()) {
            return value;
        }
        return result.singleValue();
    }

    @Override
    public boolean buildsMultipleFields() {
        return false;
    }
}

